/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField$Converter;
import com.google.protobuf.MapField$ImmutableMessageConverter;
import com.google.protobuf.MapField$MutatabilityAwareMap;
import com.google.protobuf.MapField$StorageMode;
import com.google.protobuf.MapFieldLite;
import com.google.protobuf.Message;
import com.google.protobuf.MutabilityOracle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapField<K, V>
implements MutabilityOracle {
    private volatile boolean isMutable;
    private volatile MapField$StorageMode mode;
    private MapField$MutatabilityAwareMap<K, V> mapData;
    private List<Message> listData;
    private final MapField$Converter<K, V> converter;

    private MapField(MapField$Converter<K, V> mapField$Converter, MapField$StorageMode mapField$StorageMode, Map<K, V> map) {
        this.converter = mapField$Converter;
        this.isMutable = true;
        this.mode = mapField$StorageMode;
        this.mapData = new MapField$MutatabilityAwareMap<K, V>(this, map);
        this.listData = null;
    }

    private MapField(MapEntry<K, V> mapEntry, MapField$StorageMode mapField$StorageMode, Map<K, V> map) {
        this(new MapField$ImmutableMessageConverter<K, V>(mapEntry), mapField$StorageMode, map);
    }

    public static <K, V> MapField<K, V> emptyMapField(MapEntry<K, V> mapEntry) {
        return new MapField<K, V>(mapEntry, MapField$StorageMode.MAP, Collections.emptyMap());
    }

    public static <K, V> MapField<K, V> newMapField(MapEntry<K, V> mapEntry) {
        return new MapField<K, V>(mapEntry, MapField$StorageMode.MAP, new LinkedHashMap());
    }

    private Message convertKeyAndValueToMessage(K k, V v) {
        return this.converter.convertKeyAndValueToMessage(k, v);
    }

    private void convertMessageToKeyAndValue(Message message, Map<K, V> map) {
        this.converter.convertMessageToKeyAndValue(message, map);
    }

    private List<Message> convertMapToList(MapField$MutatabilityAwareMap<K, V> mapField$MutatabilityAwareMap) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (Map.Entry<K, V> entry : mapField$MutatabilityAwareMap.entrySet()) {
            arrayList.add(this.convertKeyAndValueToMessage(entry.getKey(), entry.getValue()));
        }
        return arrayList;
    }

    private MapField$MutatabilityAwareMap<K, V> convertListToMap(List<Message> list) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Message message : list) {
            this.convertMessageToKeyAndValue(message, linkedHashMap);
        }
        return new MapField$MutatabilityAwareMap(this, linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getMap() {
        if (this.mode == MapField$StorageMode.LIST) {
            MapField mapField = this;
            synchronized (mapField) {
                if (this.mode == MapField$StorageMode.LIST) {
                    this.mapData = this.convertListToMap(this.listData);
                    this.mode = MapField$StorageMode.BOTH;
                }
            }
        }
        return Collections.unmodifiableMap(this.mapData);
    }

    public Map<K, V> getMutableMap() {
        if (this.mode != MapField$StorageMode.MAP) {
            if (this.mode == MapField$StorageMode.LIST) {
                this.mapData = this.convertListToMap(this.listData);
            }
            this.listData = null;
            this.mode = MapField$StorageMode.MAP;
        }
        return this.mapData;
    }

    public void mergeFrom(MapField<K, V> mapField) {
        this.getMutableMap().putAll(MapFieldLite.copy(mapField.getMap()));
    }

    public void clear() {
        this.mapData = new MapField$MutatabilityAwareMap(this, new LinkedHashMap());
        this.mode = MapField$StorageMode.MAP;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapField)) {
            return false;
        }
        MapField mapField = (MapField)object;
        return MapFieldLite.equals(this.getMap(), mapField.getMap());
    }

    public int hashCode() {
        return MapFieldLite.calculateHashCodeForMap(this.getMap());
    }

    public MapField<K, V> copy() {
        return new MapField<K, V>(this.converter, MapField$StorageMode.MAP, MapFieldLite.copy(this.getMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Message> getList() {
        if (this.mode == MapField$StorageMode.MAP) {
            MapField mapField = this;
            synchronized (mapField) {
                if (this.mode == MapField$StorageMode.MAP) {
                    this.listData = this.convertMapToList(this.mapData);
                    this.mode = MapField$StorageMode.BOTH;
                }
            }
        }
        return Collections.unmodifiableList(this.listData);
    }

    List<Message> getMutableList() {
        if (this.mode != MapField$StorageMode.LIST) {
            if (this.mode == MapField$StorageMode.MAP) {
                this.listData = this.convertMapToList(this.mapData);
            }
            this.mapData = null;
            this.mode = MapField$StorageMode.LIST;
        }
        return this.listData;
    }

    Message getMapEntryMessageDefaultInstance() {
        return this.converter.getMessageDefaultInstance();
    }

    public void makeImmutable() {
        this.isMutable = false;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public void ensureMutable() {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException();
        }
    }
}

