/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.GeneratedMessageLite$ExtendableMessage;
import com.google.protobuf.GeneratedMessageLite$ExtensionDescriptor;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormatEscaper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

final class MessageLiteToString {
    private static final String LIST_SUFFIX = "List";
    private static final String BUILDER_LIST_SUFFIX = "OrBuilderList";
    private static final String MAP_SUFFIX = "Map";
    private static final String BYTES_SUFFIX = "Bytes";

    MessageLiteToString() {
    }

    static String toString(MessageLite messageLite, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# ").append(string);
        MessageLiteToString.reflectivePrintWithIndent(messageLite, stringBuilder, 0);
        return stringBuilder.toString();
    }

    private static void reflectivePrintWithIndent(MessageLite messageLite, StringBuilder stringBuilder, int n) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        HashMap<String, Method> hashMap2 = new HashMap<String, Method>();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Method object2 : messageLite.getClass().getDeclaredMethods()) {
            hashMap2.put(object2.getName(), object2);
            if (object2.getParameterTypes().length != 0) continue;
            hashMap.put(object2.getName(), object2);
            if (!object2.getName().startsWith("get")) continue;
            treeSet.add(object2.getName());
        }
        for (String string : treeSet) {
            Object object;
            String string2 = string.replaceFirst("get", "");
            if (string2.endsWith(LIST_SUFFIX) && !string2.endsWith(BUILDER_LIST_SUFFIX) && !string2.equals(LIST_SUFFIX)) {
                String string3 = String.valueOf(string2.substring(0, 1).toLowerCase());
                String string4 = String.valueOf(string2.substring(1, string2.length() - LIST_SUFFIX.length()));
                String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                object = (Method)hashMap.get(string);
                if (object != null && ((Method)object).getReturnType().equals(List.class)) {
                    MessageLiteToString.printField(stringBuilder, n, MessageLiteToString.camelCaseToSnakeCase(string5), GeneratedMessageLite.invokeOrDie((Method)object, messageLite, new Object[0]));
                    continue;
                }
            }
            if (string2.endsWith(MAP_SUFFIX) && !string2.equals(MAP_SUFFIX)) {
                String string6 = String.valueOf(string2.substring(0, 1).toLowerCase());
                String string7 = String.valueOf(string2.substring(1, string2.length() - MAP_SUFFIX.length()));
                String string8 = string7.length() != 0 ? string6.concat(string7) : new String(string6);
                object = (Method)hashMap.get(string);
                if (object != null && ((Method)object).getReturnType().equals(Map.class) && !((AccessibleObject)object).isAnnotationPresent(Deprecated.class) && Modifier.isPublic(((Method)object).getModifiers())) {
                    MessageLiteToString.printField(stringBuilder, n, MessageLiteToString.camelCaseToSnakeCase(string8), GeneratedMessageLite.invokeOrDie((Method)object, messageLite, new Object[0]));
                    continue;
                }
            }
            String string9 = String.valueOf(string2);
            Method method = (Method)hashMap2.get(string9.length() != 0 ? "set".concat(string9) : new String("set"));
            if (method == null) continue;
            if (string2.endsWith(BYTES_SUFFIX)) {
                String string10 = String.valueOf(string2.substring(0, string2.length() - BYTES_SUFFIX.length()));
                if (hashMap.containsKey(string10.length() != 0 ? "get".concat(string10) : new String("get"))) continue;
            }
            String string11 = String.valueOf(string2.substring(0, 1).toLowerCase());
            String string12 = String.valueOf(string2.substring(1));
            object = string12.length() != 0 ? string11.concat(string12) : new String(string11);
            String string13 = String.valueOf(string2);
            Method method2 = (Method)hashMap.get(string13.length() != 0 ? "get".concat(string13) : new String("get"));
            String string14 = String.valueOf(string2);
            Method method3 = (Method)hashMap.get(string14.length() != 0 ? "has".concat(string14) : new String("has"));
            if (method2 == null) continue;
            Object object2 = GeneratedMessageLite.invokeOrDie(method2, messageLite, new Object[0]);
            boolean bl = method3 == null ? !MessageLiteToString.isDefaultValue(object2) : (Boolean)GeneratedMessageLite.invokeOrDie(method3, messageLite, new Object[0]);
            boolean bl2 = bl;
            if (!bl2) continue;
            MessageLiteToString.printField(stringBuilder, n, MessageLiteToString.camelCaseToSnakeCase((String)object), object2);
        }
        if (messageLite instanceof GeneratedMessageLite$ExtendableMessage) {
            Iterator<Map.Entry<GeneratedMessageLite$ExtensionDescriptor, Object>> iterator = ((GeneratedMessageLite$ExtendableMessage)messageLite).extensions.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                int n2 = ((GeneratedMessageLite$ExtensionDescriptor)entry.getKey()).getNumber();
                MessageLiteToString.printField(stringBuilder, n, new StringBuilder(13).append("[").append(n2).append("]").toString(), entry.getValue());
            }
        }
        if (((GeneratedMessageLite)messageLite).unknownFields != null) {
            ((GeneratedMessageLite)messageLite).unknownFields.printWithIndent(stringBuilder, n);
        }
    }

    private static boolean isDefaultValue(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        if (object instanceof Integer) {
            return (Integer)object == 0;
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue() == 0.0f;
        }
        if (object instanceof Double) {
            return (Double)object == 0.0;
        }
        if (object instanceof String) {
            return object.equals("");
        }
        if (object instanceof ByteString) {
            return object.equals(ByteString.EMPTY);
        }
        if (object instanceof MessageLite) {
            return object == ((MessageLite)object).getDefaultInstanceForType();
        }
        if (object instanceof Enum) {
            return ((Enum)object).ordinal() == 0;
        }
        return false;
    }

    static final void printField(StringBuilder stringBuilder, int n, String string, Object object) {
        int n2;
        if (object instanceof List) {
            List list = (List)object;
            for (Object e2 : list) {
                MessageLiteToString.printField(stringBuilder, n, string, e2);
            }
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                MessageLiteToString.printField(stringBuilder, n, string, entry);
            }
            return;
        }
        stringBuilder.append('\n');
        for (n2 = 0; n2 < n; ++n2) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
        if (object instanceof String) {
            stringBuilder.append(": \"").append(TextFormatEscaper.escapeText((String)object)).append('\"');
        } else if (object instanceof ByteString) {
            stringBuilder.append(": \"").append(TextFormatEscaper.escapeBytes((ByteString)object)).append('\"');
        } else if (object instanceof GeneratedMessageLite) {
            stringBuilder.append(" {");
            MessageLiteToString.reflectivePrintWithIndent((GeneratedMessageLite)object, stringBuilder, n + 2);
            stringBuilder.append("\n");
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("}");
        } else if (object instanceof Map.Entry) {
            stringBuilder.append(" {");
            Map.Entry entry = (Map.Entry)object;
            MessageLiteToString.printField(stringBuilder, n + 2, "key", entry.getKey());
            MessageLiteToString.printField(stringBuilder, n + 2, "value", entry.getValue());
            stringBuilder.append("\n");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("}");
        } else {
            stringBuilder.append(": ").append(object.toString());
        }
    }

    private static final String camelCaseToSnakeCase(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isUpperCase(c2)) {
                stringBuilder.append("_");
            }
            stringBuilder.append(Character.toLowerCase(c2));
        }
        return stringBuilder.toString();
    }
}

