/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.GeneratedMessage$Builder;
import com.google.protobuf.GeneratedMessage$BuilderParent;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RepeatedFieldBuilder$BuilderExternalList;
import com.google.protobuf.RepeatedFieldBuilder$MessageExternalList;
import com.google.protobuf.RepeatedFieldBuilder$MessageOrBuilderExternalList;
import com.google.protobuf.SingleFieldBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RepeatedFieldBuilder<MType extends GeneratedMessage, BType extends GeneratedMessage$Builder, IType extends MessageOrBuilder>
implements GeneratedMessage$BuilderParent {
    private GeneratedMessage$BuilderParent parent;
    private List<MType> messages;
    private boolean isMessagesListMutable;
    private List<SingleFieldBuilder<MType, BType, IType>> builders;
    private boolean isClean;
    private RepeatedFieldBuilder$MessageExternalList<MType, BType, IType> externalMessageList;
    private RepeatedFieldBuilder$BuilderExternalList<MType, BType, IType> externalBuilderList;
    private RepeatedFieldBuilder$MessageOrBuilderExternalList<MType, BType, IType> externalMessageOrBuilderList;

    public RepeatedFieldBuilder(List<MType> list, boolean bl, GeneratedMessage$BuilderParent generatedMessage$BuilderParent, boolean bl2) {
        this.messages = list;
        this.isMessagesListMutable = bl;
        this.parent = generatedMessage$BuilderParent;
        this.isClean = bl2;
    }

    public void dispose() {
        this.parent = null;
    }

    private void ensureMutableMessageList() {
        if (!this.isMessagesListMutable) {
            this.messages = new ArrayList<MType>(this.messages);
            this.isMessagesListMutable = true;
        }
    }

    private void ensureBuilders() {
        if (this.builders == null) {
            this.builders = new ArrayList<SingleFieldBuilder<MType, BType, IType>>(this.messages.size());
            for (int i = 0; i < this.messages.size(); ++i) {
                this.builders.add(null);
            }
        }
    }

    public int getCount() {
        return this.messages.size();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public MType getMessage(int n) {
        return this.getMessage(n, false);
    }

    private MType getMessage(int n, boolean bl) {
        if (this.builders == null) {
            return (MType)((GeneratedMessage)this.messages.get(n));
        }
        SingleFieldBuilder<MType, BType, IType> singleFieldBuilder = this.builders.get(n);
        if (singleFieldBuilder == null) {
            return (MType)((GeneratedMessage)this.messages.get(n));
        }
        return bl ? singleFieldBuilder.build() : singleFieldBuilder.getMessage();
    }

    public BType getBuilder(int n) {
        this.ensureBuilders();
        SingleFieldBuilder<Object, BType, IType> singleFieldBuilder = this.builders.get(n);
        if (singleFieldBuilder == null) {
            GeneratedMessage generatedMessage = (GeneratedMessage)this.messages.get(n);
            singleFieldBuilder = new SingleFieldBuilder(generatedMessage, this, this.isClean);
            this.builders.set(n, singleFieldBuilder);
        }
        return singleFieldBuilder.getBuilder();
    }

    public IType getMessageOrBuilder(int n) {
        if (this.builders == null) {
            return (IType)((MessageOrBuilder)this.messages.get(n));
        }
        SingleFieldBuilder<MType, BType, IType> singleFieldBuilder = this.builders.get(n);
        if (singleFieldBuilder == null) {
            return (IType)((MessageOrBuilder)this.messages.get(n));
        }
        return singleFieldBuilder.getMessageOrBuilder();
    }

    public RepeatedFieldBuilder<MType, BType, IType> setMessage(int n, MType MType) {
        SingleFieldBuilder singleFieldBuilder;
        Internal.checkNotNull(MType);
        this.ensureMutableMessageList();
        this.messages.set(n, MType);
        if (this.builders != null && (singleFieldBuilder = (SingleFieldBuilder)this.builders.set(n, null)) != null) {
            singleFieldBuilder.dispose();
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public RepeatedFieldBuilder<MType, BType, IType> addMessage(MType MType) {
        Internal.checkNotNull(MType);
        this.ensureMutableMessageList();
        this.messages.add(MType);
        if (this.builders != null) {
            this.builders.add(null);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public RepeatedFieldBuilder<MType, BType, IType> addMessage(int n, MType MType) {
        Internal.checkNotNull(MType);
        this.ensureMutableMessageList();
        this.messages.add(n, MType);
        if (this.builders != null) {
            this.builders.add(n, null);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public RepeatedFieldBuilder<MType, BType, IType> addAllMessages(Iterable<? extends MType> iterable) {
        for (Object object : iterable) {
            Internal.checkNotNull(object);
        }
        int n = -1;
        if (iterable instanceof Collection) {
            Object object;
            object = (Collection)iterable;
            if (object.size() == 0) {
                return this;
            }
            n = object.size();
        }
        this.ensureMutableMessageList();
        if (n >= 0 && this.messages instanceof ArrayList) {
            ((ArrayList)this.messages).ensureCapacity(this.messages.size() + n);
        }
        for (GeneratedMessage generatedMessage : iterable) {
            this.addMessage(generatedMessage);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public BType addBuilder(MType MType) {
        this.ensureMutableMessageList();
        this.ensureBuilders();
        SingleFieldBuilder singleFieldBuilder = new SingleFieldBuilder(MType, this, this.isClean);
        this.messages.add(null);
        this.builders.add(singleFieldBuilder);
        this.onChanged();
        this.incrementModCounts();
        return singleFieldBuilder.getBuilder();
    }

    public BType addBuilder(int n, MType MType) {
        this.ensureMutableMessageList();
        this.ensureBuilders();
        SingleFieldBuilder singleFieldBuilder = new SingleFieldBuilder(MType, this, this.isClean);
        this.messages.add(n, null);
        this.builders.add(n, singleFieldBuilder);
        this.onChanged();
        this.incrementModCounts();
        return singleFieldBuilder.getBuilder();
    }

    public void remove(int n) {
        SingleFieldBuilder<MType, BType, IType> singleFieldBuilder;
        this.ensureMutableMessageList();
        this.messages.remove(n);
        if (this.builders != null && (singleFieldBuilder = this.builders.remove(n)) != null) {
            singleFieldBuilder.dispose();
        }
        this.onChanged();
        this.incrementModCounts();
    }

    public void clear() {
        this.messages = Collections.emptyList();
        this.isMessagesListMutable = false;
        if (this.builders != null) {
            for (SingleFieldBuilder<MType, BType, IType> singleFieldBuilder : this.builders) {
                if (singleFieldBuilder == null) continue;
                singleFieldBuilder.dispose();
            }
            this.builders = null;
        }
        this.onChanged();
        this.incrementModCounts();
    }

    public List<MType> build() {
        int n;
        this.isClean = true;
        if (!this.isMessagesListMutable && this.builders == null) {
            return this.messages;
        }
        boolean bl = true;
        if (!this.isMessagesListMutable) {
            for (n = 0; n < this.messages.size(); ++n) {
                Message message = (Message)this.messages.get(n);
                SingleFieldBuilder<MType, BType, IType> singleFieldBuilder = this.builders.get(n);
                if (singleFieldBuilder == null || singleFieldBuilder.build() == message) continue;
                bl = false;
                break;
            }
            if (bl) {
                return this.messages;
            }
        }
        this.ensureMutableMessageList();
        for (n = 0; n < this.messages.size(); ++n) {
            this.messages.set(n, this.getMessage(n, true));
        }
        this.messages = Collections.unmodifiableList(this.messages);
        this.isMessagesListMutable = false;
        return this.messages;
    }

    public List<MType> getMessageList() {
        if (this.externalMessageList == null) {
            this.externalMessageList = new RepeatedFieldBuilder$MessageExternalList(this);
        }
        return this.externalMessageList;
    }

    public List<BType> getBuilderList() {
        if (this.externalBuilderList == null) {
            this.externalBuilderList = new RepeatedFieldBuilder$BuilderExternalList(this);
        }
        return this.externalBuilderList;
    }

    public List<IType> getMessageOrBuilderList() {
        if (this.externalMessageOrBuilderList == null) {
            this.externalMessageOrBuilderList = new RepeatedFieldBuilder$MessageOrBuilderExternalList(this);
        }
        return this.externalMessageOrBuilderList;
    }

    private void onChanged() {
        if (this.isClean && this.parent != null) {
            this.parent.markDirty();
            this.isClean = false;
        }
    }

    @Override
    public void markDirty() {
        this.onChanged();
    }

    private void incrementModCounts() {
        if (this.externalMessageList != null) {
            this.externalMessageList.incrementModCount();
        }
        if (this.externalBuilderList != null) {
            this.externalBuilderList.incrementModCount();
        }
        if (this.externalMessageOrBuilderList != null) {
            this.externalMessageOrBuilderList.incrementModCount();
        }
    }
}

