/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors$EnumValueDescriptor;
import com.google.protobuf.Descriptors$FieldDescriptor;
import com.google.protobuf.Descriptors$FieldDescriptor$JavaType;
import com.google.protobuf.Descriptors$FieldDescriptor$Type;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.TextFormat$TextGenerator;
import com.google.protobuf.TextFormatEscaper;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.UnknownFieldSet$Field;
import java.util.List;
import java.util.Map;

final class TextFormat$Printer {
    static final TextFormat$Printer DEFAULT = new TextFormat$Printer(true);
    static final TextFormat$Printer UNICODE = new TextFormat$Printer(false);
    private final boolean escapeNonAscii;

    private TextFormat$Printer(boolean bl) {
        this.escapeNonAscii = bl;
    }

    private void print(MessageOrBuilder messageOrBuilder, TextFormat$TextGenerator textGenerator) {
        for (Map.Entry<Descriptors$FieldDescriptor, Object> entry : messageOrBuilder.getAllFields().entrySet()) {
            this.printField(entry.getKey(), entry.getValue(), textGenerator);
        }
        this.printUnknownFields(messageOrBuilder.getUnknownFields(), textGenerator);
    }

    private void printField(Descriptors$FieldDescriptor descriptors$FieldDescriptor, Object object, TextFormat$TextGenerator textGenerator) {
        if (descriptors$FieldDescriptor.isRepeated()) {
            for (Object e2 : (List)object) {
                this.printSingleField(descriptors$FieldDescriptor, e2, textGenerator);
            }
        } else {
            this.printSingleField(descriptors$FieldDescriptor, object, textGenerator);
        }
    }

    private void printSingleField(Descriptors$FieldDescriptor descriptors$FieldDescriptor, Object object, TextFormat$TextGenerator textFormat$TextGenerator) {
        if (descriptors$FieldDescriptor.isExtension()) {
            textFormat$TextGenerator.print("[");
            if (descriptors$FieldDescriptor.getContainingType().getOptions().getMessageSetWireFormat() && descriptors$FieldDescriptor.getType() == Descriptors$FieldDescriptor$Type.MESSAGE && descriptors$FieldDescriptor.isOptional() && descriptors$FieldDescriptor.getExtensionScope() == descriptors$FieldDescriptor.getMessageType()) {
                textFormat$TextGenerator.print(descriptors$FieldDescriptor.getMessageType().getFullName());
            } else {
                textFormat$TextGenerator.print(descriptors$FieldDescriptor.getFullName());
            }
            textFormat$TextGenerator.print("]");
        } else if (descriptors$FieldDescriptor.getType() == Descriptors$FieldDescriptor$Type.GROUP) {
            textFormat$TextGenerator.print(descriptors$FieldDescriptor.getMessageType().getName());
        } else {
            textFormat$TextGenerator.print(descriptors$FieldDescriptor.getName());
        }
        if (descriptors$FieldDescriptor.getJavaType() == Descriptors$FieldDescriptor$JavaType.MESSAGE) {
            textFormat$TextGenerator.print(" {");
            textFormat$TextGenerator.eol();
            textFormat$TextGenerator.indent();
        } else {
            textFormat$TextGenerator.print(": ");
        }
        this.printFieldValue(descriptors$FieldDescriptor, object, textFormat$TextGenerator);
        if (descriptors$FieldDescriptor.getJavaType() == Descriptors$FieldDescriptor$JavaType.MESSAGE) {
            textFormat$TextGenerator.outdent();
            textFormat$TextGenerator.print("}");
        }
        textFormat$TextGenerator.eol();
    }

    private void printFieldValue(Descriptors$FieldDescriptor descriptors$FieldDescriptor, Object object, TextFormat$TextGenerator textFormat$TextGenerator) {
        switch (descriptors$FieldDescriptor.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                textFormat$TextGenerator.print(((Integer)object).toString());
                break;
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                textFormat$TextGenerator.print(((Long)object).toString());
                break;
            }
            case BOOL: {
                textFormat$TextGenerator.print(((Boolean)object).toString());
                break;
            }
            case FLOAT: {
                textFormat$TextGenerator.print(((Float)object).toString());
                break;
            }
            case DOUBLE: {
                textFormat$TextGenerator.print(((Double)object).toString());
                break;
            }
            case UINT32: 
            case FIXED32: {
                textFormat$TextGenerator.print(TextFormat.unsignedToString((Integer)object));
                break;
            }
            case UINT64: 
            case FIXED64: {
                textFormat$TextGenerator.print(TextFormat.unsignedToString((Long)object));
                break;
            }
            case STRING: {
                textFormat$TextGenerator.print("\"");
                textFormat$TextGenerator.print(this.escapeNonAscii ? TextFormatEscaper.escapeText((String)object) : TextFormat.escapeDoubleQuotesAndBackslashes((String)object).replace("\n", "\\n"));
                textFormat$TextGenerator.print("\"");
                break;
            }
            case BYTES: {
                textFormat$TextGenerator.print("\"");
                if (object instanceof ByteString) {
                    textFormat$TextGenerator.print(TextFormat.escapeBytes((ByteString)object));
                } else {
                    textFormat$TextGenerator.print(TextFormat.escapeBytes((byte[])object));
                }
                textFormat$TextGenerator.print("\"");
                break;
            }
            case ENUM: {
                textFormat$TextGenerator.print(((Descriptors$EnumValueDescriptor)object).getName());
                break;
            }
            case MESSAGE: 
            case GROUP: {
                this.print((Message)object, textFormat$TextGenerator);
            }
        }
    }

    private void printUnknownFields(UnknownFieldSet unknownFieldSet, TextFormat$TextGenerator textFormat$TextGenerator) {
        for (Map.Entry<Integer, UnknownFieldSet$Field> entry : unknownFieldSet.asMap().entrySet()) {
            int n = entry.getKey();
            UnknownFieldSet$Field unknownFieldSet$Field = entry.getValue();
            this.printUnknownField(n, 0, unknownFieldSet$Field.getVarintList(), textFormat$TextGenerator);
            this.printUnknownField(n, 5, unknownFieldSet$Field.getFixed32List(), textFormat$TextGenerator);
            this.printUnknownField(n, 1, unknownFieldSet$Field.getFixed64List(), textFormat$TextGenerator);
            this.printUnknownField(n, 2, unknownFieldSet$Field.getLengthDelimitedList(), textFormat$TextGenerator);
            for (UnknownFieldSet unknownFieldSet2 : unknownFieldSet$Field.getGroupList()) {
                textFormat$TextGenerator.print(entry.getKey().toString());
                textFormat$TextGenerator.print(" {");
                textFormat$TextGenerator.eol();
                textFormat$TextGenerator.indent();
                this.printUnknownFields(unknownFieldSet2, textFormat$TextGenerator);
                textFormat$TextGenerator.outdent();
                textFormat$TextGenerator.print("}");
                textFormat$TextGenerator.eol();
            }
        }
    }

    private void printUnknownField(int n, int n2, List<?> list, TextFormat$TextGenerator textFormat$TextGenerator) {
        for (Object obj : list) {
            textFormat$TextGenerator.print(String.valueOf(n));
            textFormat$TextGenerator.print(": ");
            TextFormat.access$400(n2, obj, textFormat$TextGenerator);
            textFormat$TextGenerator.eol();
        }
    }

    static /* synthetic */ void access$000(TextFormat$Printer textFormat$Printer, MessageOrBuilder messageOrBuilder, TextFormat$TextGenerator textGenerator) {
        textFormat$Printer.print(messageOrBuilder, textGenerator);
    }

    static /* synthetic */ void access$100(TextFormat$Printer textFormat$Printer, UnknownFieldSet unknownFieldSet, TextFormat$TextGenerator textGenerator) {
        textFormat$Printer.printUnknownFields(unknownFieldSet, textGenerator);
    }

    static /* synthetic */ void access$200(TextFormat$Printer textFormat$Printer, Descriptors$FieldDescriptor descriptors$FieldDescriptor, Object object, TextFormat$TextGenerator textGenerator) {
        textFormat$Printer.printField(descriptors$FieldDescriptor, object, textGenerator);
    }

    static /* synthetic */ void access$300(TextFormat$Printer textFormat$Printer, Descriptors$FieldDescriptor descriptors$FieldDescriptor, Object object, TextFormat$TextGenerator textGenerator) {
        textFormat$Printer.printFieldValue(descriptors$FieldDescriptor, object, textGenerator);
    }
}

