/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.TextFormat;
import com.google.protobuf.TextFormat$1;
import com.google.protobuf.TextFormat$InvalidEscapeSequenceException;
import com.google.protobuf.TextFormat$ParseException;
import com.google.protobuf.TextFormat$UnknownFieldParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class TextFormat$Tokenizer {
    private final CharSequence text;
    private final Matcher matcher;
    private String currentToken;
    private int pos = 0;
    private int line = 0;
    private int column = 0;
    private int previousLine = 0;
    private int previousColumn = 0;
    private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
    private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
    private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
    private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
    private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

    private TextFormat$Tokenizer(CharSequence charSequence) {
        this.text = charSequence;
        this.matcher = WHITESPACE.matcher(charSequence);
        this.skipWhitespace();
        this.nextToken();
    }

    int getPreviousLine() {
        return this.previousLine;
    }

    int getPreviousColumn() {
        return this.previousColumn;
    }

    int getLine() {
        return this.line;
    }

    int getColumn() {
        return this.column;
    }

    public boolean atEnd() {
        return this.currentToken.length() == 0;
    }

    public void nextToken() {
        this.previousLine = this.line;
        this.previousColumn = this.column;
        while (this.pos < this.matcher.regionStart()) {
            if (this.text.charAt(this.pos) == '\n') {
                ++this.line;
                this.column = 0;
            } else {
                ++this.column;
            }
            ++this.pos;
        }
        if (this.matcher.regionStart() == this.matcher.regionEnd()) {
            this.currentToken = "";
        } else {
            this.matcher.usePattern(TOKEN);
            if (this.matcher.lookingAt()) {
                this.currentToken = this.matcher.group();
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            } else {
                this.currentToken = String.valueOf(this.text.charAt(this.pos));
                this.matcher.region(this.pos + 1, this.matcher.regionEnd());
            }
            this.skipWhitespace();
        }
    }

    private void skipWhitespace() {
        this.matcher.usePattern(WHITESPACE);
        if (this.matcher.lookingAt()) {
            this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
        }
    }

    public boolean tryConsume(String string) {
        if (this.currentToken.equals(string)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public void consume(String string) {
        if (!this.tryConsume(string)) {
            String string2 = String.valueOf(String.valueOf(string));
            throw this.parseException(new StringBuilder(12 + string2.length()).append("Expected \"").append(string2).append("\".").toString());
        }
    }

    public boolean lookingAtInteger() {
        if (this.currentToken.length() == 0) {
            return false;
        }
        char c2 = this.currentToken.charAt(0);
        return '0' <= c2 && c2 <= '9' || c2 == '-' || c2 == '+';
    }

    public boolean lookingAt(String string) {
        return this.currentToken.equals(string);
    }

    public String consumeIdentifier() {
        for (int i = 0; i < this.currentToken.length(); ++i) {
            char c2 = this.currentToken.charAt(i);
            if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9' || c2 == '_' || c2 == '.') continue;
            String string = String.valueOf(String.valueOf(this.currentToken));
            throw this.parseException(new StringBuilder(29 + string.length()).append("Expected identifier. Found '").append(string).append("'").toString());
        }
        String string = this.currentToken;
        this.nextToken();
        return string;
    }

    public boolean tryConsumeIdentifier() {
        try {
            this.consumeIdentifier();
            return true;
        }
        catch (TextFormat$ParseException textFormat$ParseException) {
            return false;
        }
    }

    public int consumeInt32() {
        try {
            int n = TextFormat.parseInt32(this.currentToken);
            this.nextToken();
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.integerParseException(numberFormatException);
        }
    }

    public int consumeUInt32() {
        try {
            int n = TextFormat.parseUInt32(this.currentToken);
            this.nextToken();
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.integerParseException(numberFormatException);
        }
    }

    public long consumeInt64() {
        try {
            long l = TextFormat.parseInt64(this.currentToken);
            this.nextToken();
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.integerParseException(numberFormatException);
        }
    }

    public boolean tryConsumeInt64() {
        try {
            this.consumeInt64();
            return true;
        }
        catch (TextFormat$ParseException textFormat$ParseException) {
            return false;
        }
    }

    public long consumeUInt64() {
        try {
            long l = TextFormat.parseUInt64(this.currentToken);
            this.nextToken();
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.integerParseException(numberFormatException);
        }
    }

    public boolean tryConsumeUInt64() {
        try {
            this.consumeUInt64();
            return true;
        }
        catch (TextFormat$ParseException textFormat$ParseException) {
            return false;
        }
    }

    public double consumeDouble() {
        if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
            boolean bl = this.currentToken.startsWith("-");
            this.nextToken();
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if (this.currentToken.equalsIgnoreCase("nan")) {
            this.nextToken();
            return Double.NaN;
        }
        try {
            double d2 = Double.parseDouble(this.currentToken);
            this.nextToken();
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.floatParseException(numberFormatException);
        }
    }

    public boolean tryConsumeDouble() {
        try {
            this.consumeDouble();
            return true;
        }
        catch (TextFormat$ParseException textFormat$ParseException) {
            return false;
        }
    }

    public float consumeFloat() {
        if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
            boolean bl = this.currentToken.startsWith("-");
            this.nextToken();
            return bl ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (FLOAT_NAN.matcher(this.currentToken).matches()) {
            this.nextToken();
            return Float.NaN;
        }
        try {
            float f2 = Float.parseFloat(this.currentToken);
            this.nextToken();
            return f2;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.floatParseException(numberFormatException);
        }
    }

    public boolean tryConsumeFloat() {
        try {
            this.consumeFloat();
            return true;
        }
        catch (TextFormat$ParseException textFormat$ParseException) {
            return false;
        }
    }

    public boolean consumeBoolean() {
        if (this.currentToken.equals("true") || this.currentToken.equals("True") || this.currentToken.equals("t") || this.currentToken.equals("1")) {
            this.nextToken();
            return true;
        }
        if (this.currentToken.equals("false") || this.currentToken.equals("False") || this.currentToken.equals("f") || this.currentToken.equals("0")) {
            this.nextToken();
            return false;
        }
        String string = String.valueOf(String.valueOf(this.currentToken));
        throw this.parseException(new StringBuilder(37 + string.length()).append("Expected \"true\" or \"false\". Found \"").append(string).append("\".").toString());
    }

    public String consumeString() {
        return this.consumeByteString().toStringUtf8();
    }

    public boolean tryConsumeString() {
        try {
            this.consumeString();
            return true;
        }
        catch (TextFormat$ParseException textFormat$ParseException) {
            return false;
        }
    }

    public ByteString consumeByteString() {
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        this.consumeByteString(arrayList);
        while (this.currentToken.startsWith("'") || this.currentToken.startsWith("\"")) {
            this.consumeByteString(arrayList);
        }
        return ByteString.copyFrom(arrayList);
    }

    private void consumeByteString(List<ByteString> list) {
        char c2;
        char c3 = c2 = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
        if (c2 != '\"' && c2 != '\'') {
            throw this.parseException("Expected string.");
        }
        if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != c2) {
            throw this.parseException("String missing ending quote.");
        }
        try {
            String string = this.currentToken.substring(1, this.currentToken.length() - 1);
            ByteString byteString = TextFormat.unescapeBytes(string);
            this.nextToken();
            list.add(byteString);
        }
        catch (TextFormat$InvalidEscapeSequenceException textFormat$InvalidEscapeSequenceException) {
            throw this.parseException(textFormat$InvalidEscapeSequenceException.getMessage());
        }
    }

    public TextFormat$ParseException parseException(String string) {
        return new TextFormat$ParseException(this.line + 1, this.column + 1, string);
    }

    public TextFormat$ParseException parseExceptionPreviousToken(String string) {
        return new TextFormat$ParseException(this.previousLine + 1, this.previousColumn + 1, string);
    }

    private TextFormat$ParseException integerParseException(NumberFormatException numberFormatException) {
        String string = String.valueOf(numberFormatException.getMessage());
        return this.parseException(string.length() != 0 ? "Couldn't parse integer: ".concat(string) : new String("Couldn't parse integer: "));
    }

    private TextFormat$ParseException floatParseException(NumberFormatException numberFormatException) {
        String string = String.valueOf(numberFormatException.getMessage());
        return this.parseException(string.length() != 0 ? "Couldn't parse number: ".concat(string) : new String("Couldn't parse number: "));
    }

    public TextFormat$UnknownFieldParseException unknownFieldParseExceptionPreviousToken(String string, String string2) {
        return new TextFormat$UnknownFieldParseException(this.previousLine + 1, this.previousColumn + 1, string, string2);
    }

    /* synthetic */ TextFormat$Tokenizer(CharSequence charSequence, TextFormat$1 textFormat$1) {
        this(charSequence);
    }

    static /* synthetic */ String access$900(TextFormat$Tokenizer textFormat$Tokenizer) {
        return textFormat$Tokenizer.currentToken;
    }
}

