/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors$FieldDescriptor;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Message$Builder;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat$InvalidEscapeSequenceException;
import com.google.protobuf.TextFormat$Parser;
import com.google.protobuf.TextFormat$Printer;
import com.google.protobuf.TextFormat$TextGenerator;
import com.google.protobuf.TextFormatEscaper;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Locale;
import java.util.logging.Logger;

public final class TextFormat {
    private static final Logger logger = Logger.getLogger(TextFormat.class.getName());
    private static final TextFormat$Parser PARSER = TextFormat$Parser.newBuilder().build();

    private TextFormat() {
    }

    public static void print(MessageOrBuilder messageOrBuilder, Appendable appendable) {
        TextFormat$Printer.access$000(TextFormat$Printer.DEFAULT, messageOrBuilder, TextFormat.multiLineOutput(appendable));
    }

    public static void print(UnknownFieldSet unknownFieldSet, Appendable appendable) {
        TextFormat$Printer.access$100(TextFormat$Printer.DEFAULT, unknownFieldSet, TextFormat.multiLineOutput(appendable));
    }

    public static void printUnicode(MessageOrBuilder messageOrBuilder, Appendable appendable) {
        TextFormat$Printer.access$000(TextFormat$Printer.UNICODE, messageOrBuilder, TextFormat.multiLineOutput(appendable));
    }

    public static void printUnicode(UnknownFieldSet unknownFieldSet, Appendable appendable) {
        TextFormat$Printer.access$100(TextFormat$Printer.UNICODE, unknownFieldSet, TextFormat.multiLineOutput(appendable));
    }

    public static String shortDebugString(MessageOrBuilder messageOrBuilder) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat$Printer.access$000(TextFormat$Printer.DEFAULT, messageOrBuilder, TextFormat.singleLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String shortDebugString(Descriptors$FieldDescriptor descriptors$FieldDescriptor, Object object) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat$Printer.access$200(TextFormat$Printer.DEFAULT, descriptors$FieldDescriptor, object, TextFormat.singleLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String shortDebugString(UnknownFieldSet unknownFieldSet) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat$Printer.access$100(TextFormat$Printer.DEFAULT, unknownFieldSet, TextFormat.singleLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToString(MessageOrBuilder messageOrBuilder) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.print(messageOrBuilder, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToString(UnknownFieldSet unknownFieldSet) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.print(unknownFieldSet, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToUnicodeString(MessageOrBuilder messageOrBuilder) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat$Printer.access$000(TextFormat$Printer.UNICODE, messageOrBuilder, TextFormat.multiLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static String printToUnicodeString(UnknownFieldSet unknownFieldSet) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat$Printer.access$100(TextFormat$Printer.UNICODE, unknownFieldSet, TextFormat.multiLineOutput(stringBuilder));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static void printField(Descriptors$FieldDescriptor descriptors$FieldDescriptor, Object object, Appendable appendable) {
        TextFormat$Printer.access$200(TextFormat$Printer.DEFAULT, descriptors$FieldDescriptor, object, TextFormat.multiLineOutput(appendable));
    }

    public static String printFieldToString(Descriptors$FieldDescriptor descriptors$FieldDescriptor, Object object) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TextFormat.printField(descriptors$FieldDescriptor, object, stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static void printUnicodeFieldValue(Descriptors$FieldDescriptor descriptors$FieldDescriptor, Object object, Appendable appendable) {
        TextFormat$Printer.access$300(TextFormat$Printer.UNICODE, descriptors$FieldDescriptor, object, TextFormat.multiLineOutput(appendable));
    }

    public static void printFieldValue(Descriptors$FieldDescriptor descriptors$FieldDescriptor, Object object, Appendable appendable) {
        TextFormat$Printer.access$300(TextFormat$Printer.DEFAULT, descriptors$FieldDescriptor, object, TextFormat.multiLineOutput(appendable));
    }

    public static void printUnknownFieldValue(int n, Object object, Appendable appendable) {
        TextFormat.printUnknownFieldValue(n, object, TextFormat.multiLineOutput(appendable));
    }

    private static void printUnknownFieldValue(int n, Object object, TextFormat$TextGenerator textFormat$TextGenerator) {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                textFormat$TextGenerator.print(TextFormat.unsignedToString((Long)object));
                break;
            }
            case 5: {
                textFormat$TextGenerator.print(String.format((Locale)null, "0x%08x", (Integer)object));
                break;
            }
            case 1: {
                textFormat$TextGenerator.print(String.format((Locale)null, "0x%016x", (Long)object));
                break;
            }
            case 2: {
                try {
                    UnknownFieldSet unknownFieldSet = UnknownFieldSet.parseFrom((ByteString)object);
                    textFormat$TextGenerator.print("{");
                    textFormat$TextGenerator.eol();
                    textFormat$TextGenerator.indent();
                    TextFormat$Printer.access$100(TextFormat$Printer.DEFAULT, unknownFieldSet, textFormat$TextGenerator);
                    textFormat$TextGenerator.outdent();
                    textFormat$TextGenerator.print("}");
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    textFormat$TextGenerator.print("\"");
                    textFormat$TextGenerator.print(TextFormat.escapeBytes((ByteString)object));
                    textFormat$TextGenerator.print("\"");
                }
                break;
            }
            case 3: {
                TextFormat$Printer.access$100(TextFormat$Printer.DEFAULT, (UnknownFieldSet)object, textFormat$TextGenerator);
                break;
            }
            default: {
                int n2 = n;
                throw new IllegalArgumentException(new StringBuilder(20).append("Bad tag: ").append(n2).toString());
            }
        }
    }

    public static String unsignedToString(int n) {
        if (n >= 0) {
            return Integer.toString(n);
        }
        return Long.toString((long)n & 0xFFFFFFFFL);
    }

    public static String unsignedToString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        return BigInteger.valueOf(l & Long.MAX_VALUE).setBit(63).toString();
    }

    private static TextFormat$TextGenerator multiLineOutput(Appendable appendable) {
        return new TextFormat$TextGenerator(appendable, false, null);
    }

    private static TextFormat$TextGenerator singleLineOutput(Appendable appendable) {
        return new TextFormat$TextGenerator(appendable, true, null);
    }

    public static TextFormat$Parser getParser() {
        return PARSER;
    }

    public static void merge(Readable readable, Message$Builder message$Builder) {
        PARSER.merge(readable, message$Builder);
    }

    public static void merge(CharSequence charSequence, Message$Builder message$Builder) {
        PARSER.merge(charSequence, message$Builder);
    }

    public static <T extends Message> T parse(CharSequence charSequence, Class<T> clazz) {
        Message$Builder message$Builder = ((Message)Internal.getDefaultInstance(clazz)).newBuilderForType();
        TextFormat.merge(charSequence, message$Builder);
        Message message = message$Builder.build();
        return (T)message;
    }

    public static void merge(Readable readable, ExtensionRegistry extensionRegistry, Message$Builder message$Builder) {
        PARSER.merge(readable, extensionRegistry, message$Builder);
    }

    public static void merge(CharSequence charSequence, ExtensionRegistry extensionRegistry, Message$Builder message$Builder) {
        PARSER.merge(charSequence, extensionRegistry, message$Builder);
    }

    public static <T extends Message> T parse(CharSequence charSequence, ExtensionRegistry extensionRegistry, Class<T> clazz) {
        Message$Builder message$Builder = ((Message)Internal.getDefaultInstance(clazz)).newBuilderForType();
        TextFormat.merge(charSequence, extensionRegistry, message$Builder);
        Message message = message$Builder.build();
        return (T)message;
    }

    public static String escapeBytes(ByteString byteString) {
        return TextFormatEscaper.escapeBytes(byteString);
    }

    public static String escapeBytes(byte[] byArray) {
        return TextFormatEscaper.escapeBytes(byArray);
    }

    public static ByteString unescapeBytes(CharSequence charSequence) {
        ByteString byteString = ByteString.copyFromUtf8(charSequence.toString());
        byte[] byArray = new byte[byteString.size()];
        int n = 0;
        for (int i = 0; i < byteString.size(); ++i) {
            byte by = byteString.byteAt(i);
            if (by == 92) {
                if (i + 1 < byteString.size()) {
                    int n2;
                    if (TextFormat.isOctal(by = byteString.byteAt(++i))) {
                        n2 = TextFormat.digitValue(by);
                        if (i + 1 < byteString.size() && TextFormat.isOctal(byteString.byteAt(i + 1))) {
                            n2 = n2 * 8 + TextFormat.digitValue(byteString.byteAt(++i));
                        }
                        if (i + 1 < byteString.size() && TextFormat.isOctal(byteString.byteAt(i + 1))) {
                            n2 = n2 * 8 + TextFormat.digitValue(byteString.byteAt(++i));
                        }
                        byArray[n++] = (byte)n2;
                        continue;
                    }
                    switch (by) {
                        case 97: {
                            byArray[n++] = 7;
                            break;
                        }
                        case 98: {
                            byArray[n++] = 8;
                            break;
                        }
                        case 102: {
                            byArray[n++] = 12;
                            break;
                        }
                        case 110: {
                            byArray[n++] = 10;
                            break;
                        }
                        case 114: {
                            byArray[n++] = 13;
                            break;
                        }
                        case 116: {
                            byArray[n++] = 9;
                            break;
                        }
                        case 118: {
                            byArray[n++] = 11;
                            break;
                        }
                        case 92: {
                            byArray[n++] = 92;
                            break;
                        }
                        case 39: {
                            byArray[n++] = 39;
                            break;
                        }
                        case 34: {
                            byArray[n++] = 34;
                            break;
                        }
                        case 120: {
                            n2 = 0;
                            if (i + 1 >= byteString.size() || !TextFormat.isHex(byteString.byteAt(i + 1))) {
                                throw new TextFormat$InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            n2 = TextFormat.digitValue(byteString.byteAt(++i));
                            if (i + 1 < byteString.size() && TextFormat.isHex(byteString.byteAt(i + 1))) {
                                n2 = n2 * 16 + TextFormat.digitValue(byteString.byteAt(++i));
                            }
                            byArray[n++] = (byte)n2;
                            break;
                        }
                        default: {
                            char c2 = (char)by;
                            throw new TextFormat$InvalidEscapeSequenceException(new StringBuilder(29).append("Invalid escape sequence: '\\").append(c2).append("'").toString());
                        }
                    }
                    continue;
                }
                throw new TextFormat$InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            byArray[n++] = by;
        }
        return byArray.length == n ? ByteString.wrap(byArray) : ByteString.copyFrom(byArray, 0, n);
    }

    static String escapeText(String string) {
        return TextFormat.escapeBytes(ByteString.copyFromUtf8(string));
    }

    public static String escapeDoubleQuotesAndBackslashes(String string) {
        return TextFormatEscaper.escapeDoubleQuotesAndBackslashes(string);
    }

    static String unescapeText(String string) {
        return TextFormat.unescapeBytes(string).toStringUtf8();
    }

    private static boolean isOctal(byte by) {
        return 48 <= by && by <= 55;
    }

    private static boolean isHex(byte by) {
        return 48 <= by && by <= 57 || 97 <= by && by <= 102 || 65 <= by && by <= 70;
    }

    private static int digitValue(byte by) {
        if (48 <= by && by <= 57) {
            return by - 48;
        }
        if (97 <= by && by <= 122) {
            return by - 97 + 10;
        }
        return by - 65 + 10;
    }

    static int parseInt32(String string) {
        return (int)TextFormat.parseInteger(string, true, false);
    }

    static int parseUInt32(String string) {
        return (int)TextFormat.parseInteger(string, false, false);
    }

    static long parseInt64(String string) {
        return TextFormat.parseInteger(string, true, true);
    }

    static long parseUInt64(String string) {
        return TextFormat.parseInteger(string, false, true);
    }

    private static long parseInteger(String string, boolean bl, boolean bl2) {
        int n = 0;
        boolean bl3 = false;
        if (string.startsWith("-", n)) {
            if (!bl) {
                String string2 = String.valueOf(string);
                throw new NumberFormatException(string2.length() != 0 ? "Number must be positive: ".concat(string2) : new String("Number must be positive: "));
            }
            ++n;
            bl3 = true;
        }
        int n2 = 10;
        if (string.startsWith("0x", n)) {
            n += 2;
            n2 = 16;
        } else if (string.startsWith("0", n)) {
            n2 = 8;
        }
        String string3 = string.substring(n);
        long l = 0L;
        if (string3.length() < 16) {
            l = Long.parseLong(string3, n2);
            if (bl3) {
                l = -l;
            }
            if (!bl2) {
                if (bl) {
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                        String string4 = String.valueOf(string);
                        throw new NumberFormatException(string4.length() != 0 ? "Number out of range for 32-bit signed integer: ".concat(string4) : new String("Number out of range for 32-bit signed integer: "));
                    }
                } else if (l >= 0x100000000L || l < 0L) {
                    String string5 = String.valueOf(string);
                    throw new NumberFormatException(string5.length() != 0 ? "Number out of range for 32-bit unsigned integer: ".concat(string5) : new String("Number out of range for 32-bit unsigned integer: "));
                }
            }
        } else {
            BigInteger bigInteger = new BigInteger(string3, n2);
            if (bl3) {
                bigInteger = bigInteger.negate();
            }
            if (!bl2) {
                if (bl) {
                    if (bigInteger.bitLength() > 31) {
                        String string6 = String.valueOf(string);
                        throw new NumberFormatException(string6.length() != 0 ? "Number out of range for 32-bit signed integer: ".concat(string6) : new String("Number out of range for 32-bit signed integer: "));
                    }
                } else if (bigInteger.bitLength() > 32) {
                    String string7 = String.valueOf(string);
                    throw new NumberFormatException(string7.length() != 0 ? "Number out of range for 32-bit unsigned integer: ".concat(string7) : new String("Number out of range for 32-bit unsigned integer: "));
                }
            } else if (bl) {
                if (bigInteger.bitLength() > 63) {
                    String string8 = String.valueOf(string);
                    throw new NumberFormatException(string8.length() != 0 ? "Number out of range for 64-bit signed integer: ".concat(string8) : new String("Number out of range for 64-bit signed integer: "));
                }
            } else if (bigInteger.bitLength() > 64) {
                String string9 = String.valueOf(string);
                throw new NumberFormatException(string9.length() != 0 ? "Number out of range for 64-bit unsigned integer: ".concat(string9) : new String("Number out of range for 64-bit unsigned integer: "));
            }
            l = bigInteger.longValue();
        }
        return l;
    }

    static /* synthetic */ void access$400(int n, Object object, TextFormat$TextGenerator textFormat$TextGenerator) {
        TextFormat.printUnknownFieldValue(n, object, textFormat$TextGenerator);
    }

    static /* synthetic */ Logger access$700() {
        return logger;
    }
}

