/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite$Builder$LimitedInputStream;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLite$Builder;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.UnknownFieldSet$Field;
import com.google.protobuf.UnknownFieldSet$Field$Builder;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class UnknownFieldSet$Builder
implements MessageLite$Builder {
    private Map<Integer, UnknownFieldSet$Field> fields;
    private int lastFieldNumber;
    private UnknownFieldSet$Field$Builder lastField;

    private UnknownFieldSet$Builder() {
    }

    private static UnknownFieldSet$Builder create() {
        UnknownFieldSet$Builder unknownFieldSet$Builder = new UnknownFieldSet$Builder();
        unknownFieldSet$Builder.reinitialize();
        return unknownFieldSet$Builder;
    }

    private UnknownFieldSet$Field$Builder getFieldBuilder(int n) {
        if (this.lastField != null) {
            if (n == this.lastFieldNumber) {
                return this.lastField;
            }
            this.addField(this.lastFieldNumber, this.lastField.build());
        }
        if (n == 0) {
            return null;
        }
        UnknownFieldSet$Field unknownFieldSet$Field = this.fields.get(n);
        this.lastFieldNumber = n;
        this.lastField = UnknownFieldSet$Field.newBuilder();
        if (unknownFieldSet$Field != null) {
            this.lastField.mergeFrom(unknownFieldSet$Field);
        }
        return this.lastField;
    }

    @Override
    public UnknownFieldSet build() {
        UnknownFieldSet unknownFieldSet;
        this.getFieldBuilder(0);
        if (this.fields.isEmpty()) {
            unknownFieldSet = UnknownFieldSet.getDefaultInstance();
        } else {
            Map<Integer, UnknownFieldSet$Field> map = null;
            unknownFieldSet = new UnknownFieldSet(Collections.unmodifiableMap(this.fields), map);
        }
        this.fields = null;
        return unknownFieldSet;
    }

    @Override
    public UnknownFieldSet buildPartial() {
        return this.build();
    }

    @Override
    public UnknownFieldSet$Builder clone() {
        this.getFieldBuilder(0);
        Map<Integer, UnknownFieldSet$Field> map = null;
        return UnknownFieldSet.newBuilder().mergeFrom(new UnknownFieldSet(this.fields, map));
    }

    @Override
    public UnknownFieldSet getDefaultInstanceForType() {
        return UnknownFieldSet.getDefaultInstance();
    }

    private void reinitialize() {
        this.fields = Collections.emptyMap();
        this.lastFieldNumber = 0;
        this.lastField = null;
    }

    @Override
    public UnknownFieldSet$Builder clear() {
        this.reinitialize();
        return this;
    }

    public UnknownFieldSet$Builder clearField(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        if (this.lastField != null && this.lastFieldNumber == n) {
            this.lastField = null;
            this.lastFieldNumber = 0;
        }
        if (this.fields.containsKey(n)) {
            this.fields.remove(n);
        }
        return this;
    }

    public UnknownFieldSet$Builder mergeFrom(UnknownFieldSet unknownFieldSet) {
        if (unknownFieldSet != UnknownFieldSet.getDefaultInstance()) {
            for (Map.Entry entry : UnknownFieldSet.access$100(unknownFieldSet).entrySet()) {
                this.mergeField((Integer)entry.getKey(), (UnknownFieldSet$Field)entry.getValue());
            }
        }
        return this;
    }

    public UnknownFieldSet$Builder mergeField(int n, UnknownFieldSet$Field unknownFieldSet$Field) {
        if (n == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        if (this.hasField(n)) {
            this.getFieldBuilder(n).mergeFrom(unknownFieldSet$Field);
        } else {
            this.addField(n, unknownFieldSet$Field);
        }
        return this;
    }

    public UnknownFieldSet$Builder mergeVarintField(int n, int n2) {
        if (n == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.getFieldBuilder(n).addVarint(n2);
        return this;
    }

    public UnknownFieldSet$Builder mergeLengthDelimitedField(int n, ByteString byteString) {
        if (n == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.getFieldBuilder(n).addLengthDelimited(byteString);
        return this;
    }

    public boolean hasField(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        return n == this.lastFieldNumber || this.fields.containsKey(n);
    }

    public UnknownFieldSet$Builder addField(int n, UnknownFieldSet$Field unknownFieldSet$Field) {
        if (n == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        if (this.lastField != null && this.lastFieldNumber == n) {
            this.lastField = null;
            this.lastFieldNumber = 0;
        }
        if (this.fields.isEmpty()) {
            this.fields = new TreeMap<Integer, UnknownFieldSet$Field>();
        }
        this.fields.put(n, unknownFieldSet$Field);
        return this;
    }

    public Map<Integer, UnknownFieldSet$Field> asMap() {
        this.getFieldBuilder(0);
        return Collections.unmodifiableMap(this.fields);
    }

    @Override
    public UnknownFieldSet$Builder mergeFrom(CodedInputStream codedInputStream) {
        int n;
        while ((n = codedInputStream.readTag()) != 0 && this.mergeFieldFrom(n, codedInputStream)) {
        }
        return this;
    }

    public boolean mergeFieldFrom(int n, CodedInputStream codedInputStream) {
        int n2 = WireFormat.getTagFieldNumber(n);
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                this.getFieldBuilder(n2).addVarint(codedInputStream.readInt64());
                return true;
            }
            case 1: {
                this.getFieldBuilder(n2).addFixed64(codedInputStream.readFixed64());
                return true;
            }
            case 2: {
                this.getFieldBuilder(n2).addLengthDelimited(codedInputStream.readBytes());
                return true;
            }
            case 3: {
                UnknownFieldSet$Builder unknownFieldSet$Builder = UnknownFieldSet.newBuilder();
                codedInputStream.readGroup(n2, unknownFieldSet$Builder, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                this.getFieldBuilder(n2).addGroup(unknownFieldSet$Builder.build());
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.getFieldBuilder(n2).addFixed32(codedInputStream.readFixed32());
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    @Override
    public UnknownFieldSet$Builder mergeFrom(ByteString byteString) {
        try {
            CodedInputStream codedInputStream = byteString.newCodedInput();
            this.mergeFrom(codedInputStream);
            codedInputStream.checkLastTagWas(0);
            return this;
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Reading from a ByteString threw an IOException (should never happen).", iOException);
        }
    }

    @Override
    public UnknownFieldSet$Builder mergeFrom(byte[] byArray) {
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray);
            this.mergeFrom(codedInputStream);
            codedInputStream.checkLastTagWas(0);
            return this;
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", iOException);
        }
    }

    @Override
    public UnknownFieldSet$Builder mergeFrom(InputStream inputStream) {
        CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
        this.mergeFrom(codedInputStream);
        codedInputStream.checkLastTagWas(0);
        return this;
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream inputStream) {
        int n = inputStream.read();
        if (n == -1) {
            return false;
        }
        int n2 = CodedInputStream.readRawVarint32(n, inputStream);
        AbstractMessageLite$Builder$LimitedInputStream abstractMessageLite$Builder$LimitedInputStream = new AbstractMessageLite$Builder$LimitedInputStream(inputStream, n2);
        this.mergeFrom(abstractMessageLite$Builder$LimitedInputStream);
        return true;
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
        return this.mergeDelimitedFrom(inputStream);
    }

    @Override
    public UnknownFieldSet$Builder mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) {
        return this.mergeFrom(codedInputStream);
    }

    @Override
    public UnknownFieldSet$Builder mergeFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) {
        return this.mergeFrom(byteString);
    }

    @Override
    public UnknownFieldSet$Builder mergeFrom(byte[] byArray, int n, int n2) {
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray, n, n2);
            this.mergeFrom(codedInputStream);
            codedInputStream.checkLastTagWas(0);
            return this;
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", iOException);
        }
    }

    @Override
    public UnknownFieldSet$Builder mergeFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) {
        return this.mergeFrom(byArray);
    }

    @Override
    public UnknownFieldSet$Builder mergeFrom(byte[] byArray, int n, int n2, ExtensionRegistryLite extensionRegistryLite) {
        return this.mergeFrom(byArray, n, n2);
    }

    @Override
    public UnknownFieldSet$Builder mergeFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
        return this.mergeFrom(inputStream);
    }

    @Override
    public UnknownFieldSet$Builder mergeFrom(MessageLite messageLite) {
        if (messageLite instanceof UnknownFieldSet) {
            return this.mergeFrom((UnknownFieldSet)messageLite);
        }
        throw new IllegalArgumentException("mergeFrom(MessageLite) can only merge messages of the same type.");
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    static /* synthetic */ UnknownFieldSet$Builder access$000() {
        return UnknownFieldSet$Builder.create();
    }
}

