/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;

class Utf8$DecodeUtil {
    private Utf8$DecodeUtil() {
    }

    private static boolean isOneByte(byte by) {
        return by >= 0;
    }

    private static boolean isTwoBytes(byte by) {
        return by < -32;
    }

    private static boolean isThreeBytes(byte by) {
        return by < -16;
    }

    private static void handleOneByte(byte by, char[] cArray, int n) {
        cArray[n] = (char)by;
    }

    private static void handleTwoBytes(byte by, byte by2, char[] cArray, int n) {
        if (by < -62 || Utf8$DecodeUtil.isNotTrailingByte(by2)) {
            throw InvalidProtocolBufferException.invalidUtf8();
        }
        cArray[n] = (char)((by & 0x1F) << 6 | Utf8$DecodeUtil.trailingByteValue(by2));
    }

    private static void handleThreeBytes(byte by, byte by2, byte by3, char[] cArray, int n) {
        if (Utf8$DecodeUtil.isNotTrailingByte(by2) || by == -32 && by2 < -96 || by == -19 && by2 >= -96 || Utf8$DecodeUtil.isNotTrailingByte(by3)) {
            throw InvalidProtocolBufferException.invalidUtf8();
        }
        cArray[n] = (char)((by & 0xF) << 12 | Utf8$DecodeUtil.trailingByteValue(by2) << 6 | Utf8$DecodeUtil.trailingByteValue(by3));
    }

    private static void handleFourBytes(byte by, byte by2, byte by3, byte by4, char[] cArray, int n) {
        if (Utf8$DecodeUtil.isNotTrailingByte(by2) || (by << 28) + (by2 - -112) >> 30 != 0 || Utf8$DecodeUtil.isNotTrailingByte(by3) || Utf8$DecodeUtil.isNotTrailingByte(by4)) {
            throw InvalidProtocolBufferException.invalidUtf8();
        }
        int n2 = (by & 7) << 18 | Utf8$DecodeUtil.trailingByteValue(by2) << 12 | Utf8$DecodeUtil.trailingByteValue(by3) << 6 | Utf8$DecodeUtil.trailingByteValue(by4);
        cArray[n] = Utf8$DecodeUtil.highSurrogate(n2);
        cArray[n + 1] = Utf8$DecodeUtil.lowSurrogate(n2);
    }

    private static boolean isNotTrailingByte(byte by) {
        return by > -65;
    }

    private static int trailingByteValue(byte by) {
        return by & 0x3F;
    }

    private static char highSurrogate(int n) {
        return (char)(55232 + (n >>> 10));
    }

    private static char lowSurrogate(int n) {
        return (char)(56320 + (n & 0x3FF));
    }

    static /* synthetic */ boolean access$400(byte by) {
        return Utf8$DecodeUtil.isOneByte(by);
    }

    static /* synthetic */ void access$500(byte by, char[] cArray, int n) {
        Utf8$DecodeUtil.handleOneByte(by, cArray, n);
    }

    static /* synthetic */ boolean access$600(byte by) {
        return Utf8$DecodeUtil.isTwoBytes(by);
    }

    static /* synthetic */ void access$700(byte by, byte by2, char[] cArray, int n) {
        Utf8$DecodeUtil.handleTwoBytes(by, by2, cArray, n);
    }

    static /* synthetic */ boolean access$800(byte by) {
        return Utf8$DecodeUtil.isThreeBytes(by);
    }

    static /* synthetic */ void access$900(byte by, byte by2, byte by3, char[] cArray, int n) {
        Utf8$DecodeUtil.handleThreeBytes(by, by2, by3, cArray, n);
    }

    static /* synthetic */ void access$1000(byte by, byte by2, byte by3, byte by4, char[] cArray, int n) {
        Utf8$DecodeUtil.handleFourBytes(by, by2, by3, by4, cArray, n);
    }
}

