/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Utf8;
import com.google.protobuf.Utf8$DecodeUtil;
import com.google.protobuf.Utf8$UnpairedSurrogateException;
import java.nio.ByteBuffer;

abstract class Utf8$Processor {
    Utf8$Processor() {
    }

    final boolean isValidUtf8(byte[] byArray, int n, int n2) {
        return this.partialIsValidUtf8(0, byArray, n, n2) == 0;
    }

    abstract int partialIsValidUtf8(int var1, byte[] var2, int var3, int var4);

    final boolean isValidUtf8(ByteBuffer byteBuffer, int n, int n2) {
        return this.partialIsValidUtf8(0, byteBuffer, n, n2) == 0;
    }

    final int partialIsValidUtf8(int n, ByteBuffer byteBuffer, int n2, int n3) {
        if (byteBuffer.hasArray()) {
            int n4 = byteBuffer.arrayOffset();
            return this.partialIsValidUtf8(n, byteBuffer.array(), n4 + n2, n4 + n3);
        }
        if (byteBuffer.isDirect()) {
            return this.partialIsValidUtf8Direct(n, byteBuffer, n2, n3);
        }
        return this.partialIsValidUtf8Default(n, byteBuffer, n2, n3);
    }

    abstract int partialIsValidUtf8Direct(int var1, ByteBuffer var2, int var3, int var4);

    final int partialIsValidUtf8Default(int n, ByteBuffer byteBuffer, int n2, int n3) {
        if (n != 0) {
            if (n2 >= n3) {
                return n;
            }
            byte by = (byte)n;
            if (by < -32) {
                if (by < -62 || byteBuffer.get(n2++) > -65) {
                    return -1;
                }
            } else if (by < -16) {
                byte by2 = (byte)(~(n >> 8));
                if (by2 == 0) {
                    by2 = byteBuffer.get(n2++);
                    if (n2 >= n3) {
                        return Utf8.access$000(by, by2);
                    }
                }
                if (by2 > -65 || by == -32 && by2 < -96 || by == -19 && by2 >= -96 || byteBuffer.get(n2++) > -65) {
                    return -1;
                }
            } else {
                byte by3 = (byte)(~(n >> 8));
                byte by4 = 0;
                if (by3 == 0) {
                    by3 = byteBuffer.get(n2++);
                    if (n2 >= n3) {
                        return Utf8.access$000(by, by3);
                    }
                } else {
                    by4 = (byte)(n >> 16);
                }
                if (by4 == 0) {
                    by4 = byteBuffer.get(n2++);
                    if (n2 >= n3) {
                        return Utf8.access$100(by, by3, by4);
                    }
                }
                if (by3 > -65 || (by << 28) + (by3 - -112) >> 30 != 0 || by4 > -65 || byteBuffer.get(n2++) > -65) {
                    return -1;
                }
            }
        }
        return Utf8$Processor.partialIsValidUtf8(byteBuffer, n2, n3);
    }

    private static int partialIsValidUtf8(ByteBuffer byteBuffer, int n, int n2) {
        n += Utf8.access$200(byteBuffer, n, n2);
        while (true) {
            byte by;
            byte by2;
            if (n >= n2) {
                return 0;
            }
            if ((by2 = byteBuffer.get(n++)) >= 0) continue;
            if (by2 < -32) {
                if (n >= n2) {
                    return by2;
                }
                if (by2 < -62 || byteBuffer.get(n) > -65) {
                    return -1;
                }
                ++n;
                continue;
            }
            if (by2 < -16) {
                if (n >= n2 - 1) {
                    return Utf8.access$300(byteBuffer, by2, n, n2 - n);
                }
                if ((by = byteBuffer.get(n++)) > -65 || by2 == -32 && by < -96 || by2 == -19 && by >= -96 || byteBuffer.get(n) > -65) {
                    return -1;
                }
                ++n;
                continue;
            }
            if (n >= n2 - 2) {
                return Utf8.access$300(byteBuffer, by2, n, n2 - n);
            }
            if ((by = byteBuffer.get(n++)) > -65 || (by2 << 28) + (by - -112) >> 30 != 0 || byteBuffer.get(n++) > -65 || byteBuffer.get(n++) > -65) break;
        }
        return -1;
    }

    abstract String decodeUtf8(byte[] var1, int var2, int var3);

    final String decodeUtf8(ByteBuffer byteBuffer, int n, int n2) {
        if (byteBuffer.hasArray()) {
            int n3 = byteBuffer.arrayOffset();
            return this.decodeUtf8(byteBuffer.array(), n3 + n, n2);
        }
        if (byteBuffer.isDirect()) {
            return this.decodeUtf8Direct(byteBuffer, n, n2);
        }
        return this.decodeUtf8Default(byteBuffer, n, n2);
    }

    abstract String decodeUtf8Direct(ByteBuffer var1, int var2, int var3);

    final String decodeUtf8Default(ByteBuffer byteBuffer, int n, int n2) {
        byte by;
        int n3;
        if ((n | n2 | byteBuffer.limit() - n - n2) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", byteBuffer.limit(), n, n2));
        }
        int n4 = n3 + n2;
        char[] cArray = new char[n2];
        int n5 = 0;
        for (n3 = n; n3 < n4 && Utf8$DecodeUtil.access$400(by = byteBuffer.get(n3)); ++n3) {
            Utf8$DecodeUtil.access$500(by, cArray, n5++);
        }
        while (n3 < n4) {
            if (Utf8$DecodeUtil.access$400(by = byteBuffer.get(n3++))) {
                byte by2;
                Utf8$DecodeUtil.access$500(by, cArray, n5++);
                while (n3 < n4 && Utf8$DecodeUtil.access$400(by2 = byteBuffer.get(n3))) {
                    ++n3;
                    Utf8$DecodeUtil.access$500(by2, cArray, n5++);
                }
                continue;
            }
            if (Utf8$DecodeUtil.access$600(by)) {
                if (n3 >= n4) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                Utf8$DecodeUtil.access$700(by, byteBuffer.get(n3++), cArray, n5++);
                continue;
            }
            if (Utf8$DecodeUtil.access$800(by)) {
                if (n3 >= n4 - 1) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                Utf8$DecodeUtil.access$900(by, byteBuffer.get(n3++), byteBuffer.get(n3++), cArray, n5++);
                continue;
            }
            if (n3 >= n4 - 2) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            Utf8$DecodeUtil.access$1000(by, byteBuffer.get(n3++), byteBuffer.get(n3++), byteBuffer.get(n3++), cArray, n5++);
            ++n5;
        }
        return new String(cArray, 0, n5);
    }

    abstract int encodeUtf8(CharSequence var1, byte[] var2, int var3, int var4);

    final void encodeUtf8(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            int n = byteBuffer.arrayOffset();
            int n2 = Utf8.encode(charSequence, byteBuffer.array(), n + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(n2 - n);
        } else if (byteBuffer.isDirect()) {
            this.encodeUtf8Direct(charSequence, byteBuffer);
        } else {
            this.encodeUtf8Default(charSequence, byteBuffer);
        }
    }

    abstract void encodeUtf8Direct(CharSequence var1, ByteBuffer var2);

    final void encodeUtf8Default(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n;
        int n2 = charSequence.length();
        int n3 = byteBuffer.position();
        try {
            char c2;
            for (n = 0; n < n2 && (c2 = charSequence.charAt(n)) < '\u0080'; ++n) {
                byteBuffer.put(n3 + n, (byte)c2);
            }
            if (n == n2) {
                byteBuffer.position(n3 + n);
                return;
            }
            n3 += n;
            while (n < n2) {
                c2 = charSequence.charAt(n);
                if (c2 < '\u0080') {
                    byteBuffer.put(n3, (byte)c2);
                } else if (c2 < '\u0800') {
                    byteBuffer.put(n3++, (byte)(0xC0 | c2 >>> 6));
                    byteBuffer.put(n3, (byte)(0x80 | 0x3F & c2));
                } else if (c2 < '\ud800' || '\udfff' < c2) {
                    byteBuffer.put(n3++, (byte)(0xE0 | c2 >>> 12));
                    byteBuffer.put(n3++, (byte)(0x80 | 0x3F & c2 >>> 6));
                    byteBuffer.put(n3, (byte)(0x80 | 0x3F & c2));
                } else {
                    char c3;
                    if (n + 1 == n2 || !Character.isSurrogatePair(c2, c3 = charSequence.charAt(++n))) {
                        throw new Utf8$UnpairedSurrogateException(n, n2);
                    }
                    int n4 = Character.toCodePoint(c2, c3);
                    byteBuffer.put(n3++, (byte)(0xF0 | n4 >>> 18));
                    byteBuffer.put(n3++, (byte)(0x80 | 0x3F & n4 >>> 12));
                    byteBuffer.put(n3++, (byte)(0x80 | 0x3F & n4 >>> 6));
                    byteBuffer.put(n3, (byte)(0x80 | 0x3F & n4));
                }
                ++n;
                ++n3;
            }
            byteBuffer.position(n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int n5 = byteBuffer.position() + Math.max(n, n3 - byteBuffer.position() + 1);
            char c4 = charSequence.charAt(n);
            int n6 = n5;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c4).append(" at index ").append(n6).toString());
        }
    }
}

