/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.Utf8$DecodeUtil;
import com.google.protobuf.Utf8$Processor;
import com.google.protobuf.Utf8$UnpairedSurrogateException;
import java.nio.ByteBuffer;

final class Utf8$UnsafeProcessor
extends Utf8$Processor {
    Utf8$UnsafeProcessor() {
    }

    static boolean isAvailable() {
        return UnsafeUtil.hasUnsafeArrayOperations() && UnsafeUtil.hasUnsafeByteBufferOperations();
    }

    @Override
    int partialIsValidUtf8(int n, byte[] byArray, int n2, int n3) {
        if ((n2 | n3 | byArray.length - n3) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("Array length=%d, index=%d, limit=%d", byArray.length, n2, n3));
        }
        long l = n2;
        long l2 = n3;
        if (n != 0) {
            if (l >= l2) {
                return n;
            }
            byte by = (byte)n;
            if (by < -32) {
                if (by < -62 || UnsafeUtil.getByte(byArray, l++) > -65) {
                    return -1;
                }
            } else if (by < -16) {
                byte by2 = (byte)(~(n >> 8));
                if (by2 == 0) {
                    by2 = UnsafeUtil.getByte(byArray, l++);
                    if (l >= l2) {
                        return Utf8.access$000(by, by2);
                    }
                }
                if (by2 > -65 || by == -32 && by2 < -96 || by == -19 && by2 >= -96 || UnsafeUtil.getByte(byArray, l++) > -65) {
                    return -1;
                }
            } else {
                byte by3 = (byte)(~(n >> 8));
                byte by4 = 0;
                if (by3 == 0) {
                    by3 = UnsafeUtil.getByte(byArray, l++);
                    if (l >= l2) {
                        return Utf8.access$000(by, by3);
                    }
                } else {
                    by4 = (byte)(n >> 16);
                }
                if (by4 == 0) {
                    by4 = UnsafeUtil.getByte(byArray, l++);
                    if (l >= l2) {
                        return Utf8.access$100(by, by3, by4);
                    }
                }
                if (by3 > -65 || (by << 28) + (by3 - -112) >> 30 != 0 || by4 > -65 || UnsafeUtil.getByte(byArray, l++) > -65) {
                    return -1;
                }
            }
        }
        return Utf8$UnsafeProcessor.partialIsValidUtf8(byArray, l, (int)(l2 - l));
    }

    @Override
    int partialIsValidUtf8Direct(int n, ByteBuffer byteBuffer, int n2, int n3) {
        if ((n2 | n3 | byteBuffer.limit() - n3) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", byteBuffer.limit(), n2, n3));
        }
        long l = UnsafeUtil.addressOffset(byteBuffer) + (long)n2;
        long l2 = l + (long)(n3 - n2);
        if (n != 0) {
            if (l >= l2) {
                return n;
            }
            byte by = (byte)n;
            if (by < -32) {
                if (by < -62 || UnsafeUtil.getByte(l++) > -65) {
                    return -1;
                }
            } else if (by < -16) {
                byte by2 = (byte)(~(n >> 8));
                if (by2 == 0) {
                    by2 = UnsafeUtil.getByte(l++);
                    if (l >= l2) {
                        return Utf8.access$000(by, by2);
                    }
                }
                if (by2 > -65 || by == -32 && by2 < -96 || by == -19 && by2 >= -96 || UnsafeUtil.getByte(l++) > -65) {
                    return -1;
                }
            } else {
                byte by3 = (byte)(~(n >> 8));
                byte by4 = 0;
                if (by3 == 0) {
                    by3 = UnsafeUtil.getByte(l++);
                    if (l >= l2) {
                        return Utf8.access$000(by, by3);
                    }
                } else {
                    by4 = (byte)(n >> 16);
                }
                if (by4 == 0) {
                    by4 = UnsafeUtil.getByte(l++);
                    if (l >= l2) {
                        return Utf8.access$100(by, by3, by4);
                    }
                }
                if (by3 > -65 || (by << 28) + (by3 - -112) >> 30 != 0 || by4 > -65 || UnsafeUtil.getByte(l++) > -65) {
                    return -1;
                }
            }
        }
        return Utf8$UnsafeProcessor.partialIsValidUtf8(l, (int)(l2 - l));
    }

    @Override
    String decodeUtf8(byte[] byArray, int n, int n2) {
        byte by;
        int n3;
        if ((n | n2 | byArray.length - n - n2) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", byArray.length, n, n2));
        }
        int n4 = n3 + n2;
        char[] cArray = new char[n2];
        int n5 = 0;
        for (n3 = n; n3 < n4 && Utf8$DecodeUtil.access$400(by = UnsafeUtil.getByte(byArray, (long)n3)); ++n3) {
            Utf8$DecodeUtil.access$500(by, cArray, n5++);
        }
        while (n3 < n4) {
            if (Utf8$DecodeUtil.access$400(by = UnsafeUtil.getByte(byArray, (long)n3++))) {
                byte by2;
                Utf8$DecodeUtil.access$500(by, cArray, n5++);
                while (n3 < n4 && Utf8$DecodeUtil.access$400(by2 = UnsafeUtil.getByte(byArray, (long)n3))) {
                    ++n3;
                    Utf8$DecodeUtil.access$500(by2, cArray, n5++);
                }
                continue;
            }
            if (Utf8$DecodeUtil.access$600(by)) {
                if (n3 >= n4) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                Utf8$DecodeUtil.access$700(by, UnsafeUtil.getByte(byArray, (long)n3++), cArray, n5++);
                continue;
            }
            if (Utf8$DecodeUtil.access$800(by)) {
                if (n3 >= n4 - 1) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                Utf8$DecodeUtil.access$900(by, UnsafeUtil.getByte(byArray, (long)n3++), UnsafeUtil.getByte(byArray, (long)n3++), cArray, n5++);
                continue;
            }
            if (n3 >= n4 - 2) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            Utf8$DecodeUtil.access$1000(by, UnsafeUtil.getByte(byArray, (long)n3++), UnsafeUtil.getByte(byArray, (long)n3++), UnsafeUtil.getByte(byArray, (long)n3++), cArray, n5++);
            ++n5;
        }
        return new String(cArray, 0, n5);
    }

    @Override
    String decodeUtf8Direct(ByteBuffer byteBuffer, int n, int n2) {
        byte by;
        long l;
        if ((n | n2 | byteBuffer.limit() - n - n2) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", byteBuffer.limit(), n, n2));
        }
        long l2 = l + (long)n2;
        char[] cArray = new char[n2];
        int n3 = 0;
        for (l = UnsafeUtil.addressOffset(byteBuffer) + (long)n; l < l2 && Utf8$DecodeUtil.access$400(by = UnsafeUtil.getByte(l)); ++l) {
            Utf8$DecodeUtil.access$500(by, cArray, n3++);
        }
        while (l < l2) {
            if (Utf8$DecodeUtil.access$400(by = UnsafeUtil.getByte(l++))) {
                byte by2;
                Utf8$DecodeUtil.access$500(by, cArray, n3++);
                while (l < l2 && Utf8$DecodeUtil.access$400(by2 = UnsafeUtil.getByte(l))) {
                    ++l;
                    Utf8$DecodeUtil.access$500(by2, cArray, n3++);
                }
                continue;
            }
            if (Utf8$DecodeUtil.access$600(by)) {
                if (l >= l2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                Utf8$DecodeUtil.access$700(by, UnsafeUtil.getByte(l++), cArray, n3++);
                continue;
            }
            if (Utf8$DecodeUtil.access$800(by)) {
                if (l >= l2 - 1L) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                Utf8$DecodeUtil.access$900(by, UnsafeUtil.getByte(l++), UnsafeUtil.getByte(l++), cArray, n3++);
                continue;
            }
            if (l >= l2 - 2L) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            Utf8$DecodeUtil.access$1000(by, UnsafeUtil.getByte(l++), UnsafeUtil.getByte(l++), UnsafeUtil.getByte(l++), cArray, n3++);
            ++n3;
        }
        return new String(cArray, 0, n3);
    }

    @Override
    int encodeUtf8(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c2;
        int n3;
        long l = n;
        long l2 = l + (long)n2;
        int n4 = charSequence.length();
        if (n4 > n2 || byArray.length - n2 < n) {
            char c3 = charSequence.charAt(n4 - 1);
            int n5 = n + n2;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c3).append(" at index ").append(n5).toString());
        }
        for (n3 = 0; n3 < n4 && (c2 = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            UnsafeUtil.putByte(byArray, l++, (byte)c2);
        }
        if (n3 == n4) {
            return (int)l;
        }
        while (n3 < n4) {
            char c4;
            c2 = charSequence.charAt(n3);
            if (c2 < '\u0080' && l < l2) {
                UnsafeUtil.putByte(byArray, l++, (byte)c2);
            } else if (c2 < '\u0800' && l <= l2 - 2L) {
                UnsafeUtil.putByte(byArray, l++, (byte)(0x3C0 | c2 >>> 6));
                UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & c2));
            } else if ((c2 < '\ud800' || '\udfff' < c2) && l <= l2 - 3L) {
                UnsafeUtil.putByte(byArray, l++, (byte)(0x1E0 | c2 >>> 12));
                UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & c2 >>> 6));
                UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & c2));
            } else if (l <= l2 - 4L) {
                if (n3 + 1 == n4 || !Character.isSurrogatePair(c2, c4 = charSequence.charAt(++n3))) {
                    throw new Utf8$UnpairedSurrogateException(n3 - 1, n4);
                }
                int n6 = Character.toCodePoint(c2, c4);
                UnsafeUtil.putByte(byArray, l++, (byte)(0xF0 | n6 >>> 18));
                UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & n6 >>> 12));
                UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & n6 >>> 6));
                UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & n6));
            } else {
                if (!('\ud800' > c2 || c2 > '\udfff' || n3 + 1 != n4 && Character.isSurrogatePair(c2, charSequence.charAt(n3 + 1)))) {
                    throw new Utf8$UnpairedSurrogateException(n3, n4);
                }
                c4 = c2;
                long l3 = l;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(46).append("Failed writing ").append(c4).append(" at index ").append(l3).toString());
            }
            ++n3;
        }
        return (int)l;
    }

    @Override
    void encodeUtf8Direct(CharSequence charSequence, ByteBuffer byteBuffer) {
        char c2;
        int n;
        long l = UnsafeUtil.addressOffset(byteBuffer);
        long l2 = l + (long)byteBuffer.position();
        long l3 = l + (long)byteBuffer.limit();
        int n2 = charSequence.length();
        if ((long)n2 > l3 - l2) {
            char c3 = charSequence.charAt(n2 - 1);
            int n3 = byteBuffer.limit();
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c3).append(" at index ").append(n3).toString());
        }
        for (n = 0; n < n2 && (c2 = charSequence.charAt(n)) < '\u0080'; ++n) {
            UnsafeUtil.putByte(l2++, (byte)c2);
        }
        if (n == n2) {
            byteBuffer.position((int)(l2 - l));
            return;
        }
        while (n < n2) {
            char c4;
            c2 = charSequence.charAt(n);
            if (c2 < '\u0080' && l2 < l3) {
                UnsafeUtil.putByte(l2++, (byte)c2);
            } else if (c2 < '\u0800' && l2 <= l3 - 2L) {
                UnsafeUtil.putByte(l2++, (byte)(0x3C0 | c2 >>> 6));
                UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & c2));
            } else if ((c2 < '\ud800' || '\udfff' < c2) && l2 <= l3 - 3L) {
                UnsafeUtil.putByte(l2++, (byte)(0x1E0 | c2 >>> 12));
                UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & c2 >>> 6));
                UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & c2));
            } else if (l2 <= l3 - 4L) {
                if (n + 1 == n2 || !Character.isSurrogatePair(c2, c4 = charSequence.charAt(++n))) {
                    throw new Utf8$UnpairedSurrogateException(n - 1, n2);
                }
                int n4 = Character.toCodePoint(c2, c4);
                UnsafeUtil.putByte(l2++, (byte)(0xF0 | n4 >>> 18));
                UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & n4 >>> 12));
                UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & n4 >>> 6));
                UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & n4));
            } else {
                if (!('\ud800' > c2 || c2 > '\udfff' || n + 1 != n2 && Character.isSurrogatePair(c2, charSequence.charAt(n + 1)))) {
                    throw new Utf8$UnpairedSurrogateException(n, n2);
                }
                c4 = c2;
                long l4 = l2;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(46).append("Failed writing ").append(c4).append(" at index ").append(l4).toString());
            }
            ++n;
        }
        byteBuffer.position((int)(l2 - l));
    }

    private static int unsafeEstimateConsecutiveAscii(byte[] byArray, long l, int n) {
        if (n < 16) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            if (UnsafeUtil.getByte(byArray, l++) >= 0) continue;
            return i;
        }
        return n;
    }

    private static int unsafeEstimateConsecutiveAscii(long l, int n) {
        int n2;
        int n3 = n;
        if (n3 < 16) {
            return 0;
        }
        for (int i = n2 = 8 - ((int)l & 7); i > 0; --i) {
            if (UnsafeUtil.getByte(l++) >= 0) continue;
            return n2 - i;
        }
        n3 -= n2;
        while (n3 >= 8 && (UnsafeUtil.getLong(l) & 0x8080808080808080L) == 0L) {
            l += 8L;
            n3 -= 8;
        }
        return n - n3;
    }

    private static int partialIsValidUtf8(byte[] byArray, long l, int n) {
        int n2 = Utf8$UnsafeProcessor.unsafeEstimateConsecutiveAscii(byArray, l, n);
        n -= n2;
        l += (long)n2;
        while (true) {
            byte by;
            int n3 = 0;
            while (n > 0) {
                byte by2 = UnsafeUtil.getByte(byArray, l++);
                n3 = by2;
                if (by2 < 0) break;
                --n;
            }
            if (n == 0) {
                return 0;
            }
            --n;
            if (n3 < -32) {
                if (n == 0) {
                    return n3;
                }
                --n;
                if (n3 >= -62 && UnsafeUtil.getByte(byArray, l++) <= -65) continue;
                return -1;
            }
            if (n3 < -16) {
                if (n < 2) {
                    return Utf8$UnsafeProcessor.unsafeIncompleteStateFor(byArray, n3, l, n);
                }
                n -= 2;
                if (!((by = UnsafeUtil.getByte(byArray, l++)) > -65 || n3 == -32 && by < -96 || n3 == -19 && by >= -96) && UnsafeUtil.getByte(byArray, l++) <= -65) continue;
                return -1;
            }
            if (n < 3) {
                return Utf8$UnsafeProcessor.unsafeIncompleteStateFor(byArray, n3, l, n);
            }
            n -= 3;
            if ((by = UnsafeUtil.getByte(byArray, l++)) > -65 || (n3 << 28) + (by - -112) >> 30 != 0 || UnsafeUtil.getByte(byArray, l++) > -65 || UnsafeUtil.getByte(byArray, l++) > -65) break;
        }
        return -1;
    }

    private static int partialIsValidUtf8(long l, int n) {
        int n2 = Utf8$UnsafeProcessor.unsafeEstimateConsecutiveAscii(l, n);
        l += (long)n2;
        n -= n2;
        while (true) {
            byte by;
            int n3 = 0;
            while (n > 0) {
                byte by2 = UnsafeUtil.getByte(l++);
                n3 = by2;
                if (by2 < 0) break;
                --n;
            }
            if (n == 0) {
                return 0;
            }
            --n;
            if (n3 < -32) {
                if (n == 0) {
                    return n3;
                }
                --n;
                if (n3 >= -62 && UnsafeUtil.getByte(l++) <= -65) continue;
                return -1;
            }
            if (n3 < -16) {
                if (n < 2) {
                    return Utf8$UnsafeProcessor.unsafeIncompleteStateFor(l, n3, n);
                }
                n -= 2;
                if (!((by = UnsafeUtil.getByte(l++)) > -65 || n3 == -32 && by < -96 || n3 == -19 && by >= -96) && UnsafeUtil.getByte(l++) <= -65) continue;
                return -1;
            }
            if (n < 3) {
                return Utf8$UnsafeProcessor.unsafeIncompleteStateFor(l, n3, n);
            }
            n -= 3;
            if ((by = UnsafeUtil.getByte(l++)) > -65 || (n3 << 28) + (by - -112) >> 30 != 0 || UnsafeUtil.getByte(l++) > -65 || UnsafeUtil.getByte(l++) > -65) break;
        }
        return -1;
    }

    private static int unsafeIncompleteStateFor(byte[] byArray, int n, long l, int n2) {
        switch (n2) {
            case 0: {
                return Utf8.access$1200(n);
            }
            case 1: {
                return Utf8.access$000(n, UnsafeUtil.getByte(byArray, l));
            }
            case 2: {
                return Utf8.access$100(n, UnsafeUtil.getByte(byArray, l), UnsafeUtil.getByte(byArray, l + 1L));
            }
        }
        throw new AssertionError();
    }

    private static int unsafeIncompleteStateFor(long l, int n, int n2) {
        switch (n2) {
            case 0: {
                return Utf8.access$1200(n);
            }
            case 1: {
                return Utf8.access$000(n, UnsafeUtil.getByte(l));
            }
            case 2: {
                return Utf8.access$100(n, UnsafeUtil.getByte(l), UnsafeUtil.getByte(l + 1L));
            }
        }
        throw new AssertionError();
    }
}

