/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.WholeImageFilter;
import com.jhlabs.math.Noise;
import java.awt.Rectangle;
import java.util.Random;

public class CausticsFilter
extends WholeImageFilter {
    private float scale = 32.0f;
    private float angle = 0.0f;
    public int brightness = 10;
    public float amount = 1.0f;
    public float turbulence = 1.0f;
    public float dispersion = 0.0f;
    public float time = 0.0f;
    private int samples = 2;
    private int bgColor = -8806401;
    private float s;
    private float c;

    public void setScale(float f2) {
        this.scale = f2;
    }

    public float getScale() {
        return this.scale;
    }

    public void setBrightness(int n) {
        this.brightness = n;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setTurbulence(float f2) {
        this.turbulence = f2;
    }

    public float getTurbulence() {
        return this.turbulence;
    }

    public void setAmount(float f2) {
        this.amount = f2;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setDispersion(float f2) {
        this.dispersion = f2;
    }

    public float getDispersion() {
        return this.dispersion;
    }

    public void setTime(float f2) {
        this.time = f2;
    }

    public float getTime() {
        return this.time;
    }

    public void setSamples(int n) {
        this.samples = n;
    }

    public int getSamples() {
        return this.samples;
    }

    public void setBgColor(int n) {
        this.bgColor = n;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    protected int[] filterPixels(int n, int n2, int[] nArray, Rectangle rectangle) {
        int n3;
        Random random = new Random(0L);
        this.s = (float)Math.sin(0.1);
        this.c = (float)Math.cos(0.1);
        int n4 = this.originalSpace.width;
        int n5 = this.originalSpace.height;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = 0;
        int[] nArray2 = new int[n6 * n7];
        for (n3 = 0; n3 < n7; ++n3) {
            for (int i = 0; i < n6; ++i) {
                nArray2[n8++] = this.bgColor;
            }
        }
        n3 = this.brightness / this.samples;
        if (n3 == 0) {
            n3 = 1;
        }
        float f2 = 1.0f / this.scale;
        float f3 = 0.95f;
        n8 = 0;
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n6; ++j) {
                for (int k = 0; k < this.samples; ++k) {
                    int n9;
                    int n10;
                    int n11;
                    float f4;
                    float f5 = (float)j + random.nextFloat();
                    float f6 = (float)i + random.nextFloat();
                    float f7 = f5 * f2;
                    float f8 = f6 * f2;
                    float f9 = 0.1f + this.amount;
                    float f10 = this.evaluate(f7 - f3, f8) - this.evaluate(f7 + f3, f8);
                    float f11 = this.evaluate(f7, f8 + f3) - this.evaluate(f7, f8 - f3);
                    if (this.dispersion > 0.0f) {
                        for (int i2 = 0; i2 < 3; ++i2) {
                            f4 = 1.0f + (float)i2 * this.dispersion;
                            float f12 = f5 + this.scale * f9 * f10 * f4;
                            float f13 = f6 + this.scale * f9 * f11 * f4;
                            if (f12 < 0.0f || f12 >= (float)(n6 - 1) || f13 < 0.0f || f13 >= (float)(n7 - 1)) continue;
                            n11 = (int)f13 * n6 + (int)f12;
                            n10 = nArray2[n11];
                            n9 = n10 >> 16 & 0xFF;
                            int n12 = n10 >> 8 & 0xFF;
                            int n13 = n10 & 0xFF;
                            if (i2 == 2) {
                                n9 += n3;
                            } else if (i2 == 1) {
                                n12 += n3;
                            } else {
                                n13 += n3;
                            }
                            if (n9 > 255) {
                                n9 = 255;
                            }
                            if (n12 > 255) {
                                n12 = 255;
                            }
                            if (n13 > 255) {
                                n13 = 255;
                            }
                            nArray2[n11] = 0xFF000000 | n9 << 16 | n12 << 8 | n13;
                        }
                        continue;
                    }
                    float f14 = f5 + this.scale * f9 * f10;
                    f4 = f6 + this.scale * f9 * f11;
                    if (f14 < 0.0f || f14 >= (float)(n6 - 1) || f4 < 0.0f || f4 >= (float)(n7 - 1)) continue;
                    int n14 = (int)f4 * n6 + (int)f14;
                    int n15 = nArray2[n14];
                    n11 = n15 >> 16 & 0xFF;
                    n10 = n15 >> 8 & 0xFF;
                    n9 = n15 & 0xFF;
                    n10 += n3;
                    n9 += n3;
                    if ((n11 += n3) > 255) {
                        n11 = 255;
                    }
                    if (n10 > 255) {
                        n10 = 255;
                    }
                    if (n9 > 255) {
                        n9 = 255;
                    }
                    nArray2[n14] = 0xFF000000 | n11 << 16 | n10 << 8 | n9;
                }
            }
        }
        return nArray2;
    }

    private static int add(int n, float f2) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        n2 = (int)((float)n2 + f2);
        n3 = (int)((float)n3 + f2);
        n4 = (int)((float)n4 + f2);
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        return 0xFF000000 | n2 << 16 | n3 << 8 | n4;
    }

    private static int add(int n, float f2, int n2) {
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        if (n2 == 2) {
            n3 = (int)((float)n3 + f2);
        } else if (n2 == 1) {
            n4 = (int)((float)n4 + f2);
        } else {
            n5 = (int)((float)n5 + f2);
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        return 0xFF000000 | n3 << 16 | n4 << 8 | n5;
    }

    public static float turbulence2(float f2, float f3, float f4, float f5) {
        float f6 = 0.0f;
        float f7 = 2.0f;
        float f8 = 1.0f;
        f2 += 371.0f;
        f3 += 529.0f;
        for (int i = 0; i < (int)f5; ++i) {
            f6 += Noise.noise3(f2, f3, f4) / f8;
            f2 *= f7;
            f3 *= f7;
            f8 *= 2.0f;
        }
        float f9 = f5 - (float)((int)f5);
        if (f9 != 0.0f) {
            f6 += f9 * Noise.noise3(f2, f3, f4) / f8;
        }
        return f6;
    }

    protected float evaluate(float f2, float f3) {
        float f4 = this.s * f2 + this.c * this.time;
        float f5 = this.c * f2 - this.c * this.time;
        float f6 = (double)this.turbulence == 0.0 ? Noise.noise3(f4, f3, f5) : CausticsFilter.turbulence2(f4, f3, f5, this.turbulence);
        return f6;
    }

    public String toString() {
        return "Texture/Caustics...";
    }
}

