/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.CellularFilter$Point;
import com.jhlabs.image.Colormap;
import com.jhlabs.image.Gradient;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.MutatableFilter;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.WholeImageFilter;
import com.jhlabs.math.Function2D;
import com.jhlabs.math.Noise;
import java.awt.Rectangle;
import java.awt.image.BufferedImageOp;
import java.io.Serializable;
import java.util.Random;

public class CellularFilter
extends WholeImageFilter
implements MutatableFilter,
Function2D,
Serializable,
Cloneable {
    protected float scale = 32.0f;
    protected float stretch = 1.0f;
    protected float angle = 0.0f;
    public float amount = 1.0f;
    public float turbulence = 1.0f;
    public float gain = 0.5f;
    public float bias = 0.5f;
    public float distancePower = 2.0f;
    public boolean useColor = false;
    protected Colormap colormap = new Gradient();
    protected float[] coefficients = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    protected float angleCoefficient;
    protected Random random = new Random();
    protected float m00 = 1.0f;
    protected float m01 = 0.0f;
    protected float m10 = 0.0f;
    protected float m11 = 1.0f;
    protected CellularFilter$Point[] results = new CellularFilter$Point[3];
    protected float randomness = 0.0f;
    protected int gridType = 2;
    private float min;
    private float max;
    private static byte[] probabilities;
    private float gradientCoefficient;
    public static final int RANDOM = 0;
    public static final int SQUARE = 1;
    public static final int HEXAGONAL = 2;
    public static final int OCTAGONAL = 3;
    public static final int TRIANGULAR = 4;

    public CellularFilter() {
        for (int i = 0; i < this.results.length; ++i) {
            this.results[i] = new CellularFilter$Point(this);
        }
        if (probabilities == null) {
            probabilities = new byte[8192];
            float f2 = 1.0f;
            float f3 = 0.0f;
            float f4 = 2.5f;
            for (int i = 0; i < 10; ++i) {
                if (i > 1) {
                    f2 *= (float)i;
                }
                float f5 = (float)Math.pow(f4, i) * (float)Math.exp(-f4) / f2;
                int n = (int)(f3 * 8192.0f);
                int n2 = (int)((f3 += f5) * 8192.0f);
                for (int j = n; j < n2; ++j) {
                    CellularFilter.probabilities[j] = (byte)i;
                }
            }
        }
    }

    public void setScale(float f2) {
        this.scale = f2;
    }

    public float getScale() {
        return this.scale;
    }

    public void setStretch(float f2) {
        this.stretch = f2;
    }

    public float getStretch() {
        return this.stretch;
    }

    public void setAngle(float f2) {
        this.angle = f2;
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        this.m00 = f3;
        this.m01 = f4;
        this.m10 = -f4;
        this.m11 = f3;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setCoefficient(int n, float f2) {
        this.coefficients[n] = f2;
    }

    public float getCoefficient(int n) {
        return this.coefficients[n];
    }

    public void setAngleCoefficient(float f2) {
        this.angleCoefficient = f2;
    }

    public float getAngleCoefficient() {
        return this.angleCoefficient;
    }

    public void setGradientCoefficient(float f2) {
        this.gradientCoefficient = f2;
    }

    public float getGradientCoefficient() {
        return this.gradientCoefficient;
    }

    public void setF1(float f2) {
        this.coefficients[0] = f2;
    }

    public float getF1() {
        return this.coefficients[0];
    }

    public void setF2(float f2) {
        this.coefficients[1] = f2;
    }

    public float getF2() {
        return this.coefficients[1];
    }

    public void setF3(float f2) {
        this.coefficients[2] = f2;
    }

    public float getF3() {
        return this.coefficients[2];
    }

    public void setF4(float f2) {
        this.coefficients[3] = f2;
    }

    public float getF4() {
        return this.coefficients[3];
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setRandomness(float f2) {
        this.randomness = f2;
    }

    public float getRandomness() {
        return this.randomness;
    }

    public void setGridType(int n) {
        this.gridType = n;
    }

    public int getGridType() {
        return this.gridType;
    }

    public void setDistancePower(float f2) {
        this.distancePower = f2;
    }

    public float getDistancePower() {
        return this.distancePower;
    }

    public void setTurbulence(float f2) {
        this.turbulence = f2;
    }

    public float getTurbulence() {
        return this.turbulence;
    }

    public void setAmount(float f2) {
        this.amount = f2;
    }

    public float getAmount() {
        return this.amount;
    }

    private float checkCube(float f2, float f3, int n, int n2, CellularFilter$Point[] cellularFilter$PointArray) {
        int n3;
        this.random.setSeed(571 * n + 23 * n2);
        switch (this.gridType) {
            default: {
                n3 = probabilities[this.random.nextInt() & 0x1FFF];
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 2;
            }
        }
        for (int i = 0; i < n3; ++i) {
            CellularFilter$Point cellularFilter$Point;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 1.0f;
            switch (this.gridType) {
                case 0: {
                    f4 = this.random.nextFloat();
                    f5 = this.random.nextFloat();
                    break;
                }
                case 1: {
                    f5 = 0.5f;
                    f4 = 0.5f;
                    if (this.randomness == 0.0f) break;
                    f4 = (float)((double)f4 + (double)this.randomness * ((double)this.random.nextFloat() - 0.5));
                    f5 = (float)((double)f5 + (double)this.randomness * ((double)this.random.nextFloat() - 0.5));
                    break;
                }
                case 2: {
                    if ((n & 1) == 0) {
                        f4 = 0.75f;
                        f5 = 0.0f;
                    } else {
                        f4 = 0.75f;
                        f5 = 0.5f;
                    }
                    if (this.randomness == 0.0f) break;
                    f4 += this.randomness * Noise.noise2(271.0f * ((float)n + f4), 271.0f * ((float)n2 + f5));
                    f5 += this.randomness * Noise.noise2(271.0f * ((float)n + f4) + 89.0f, 271.0f * ((float)n2 + f5) + 137.0f);
                    break;
                }
                case 3: {
                    switch (i) {
                        case 0: {
                            f4 = 0.207f;
                            f5 = 0.207f;
                            break;
                        }
                        case 1: {
                            f4 = 0.707f;
                            f5 = 0.707f;
                            f6 = 1.6f;
                        }
                    }
                    if (this.randomness == 0.0f) break;
                    f4 += this.randomness * Noise.noise2(271.0f * ((float)n + f4), 271.0f * ((float)n2 + f5));
                    f5 += this.randomness * Noise.noise2(271.0f * ((float)n + f4) + 89.0f, 271.0f * ((float)n2 + f5) + 137.0f);
                    break;
                }
                case 4: {
                    if ((n2 & 1) == 0) {
                        if (i == 0) {
                            f4 = 0.25f;
                            f5 = 0.35f;
                        } else {
                            f4 = 0.75f;
                            f5 = 0.65f;
                        }
                    } else if (i == 0) {
                        f4 = 0.75f;
                        f5 = 0.35f;
                    } else {
                        f4 = 0.25f;
                        f5 = 0.65f;
                    }
                    if (this.randomness == 0.0f) break;
                    f4 += this.randomness * Noise.noise2(271.0f * ((float)n + f4), 271.0f * ((float)n2 + f5));
                    f5 += this.randomness * Noise.noise2(271.0f * ((float)n + f4) + 89.0f, 271.0f * ((float)n2 + f5) + 137.0f);
                }
            }
            float f7 = Math.abs(f2 - f4);
            float f8 = Math.abs(f3 - f5);
            float f9 = this.distancePower == 1.0f ? f7 + f8 : (this.distancePower == 2.0f ? (float)Math.sqrt(f7 * f7 + f8 * f8) : (float)Math.pow((float)Math.pow(f7 *= f6, this.distancePower) + (float)Math.pow(f8 *= f6, this.distancePower), 1.0f / this.distancePower));
            if (f9 < cellularFilter$PointArray[0].distance) {
                cellularFilter$Point = cellularFilter$PointArray[2];
                cellularFilter$PointArray[2] = cellularFilter$PointArray[1];
                cellularFilter$PointArray[1] = cellularFilter$PointArray[0];
                cellularFilter$PointArray[0] = cellularFilter$Point;
                cellularFilter$Point.distance = f9;
                cellularFilter$Point.dx = f7;
                cellularFilter$Point.dy = f8;
                cellularFilter$Point.x = (float)n + f4;
                cellularFilter$Point.y = (float)n2 + f5;
                continue;
            }
            if (f9 < cellularFilter$PointArray[1].distance) {
                cellularFilter$Point = cellularFilter$PointArray[2];
                cellularFilter$PointArray[2] = cellularFilter$PointArray[1];
                cellularFilter$PointArray[1] = cellularFilter$Point;
                cellularFilter$Point.distance = f9;
                cellularFilter$Point.dx = f7;
                cellularFilter$Point.dy = f8;
                cellularFilter$Point.x = (float)n + f4;
                cellularFilter$Point.y = (float)n2 + f5;
                continue;
            }
            if (!(f9 < cellularFilter$PointArray[2].distance)) continue;
            cellularFilter$Point = cellularFilter$PointArray[2];
            cellularFilter$Point.distance = f9;
            cellularFilter$Point.dx = f7;
            cellularFilter$Point.dy = f8;
            cellularFilter$Point.x = (float)n + f4;
            cellularFilter$Point.y = (float)n2 + f5;
        }
        return cellularFilter$PointArray[2].distance;
    }

    public float evaluate(float f2, float f3) {
        int n;
        for (n = 0; n < this.results.length; ++n) {
            this.results[n].distance = Float.POSITIVE_INFINITY;
        }
        n = (int)f2;
        float f4 = f2 - (float)n;
        int n2 = (int)f3;
        float f5 = f3 - (float)n2;
        float f6 = this.checkCube(f4, f5, n, n2, this.results);
        if (f6 > f5) {
            f6 = this.checkCube(f4, f5 + 1.0f, n, n2 - 1, this.results);
        }
        if (f6 > 1.0f - f5) {
            f6 = this.checkCube(f4, f5 - 1.0f, n, n2 + 1, this.results);
        }
        if (f6 > f4) {
            this.checkCube(f4 + 1.0f, f5, n - 1, n2, this.results);
            if (f6 > f5) {
                f6 = this.checkCube(f4 + 1.0f, f5 + 1.0f, n - 1, n2 - 1, this.results);
            }
            if (f6 > 1.0f - f5) {
                f6 = this.checkCube(f4 + 1.0f, f5 - 1.0f, n - 1, n2 + 1, this.results);
            }
        }
        if (f6 > 1.0f - f4) {
            f6 = this.checkCube(f4 - 1.0f, f5, n + 1, n2, this.results);
            if (f6 > f5) {
                f6 = this.checkCube(f4 - 1.0f, f5 + 1.0f, n + 1, n2 - 1, this.results);
            }
            if (f6 > 1.0f - f5) {
                f6 = this.checkCube(f4 - 1.0f, f5 - 1.0f, n + 1, n2 + 1, this.results);
            }
        }
        float f7 = 0.0f;
        for (int i = 0; i < 3; ++i) {
            f7 += this.coefficients[i] * this.results[i].distance;
        }
        if (this.angleCoefficient != 0.0f) {
            float f8 = (float)Math.atan2(f3 - this.results[0].y, f2 - this.results[0].x);
            if (f8 < 0.0f) {
                f8 += (float)Math.PI * 2;
            }
            f7 += this.angleCoefficient * (f8 /= (float)Math.PI * 4);
        }
        if (this.gradientCoefficient != 0.0f) {
            float f9 = 1.0f / (this.results[0].dy + this.results[0].dx);
            f7 += this.gradientCoefficient * f9;
        }
        return f7;
    }

    public float turbulence2(float f2, float f3, float f4) {
        float f5 = 0.0f;
        for (float f6 = 1.0f; f6 <= f4; f6 *= 2.0f) {
            f5 += this.evaluate(f6 * f2, f6 * f3) / f6;
        }
        return f5;
    }

    public int getPixel(int n, int n2, int[] nArray, int n3, int n4) {
        try {
            float f2 = this.m00 * (float)n + this.m01 * (float)n2;
            float f3 = this.m10 * (float)n + this.m11 * (float)n2;
            f2 /= this.scale;
            f3 /= this.scale * this.stretch;
            float f4 = this.turbulence == 1.0f ? this.evaluate(f2, f3) : this.turbulence2(f2 += 1000.0f, f3 += 1000.0f, this.turbulence);
            f4 *= 2.0f;
            f4 *= this.amount;
            int n5 = -16777216;
            if (this.colormap != null) {
                int n6 = this.colormap.getColor(f4);
                if (this.useColor) {
                    int n7 = ImageMath.clamp((int)((this.results[0].x - 1000.0f) * this.scale), 0, n3 - 1);
                    int n8 = ImageMath.clamp((int)((this.results[0].y - 1000.0f) * this.scale), 0, n4 - 1);
                    n6 = nArray[n8 * n3 + n7];
                    f4 = (this.results[1].distance - this.results[0].distance) / (this.results[1].distance + this.results[0].distance);
                    f4 = ImageMath.smoothStep(this.coefficients[1], this.coefficients[0], f4);
                    n6 = ImageMath.mixColors(f4, -16777216, n6);
                }
                return n6;
            }
            int n9 = PixelUtils.clamp((int)(f4 * 255.0f));
            int n10 = n9 << 16;
            int n11 = n9 << 8;
            int n12 = n9;
            return n5 | n10 | n11 | n12;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    protected int[] filterPixels(int n, int n2, int[] nArray, Rectangle rectangle) {
        int n3 = 0;
        int[] nArray2 = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray2[n3++] = this.getPixel(j, i, nArray, n, n2);
            }
        }
        return nArray2;
    }

    public void mutate(float f2, BufferedImageOp bufferedImageOp, boolean bl, boolean bl2) {
        CellularFilter cellularFilter = (CellularFilter)bufferedImageOp;
        this.random.setSeed((int)System.currentTimeMillis());
        if (bl || this.amount == 0.0f) {
            cellularFilter.setGridType(this.getGridType());
            cellularFilter.setRandomness(this.getRandomness());
            cellularFilter.setScale(this.getScale());
            cellularFilter.setAngle(this.getAngle());
            cellularFilter.setStretch(this.getStretch());
            cellularFilter.setAmount(this.getAmount());
            cellularFilter.setTurbulence(this.getTurbulence());
            cellularFilter.setColormap(this.getColormap());
            cellularFilter.setDistancePower(this.getDistancePower());
            cellularFilter.setAngleCoefficient(this.getAngleCoefficient());
            for (int i = 0; i < 4; ++i) {
                cellularFilter.setCoefficient(i, this.getCoefficient(i));
            }
        } else {
            cellularFilter.scale = this.mutate(this.scale, f2, 0.4f, 5.0f, 3.0f, 200.0f);
            cellularFilter.setAngle(this.mutate(this.angle, f2, 0.3f, 1.5707964f));
            cellularFilter.stretch = this.mutate(this.stretch, f2, 0.3f, 3.0f, 1.0f, 10.0f);
            cellularFilter.amount = this.mutate(this.amount, f2, 0.3f, 0.2f, 0.0f, 1.0f);
            cellularFilter.turbulence = this.mutate(this.turbulence, f2, 0.3f, 0.5f, 1.0f, 8.0f);
            cellularFilter.distancePower = this.mutate(this.distancePower, f2, 0.2f, 0.5f, 1.0f, 3.0f);
            cellularFilter.randomness = this.mutate(this.randomness, f2, 0.4f, 0.2f, 0.0f, 1.0f);
            for (int i = 0; i < this.coefficients.length; ++i) {
                cellularFilter.coefficients[i] = this.mutate(this.coefficients[i], f2, 0.3f, 0.2f, -1.0f, 1.0f);
            }
            if ((double)this.random.nextFloat() <= (double)f2 * 0.2) {
                cellularFilter.gridType = this.random.nextInt() % 5;
            }
            cellularFilter.angleCoefficient = this.mutate(this.angleCoefficient, f2, 0.2f, 0.5f, -1.0f, 1.0f);
        }
        if (bl2 || f2 == 0.0f) {
            cellularFilter.setColormap(this.getColormap());
        } else if (this.random.nextFloat() <= f2) {
            if (this.random.nextFloat() <= f2) {
                cellularFilter.setColormap(Gradient.randomGradient());
            } else {
                ((Gradient)cellularFilter.getColormap()).mutate(f2);
            }
        }
    }

    private float mutate(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.random.nextFloat() <= f3 * f4) {
            return f2;
        }
        return ImageMath.clamp(f2 + f3 * f5 * (float)this.random.nextGaussian(), f6, f7);
    }

    private float mutate(float f2, float f3, float f4, float f5) {
        if (this.random.nextFloat() <= f3 * f4) {
            return f2;
        }
        return f2 + f3 * f5 * (float)this.random.nextGaussian();
    }

    public Object clone() {
        CellularFilter cellularFilter = (CellularFilter)super.clone();
        cellularFilter.coefficients = (float[])this.coefficients.clone();
        cellularFilter.results = (CellularFilter$Point[])this.results.clone();
        cellularFilter.random = new Random();
        return cellularFilter;
    }

    public String toString() {
        return "Texture/Cellular...";
    }
}

