/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ConvolveFilter;
import com.jhlabs.image.GaussianFilter;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.LightFilter$1;
import com.jhlabs.image.LightFilter$DistantLight;
import com.jhlabs.image.LightFilter$Light;
import com.jhlabs.image.LightFilter$Material;
import com.jhlabs.image.WholeImageFilter;
import com.jhlabs.math.Function2D;
import com.jhlabs.math.ImageFunction2D;
import com.jhlabs.vecmath.Color4f;
import com.jhlabs.vecmath.Tuple3f;
import com.jhlabs.vecmath.Vector3f;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Kernel;
import java.io.Serializable;
import java.util.Vector;

public class LightFilter
extends WholeImageFilter
implements Serializable {
    public static final int COLORS_FROM_IMAGE = 0;
    public static final int COLORS_CONSTANT = 1;
    public static final int BUMPS_FROM_IMAGE = 0;
    public static final int BUMPS_FROM_IMAGE_ALPHA = 1;
    public static final int BUMPS_FROM_MAP = 2;
    public static final int BUMPS_FROM_BEVEL = 3;
    private float bumpHeight;
    private float bumpSoftness;
    private int bumpShape;
    private float viewDistance = 10000.0f;
    LightFilter$Material material;
    private Vector lights = new Vector();
    private int colorSource = 0;
    private int bumpSource = 0;
    private Function2D bumpFunction;
    private Image environmentMap;
    private int[] envPixels;
    private int envWidth = 1;
    private int envHeight = 1;
    private Vector3f l;
    private Vector3f v;
    private Vector3f n;
    private Color4f shadedColor;
    private Color4f diffuse_color;
    private Color4f specular_color;
    private Vector3f tmpv;
    private Vector3f tmpv2;
    protected static final float r255 = 0.003921569f;
    public static final int AMBIENT = 0;
    public static final int DISTANT = 1;
    public static final int POINT = 2;
    public static final int SPOT = 3;

    public LightFilter() {
        this.addLight(new LightFilter$DistantLight(this));
        this.bumpHeight = 1.0f;
        this.bumpSoftness = 5.0f;
        this.bumpShape = 0;
        this.material = new LightFilter$Material();
        this.l = new Vector3f();
        this.v = new Vector3f();
        this.n = new Vector3f();
        this.shadedColor = new Color4f();
        this.diffuse_color = new Color4f();
        this.specular_color = new Color4f();
        this.tmpv = new Vector3f();
        this.tmpv2 = new Vector3f();
    }

    public void setBumpFunction(Function2D function2D) {
        this.bumpFunction = function2D;
    }

    public Function2D getBumpFunction() {
        return this.bumpFunction;
    }

    public void setBumpHeight(float f2) {
        this.bumpHeight = f2;
    }

    public float getBumpHeight() {
        return this.bumpHeight;
    }

    public void setBumpSoftness(float f2) {
        this.bumpSoftness = f2;
    }

    public float getBumpSoftness() {
        return this.bumpSoftness;
    }

    public void setBumpShape(int n) {
        this.bumpShape = n;
    }

    public int getBumpShape() {
        return this.bumpShape;
    }

    public void setViewDistance(float f2) {
        this.viewDistance = f2;
    }

    public float getViewDistance() {
        return this.viewDistance;
    }

    public void setEnvironmentMap(BufferedImage bufferedImage) {
        this.environmentMap = bufferedImage;
        if (bufferedImage != null) {
            this.envWidth = bufferedImage.getWidth();
            this.envHeight = bufferedImage.getHeight();
            this.envPixels = this.getRGB(bufferedImage, 0, 0, this.envWidth, this.envHeight, null);
        } else {
            this.envHeight = 1;
            this.envWidth = 1;
            this.envPixels = null;
        }
    }

    public Image getEnvironmentMap() {
        return this.environmentMap;
    }

    public void setColorSource(int n) {
        this.colorSource = n;
    }

    public int getColorSource() {
        return this.colorSource;
    }

    public void setBumpSource(int n) {
        this.bumpSource = n;
    }

    public int getBumpSource() {
        return this.bumpSource;
    }

    public void setDiffuseColor(int n) {
        this.material.diffuseColor = n;
    }

    public int getDiffuseColor() {
        return this.material.diffuseColor;
    }

    public void addLight(LightFilter$Light lightFilter$Light) {
        this.lights.addElement(lightFilter$Light);
    }

    public void removeLight(LightFilter$Light lightFilter$Light) {
        this.lights.removeElement(lightFilter$Light);
    }

    public Vector getLights() {
        return this.lights;
    }

    protected void setFromRGB(Color4f color4f, int n) {
        color4f.set((float)(n >> 16 & 0xFF) * 0.003921569f, (float)(n >> 8 & 0xFF) * 0.003921569f, (float)(n & 0xFF) * 0.003921569f, (float)(n >> 24 & 0xFF) * 0.003921569f);
    }

    protected int[] filterPixels(int n, int n2, int[] nArray, Rectangle rectangle) {
        int n3;
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        int n4 = 0;
        int[] nArray2 = new int[n * n2];
        float f2 = Math.abs(6.0f * this.bumpHeight);
        boolean bl = this.bumpHeight < 0.0f;
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f((float)n / 2.0f, (float)n2 / 2.0f, this.viewDistance);
        Vector3f vector3f3 = new Vector3f();
        Color4f color4f = new Color4f();
        Color4f color4f2 = new Color4f(new Color(this.material.diffuseColor));
        Color4f color4f3 = new Color4f(new Color(this.material.specularColor));
        Function2D function2D = this.bumpFunction;
        if (this.bumpSource == 0 || this.bumpSource == 1 || this.bumpSource == 2 || function2D == null) {
            if (this.bumpSoftness != 0.0f) {
                int n5 = n;
                int n6 = n2;
                object3 = nArray;
                if (this.bumpSource == 2 && this.bumpFunction instanceof ImageFunction2D) {
                    object2 = (ImageFunction2D)this.bumpFunction;
                    n5 = ((ImageFunction2D)object2).getWidth();
                    n6 = ((ImageFunction2D)object2).getHeight();
                    object3 = ((ImageFunction2D)object2).getPixels();
                }
                object2 = new int[n5 * n6];
                object = new int[n5 * n6];
                objectArray = GaussianFilter.makeKernel(this.bumpSoftness);
                GaussianFilter.convolveAndTranspose((Kernel)objectArray, object3, (int[])object2, n5, n6, true, ConvolveFilter.WRAP_EDGES);
                GaussianFilter.convolveAndTranspose((Kernel)objectArray, (int[])object2, (int[])object, n6, n5, true, ConvolveFilter.WRAP_EDGES);
                Function2D function2D2 = function2D = new ImageFunction2D((int[])object, n5, n6, 1, this.bumpSource == 1);
                if (this.bumpShape != 0) {
                    function2D = new LightFilter$1(this, function2D2);
                }
            } else if (this.bumpSource != 2) {
                function2D = new ImageFunction2D(nArray, n, n2, 1, this.bumpSource == 1);
            }
        }
        float f3 = this.material.reflectivity;
        float f4 = 1.0f - f3;
        object3 = new Vector3f();
        object2 = new Vector3f();
        object = new Vector3f();
        objectArray = new LightFilter$Light[this.lights.size()];
        this.lights.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            ((LightFilter$Light)objectArray[i]).prepare(n, n2);
        }
        float[][] fArray = new float[3][n];
        for (n3 = 0; n3 < n; ++n3) {
            fArray[1][n3] = f2 * function2D.evaluate(n3, 0.0f);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n7;
            boolean bl2 = n3 > 0;
            boolean bl3 = n3 < n2 - 1;
            vector3f.y = n3;
            for (n7 = 0; n7 < n; ++n7) {
                fArray[2][n7] = f2 * function2D.evaluate(n7, n3 + 1);
            }
            for (n7 = 0; n7 < n; ++n7) {
                boolean bl4;
                boolean bl5 = n7 > 0;
                boolean bl6 = bl4 = n7 < n - 1;
                if (this.bumpSource != 3) {
                    float f5;
                    int n8 = 0;
                    vector3f3.z = 0.0f;
                    vector3f3.y = 0.0f;
                    vector3f3.x = 0.0f;
                    float f6 = fArray[1][n7];
                    float f7 = bl5 ? fArray[1][n7 - 1] - f6 : 0.0f;
                    float f8 = bl2 ? fArray[0][n7] - f6 : 0.0f;
                    float f9 = bl4 ? fArray[1][n7 + 1] - f6 : 0.0f;
                    float f10 = f5 = bl3 ? fArray[2][n7] - f6 : 0.0f;
                    if (bl5 && bl3) {
                        object3.x = -1.0f;
                        object3.y = 0.0f;
                        object3.z = f7;
                        ((Tuple3f)object2).x = 0.0f;
                        ((Tuple3f)object2).y = 1.0f;
                        ((Tuple3f)object2).z = f5;
                        ((Vector3f)object).cross((Vector3f)object3, (Vector3f)object2);
                        ((Vector3f)object).normalize();
                        if ((double)((Tuple3f)object).z < 0.0) {
                            ((Tuple3f)object).z = -((Tuple3f)object).z;
                        }
                        vector3f3.add((Tuple3f)object);
                        ++n8;
                    }
                    if (bl5 && bl2) {
                        object3.x = -1.0f;
                        object3.y = 0.0f;
                        object3.z = f7;
                        ((Tuple3f)object2).x = 0.0f;
                        ((Tuple3f)object2).y = -1.0f;
                        ((Tuple3f)object2).z = f8;
                        ((Vector3f)object).cross((Vector3f)object3, (Vector3f)object2);
                        ((Vector3f)object).normalize();
                        if ((double)((Tuple3f)object).z < 0.0) {
                            ((Tuple3f)object).z = -((Tuple3f)object).z;
                        }
                        vector3f3.add((Tuple3f)object);
                        ++n8;
                    }
                    if (bl2 && bl4) {
                        object3.x = 0.0f;
                        object3.y = -1.0f;
                        object3.z = f8;
                        ((Tuple3f)object2).x = 1.0f;
                        ((Tuple3f)object2).y = 0.0f;
                        ((Tuple3f)object2).z = f9;
                        ((Vector3f)object).cross((Vector3f)object3, (Vector3f)object2);
                        ((Vector3f)object).normalize();
                        if ((double)((Tuple3f)object).z < 0.0) {
                            ((Tuple3f)object).z = -((Tuple3f)object).z;
                        }
                        vector3f3.add((Tuple3f)object);
                        ++n8;
                    }
                    if (bl4 && bl3) {
                        object3.x = 1.0f;
                        object3.y = 0.0f;
                        object3.z = f9;
                        ((Tuple3f)object2).x = 0.0f;
                        ((Tuple3f)object2).y = 1.0f;
                        ((Tuple3f)object2).z = f5;
                        ((Vector3f)object).cross((Vector3f)object3, (Vector3f)object2);
                        ((Vector3f)object).normalize();
                        if ((double)((Tuple3f)object).z < 0.0) {
                            ((Tuple3f)object).z = -((Tuple3f)object).z;
                        }
                        vector3f3.add((Tuple3f)object);
                        ++n8;
                    }
                    vector3f3.x /= (float)n8;
                    vector3f3.y /= (float)n8;
                    vector3f3.z /= (float)n8;
                }
                if (bl) {
                    vector3f3.x = -vector3f3.x;
                    vector3f3.y = -vector3f3.y;
                }
                vector3f.x = n7;
                if (vector3f3.z >= 0.0f) {
                    if (this.colorSource == 0) {
                        this.setFromRGB(color4f2, nArray[n4]);
                    } else {
                        this.setFromRGB(color4f2, this.material.diffuseColor);
                    }
                    if (f3 != 0.0f && this.environmentMap != null) {
                        this.tmpv2.set(vector3f2);
                        this.tmpv2.sub(vector3f);
                        this.tmpv2.normalize();
                        this.tmpv.set(vector3f3);
                        this.tmpv.normalize();
                        this.tmpv.scale(2.0f * this.tmpv.dot(this.tmpv2));
                        this.tmpv.sub(this.v);
                        this.tmpv.normalize();
                        this.setFromRGB(color4f, this.getEnvironmentMap(this.tmpv, nArray, n, n2));
                        color4f2.x = f3 * color4f.x + f4 * color4f2.x;
                        color4f2.y = f3 * color4f.y + f4 * color4f2.y;
                        color4f2.z = f3 * color4f.z + f4 * color4f2.z;
                    }
                    Color4f color4f4 = this.phongShade(vector3f, vector3f2, vector3f3, color4f2, color4f3, this.material, (LightFilter$Light[])objectArray);
                    int n9 = nArray[n4] & 0xFF000000;
                    int n10 = (int)(color4f4.x * 255.0f) << 16 | (int)(color4f4.y * 255.0f) << 8 | (int)(color4f4.z * 255.0f);
                    nArray2[n4++] = n9 | n10;
                    continue;
                }
                nArray2[n4++] = 0;
            }
            float[] fArray2 = fArray[0];
            fArray[0] = fArray[1];
            fArray[1] = fArray[2];
            fArray[2] = fArray2;
        }
        return nArray2;
    }

    public Color4f phongShade(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Color4f color4f, Color4f color4f2, LightFilter$Material lightFilter$Material, LightFilter$Light[] lightFilter$LightArray) {
        this.shadedColor.set(color4f);
        this.shadedColor.scale(lightFilter$Material.ambientIntensity);
        for (int i = 0; i < lightFilter$LightArray.length; ++i) {
            LightFilter$Light lightFilter$Light = lightFilter$LightArray[i];
            this.n.set(vector3f3);
            this.l.set(lightFilter$Light.position);
            if (lightFilter$Light.type != 1) {
                this.l.sub(vector3f);
            }
            this.l.normalize();
            float f2 = this.n.dot(this.l);
            if (!((double)f2 >= 0.0)) continue;
            float f3 = 0.0f;
            this.v.set(vector3f2);
            this.v.sub(vector3f);
            this.v.normalize();
            if (lightFilter$Light.type == 3 && (f3 = lightFilter$Light.direction.dot(this.l)) < lightFilter$Light.cosConeAngle) continue;
            this.n.scale(2.0f * f2);
            this.n.sub(this.l);
            float f4 = this.n.dot(this.v);
            float f5 = (double)f4 < 0.0 ? 0.0f : f4 / (lightFilter$Material.highlight - lightFilter$Material.highlight * f4 + f4);
            if (lightFilter$Light.type == 3) {
                float f6 = f3 = lightFilter$Light.cosConeAngle / f3;
                f6 *= f6;
                f6 *= f6;
                f6 *= f6;
                f6 = (float)Math.pow(f3, lightFilter$Light.focus * 10.0f) * (1.0f - f6);
                f5 *= f6;
                f2 *= f6;
            }
            this.diffuse_color.set(color4f);
            this.diffuse_color.scale(lightFilter$Material.diffuseReflectivity);
            this.diffuse_color.x *= lightFilter$Light.realColor.x * f2;
            this.diffuse_color.y *= lightFilter$Light.realColor.y * f2;
            this.diffuse_color.z *= lightFilter$Light.realColor.z * f2;
            this.specular_color.set(color4f2);
            this.specular_color.scale(lightFilter$Material.specularReflectivity);
            this.specular_color.x *= lightFilter$Light.realColor.x * f5;
            this.specular_color.y *= lightFilter$Light.realColor.y * f5;
            this.specular_color.z *= lightFilter$Light.realColor.z * f5;
            this.diffuse_color.add(this.specular_color);
            this.diffuse_color.clamp(0.0f, 1.0f);
            this.shadedColor.add(this.diffuse_color);
        }
        this.shadedColor.clamp(0.0f, 1.0f);
        return this.shadedColor;
    }

    private int getEnvironmentMap(Vector3f vector3f, int[] nArray, int n, int n2) {
        if (this.environmentMap != null) {
            float f2;
            float f3 = (float)Math.acos(-vector3f.y);
            float f4 = f3 / (float)Math.PI;
            if (f4 == 0.0f || f4 == 1.0f) {
                f2 = 0.0f;
            } else {
                float f5 = vector3f.x / (float)Math.sin(f3);
                if (f5 > 1.0f) {
                    f5 = 1.0f;
                } else if (f5 < -1.0f) {
                    f5 = -1.0f;
                }
                f2 = (float)Math.acos(f5) / (float)Math.PI;
            }
            f2 = ImageMath.clamp(f2 * (float)this.envWidth, 0.0f, (float)(this.envWidth - 1));
            f4 = ImageMath.clamp(f4 * (float)this.envHeight, 0.0f, (float)(this.envHeight - 1));
            int n3 = (int)f2;
            int n4 = (int)f4;
            float f6 = f2 - (float)n3;
            float f7 = f4 - (float)n4;
            int n5 = this.envWidth * n4 + n3;
            int n6 = n3 == this.envWidth - 1 ? 0 : 1;
            int n7 = n4 == this.envHeight - 1 ? 0 : this.envWidth;
            return ImageMath.bilinearInterpolate(f6, f7, this.envPixels[n5], this.envPixels[n5 + n6], this.envPixels[n5 + n7], this.envPixels[n5 + n6 + n7]);
        }
        return 0;
    }

    public String toString() {
        return "Stylize/Light Effects...";
    }

    static int access$000(LightFilter lightFilter) {
        return lightFilter.bumpShape;
    }
}

