/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.TransformFilter;
import com.jhlabs.math.Noise;
import java.awt.image.BufferedImage;

public class MarbleFilter
extends TransformFilter {
    public float[] sinTable;
    public float[] cosTable;
    public float xScale = 4.0f;
    public float yScale = 4.0f;
    public float amount = 1.0f;
    public float turbulence = 1.0f;

    public MarbleFilter() {
        this.setEdgeAction(1);
    }

    public void setXScale(float f2) {
        this.xScale = f2;
    }

    public float getXScale() {
        return this.xScale;
    }

    public void setYScale(float f2) {
        this.yScale = f2;
    }

    public float getYScale() {
        return this.yScale;
    }

    public void setAmount(float f2) {
        this.amount = f2;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setTurbulence(float f2) {
        this.turbulence = f2;
    }

    public float getTurbulence() {
        return this.turbulence;
    }

    private void initialize() {
        this.sinTable = new float[256];
        this.cosTable = new float[256];
        for (int i = 0; i < 256; ++i) {
            float f2 = (float)Math.PI * 2 * (float)i / 256.0f * this.turbulence;
            this.sinTable[i] = (float)((double)(-this.yScale) * Math.sin(f2));
            this.cosTable[i] = (float)((double)this.yScale * Math.cos(f2));
        }
    }

    private int displacementMap(int n, int n2) {
        return PixelUtils.clamp((int)(127.0f * (1.0f + Noise.noise2((float)n / this.xScale, (float)n2 / this.xScale))));
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        int n3 = this.displacementMap(n, n2);
        fArray[0] = (float)n + this.sinTable[n3];
        fArray[1] = (float)n2 + this.cosTable[n3];
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.initialize();
        return super.filter(bufferedImage, bufferedImage2);
    }

    public String toString() {
        return "Distort/Marble...";
    }
}

