/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.PointFilter;
import com.jhlabs.math.Noise;
import java.io.Serializable;

public class MarbleTexFilter
extends PointFilter
implements Serializable {
    private float scale = 32.0f;
    private float stretch = 1.0f;
    private float angle = 0.0f;
    private float turbulence = 1.0f;
    private float turbulenceFactor = 0.5f;
    private Colormap colormap;
    private float m00 = 1.0f;
    private float m01 = 0.0f;
    private float m10 = 0.0f;
    private float m11 = 1.0f;

    public void setScale(float f2) {
        this.scale = f2;
    }

    public float getScale() {
        return this.scale;
    }

    public void setStretch(float f2) {
        this.stretch = f2;
    }

    public float getStretch() {
        return this.stretch;
    }

    public void setAngle(float f2) {
        this.angle = f2;
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        this.m00 = f3;
        this.m01 = f4;
        this.m10 = -f4;
        this.m11 = f3;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setTurbulence(float f2) {
        this.turbulence = f2;
    }

    public float getTurbulence() {
        return this.turbulence;
    }

    public void setTurbulenceFactor(float f2) {
        this.turbulenceFactor = f2;
    }

    public float getTurbulenceFactor() {
        return this.turbulenceFactor;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public int filterRGB(int n, int n2, int n3) {
        float f2;
        float f3 = this.m00 * (float)n + this.m01 * (float)n2;
        float f4 = this.m10 * (float)n + this.m11 * (float)n2;
        f3 /= this.scale * this.stretch;
        f4 /= this.scale;
        int n4 = n3 & 0xFF000000;
        if (this.colormap != null) {
            float f5 = this.turbulenceFactor * Noise.turbulence2(f3, f4, this.turbulence);
            float f6 = 3.0f * this.turbulenceFactor * f5 + f4;
            f6 = (float)Math.sin((double)f6 * Math.PI);
            float f7 = (float)Math.sin(40.0 * (double)f5);
            f6 = (float)((double)f6 + 0.2 * (double)f7);
            return this.colormap.getColor(f6);
        }
        float f8 = this.turbulenceFactor * Noise.turbulence2(f3, f4, this.turbulence);
        float f9 = (float)Math.sin(Math.sin(8.0 * (double)f8 + (double)(7.0f * f3) + 3.0 * (double)f4));
        float f10 = f2 = Math.abs(f9);
        float f11 = (float)Math.sin(40.0 * (double)f8);
        f11 = Math.abs(f11);
        float f12 = 0.6f * f11 + 0.3f;
        float f13 = 0.2f * f11 + 0.8f;
        float f14 = 0.15f * f11 + 0.85f;
        float f15 = 0.5f * (float)Math.pow(Math.abs(f2), 0.3);
        f2 = (float)Math.pow(0.5 * ((double)f2 + 1.0), 0.6) * f12;
        f10 = (float)Math.pow(0.5 * ((double)f10 + 1.0), 0.6) * f13;
        float f16 = (0.5f * f2 + 0.35f * f10) * 2.0f * f15;
        float f17 = (0.25f * f2 + 0.35f * f10) * 2.0f * f15;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        n5 = PixelUtils.clamp((int)((float)n5 * f16));
        n6 = PixelUtils.clamp((int)((float)n6 * (f15 *= Math.max(f2, f10) * f14)));
        n7 = PixelUtils.clamp((int)((float)n7 * f17));
        return n3 & 0xFF000000 | n5 << 16 | n6 << 8 | n7;
    }

    public String toString() {
        return "Texture/Marble Texture...";
    }
}

