/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class PinchFilter
extends TransformFilter {
    private float angle = 0.0f;
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private float radius = 100.0f;
    private float amount = 0.5f;
    private float radius2 = 0.0f;
    private float icentreX;
    private float icentreY;
    private float width;
    private float height;

    public void setAngle(float f2) {
        this.angle = f2;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setCentreX(float f2) {
        this.centreX = f2;
    }

    public float getCentreX() {
        return this.centreX;
    }

    public void setCentreY(float f2) {
        this.centreY = f2;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public void setCentre(Point2D point2D) {
        this.centreX = (float)point2D.getX();
        this.centreY = (float)point2D.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    public void setRadius(float f2) {
        this.radius = f2;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setAmount(float f2) {
        this.amount = f2;
    }

    public float getAmount() {
        return this.amount;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.icentreX = this.width * this.centreX;
        this.icentreY = this.height * this.centreY;
        if (this.radius == 0.0f) {
            this.radius = Math.min(this.icentreX, this.icentreY);
        }
        this.radius2 = this.radius * this.radius;
        return super.filter(bufferedImage, bufferedImage2);
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        float f2 = (float)n - this.icentreX;
        float f3 = (float)n2 - this.icentreY;
        float f4 = f2 * f2 + f3 * f3;
        if (f4 > this.radius2 || f4 == 0.0f) {
            fArray[0] = n;
            fArray[1] = n2;
        } else {
            float f5 = (float)Math.sqrt(f4 / this.radius2);
            float f6 = (float)Math.pow(Math.sin(1.5707963267948966 * (double)f5), -this.amount);
            float f7 = 1.0f - f5;
            float f8 = this.angle * f7 * f7;
            float f9 = (float)Math.sin(f8);
            float f10 = (float)Math.cos(f8);
            fArray[0] = this.icentreX + f10 * (f2 *= f6) - f9 * (f3 *= f6);
            fArray[1] = this.icentreY + f9 * f2 + f10 * f3;
        }
    }

    public String toString() {
        return "Distort/Pinch...";
    }
}

