/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.image.BufferedImage;

public class PolarFilter
extends TransformFilter {
    public static final int RECT_TO_POLAR = 0;
    public static final int POLAR_TO_RECT = 1;
    public static final int INVERT_IN_CIRCLE = 2;
    private int type;
    private float width;
    private float height;
    private float centreX;
    private float centreY;
    private float radius;

    public PolarFilter() {
        this(0);
    }

    public PolarFilter(int n) {
        this.type = n;
        this.setEdgeAction(1);
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.centreX = this.width / 2.0f;
        this.centreY = this.height / 2.0f;
        this.radius = Math.max(this.centreY, this.centreX);
        return super.filter(bufferedImage, bufferedImage2);
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    private float sqr(float f2) {
        return f2 * f2;
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        float f2 = 0.0f;
        switch (this.type) {
            case 0: {
                float f3 = 0.0f;
                if ((float)n >= this.centreX) {
                    if ((float)n2 > this.centreY) {
                        f3 = (float)Math.PI - (float)Math.atan(((float)n - this.centreX) / ((float)n2 - this.centreY));
                        f2 = (float)Math.sqrt(this.sqr((float)n - this.centreX) + this.sqr((float)n2 - this.centreY));
                    } else if ((float)n2 < this.centreY) {
                        f3 = (float)Math.atan(((float)n - this.centreX) / (this.centreY - (float)n2));
                        f2 = (float)Math.sqrt(this.sqr((float)n - this.centreX) + this.sqr(this.centreY - (float)n2));
                    } else {
                        f3 = 1.5707964f;
                        f2 = (float)n - this.centreX;
                    }
                } else if ((float)n < this.centreX) {
                    if ((float)n2 < this.centreY) {
                        f3 = (float)Math.PI * 2 - (float)Math.atan((this.centreX - (float)n) / (this.centreY - (float)n2));
                        f2 = (float)Math.sqrt(this.sqr(this.centreX - (float)n) + this.sqr(this.centreY - (float)n2));
                    } else if ((float)n2 > this.centreY) {
                        f3 = (float)Math.PI + (float)Math.atan((this.centreX - (float)n) / ((float)n2 - this.centreY));
                        f2 = (float)Math.sqrt(this.sqr(this.centreX - (float)n) + this.sqr((float)n2 - this.centreY));
                    } else {
                        f3 = 4.712389f;
                        f2 = this.centreX - (float)n;
                    }
                }
                float f4 = (float)n != this.centreX ? Math.abs(((float)n2 - this.centreY) / ((float)n - this.centreX)) : 0.0f;
                if (f4 <= this.height / this.width) {
                    if ((float)n == this.centreX) {
                        float f5 = 0.0f;
                        float f6 = this.centreY;
                    } else {
                        float f7 = this.centreX;
                        float f8 = f4 * f7;
                    }
                } else {
                    float f9 = this.centreY;
                    float f10 = f9 / f4;
                }
                fArray[0] = this.width - 1.0f - (this.width - 1.0f) / ((float)Math.PI * 2) * f3;
                fArray[1] = this.height * f2 / this.radius;
                break;
            }
            case 1: {
                float f11 = (float)n / this.width * ((float)Math.PI * 2);
                float f12 = f11 >= 4.712389f ? (float)Math.PI * 2 - f11 : (f11 >= (float)Math.PI ? f11 - (float)Math.PI : (f11 >= 1.5707964f ? (float)Math.PI - f11 : f11));
                float f13 = (float)Math.tan(f12);
                float f14 = f13 != 0.0f ? 1.0f / f13 : 0.0f;
                if (f14 <= this.height / this.width) {
                    if (f12 == 0.0f) {
                        float f15 = 0.0f;
                        float f16 = this.centreY;
                    } else {
                        float f17 = this.centreX;
                        float f18 = f14 * f17;
                    }
                } else {
                    float f19 = this.centreY;
                    float f20 = f19 / f14;
                }
                f2 = this.radius * ((float)n2 / this.height);
                float f21 = -f2 * (float)Math.sin(f12);
                float f22 = f2 * (float)Math.cos(f12);
                if (f11 >= 4.712389f) {
                    fArray[0] = this.centreX - f21;
                    fArray[1] = this.centreY - f22;
                    break;
                }
                if ((double)f11 >= Math.PI) {
                    fArray[0] = this.centreX - f21;
                    fArray[1] = this.centreY + f22;
                    break;
                }
                if ((double)f11 >= 1.5707963267948966) {
                    fArray[0] = this.centreX + f21;
                    fArray[1] = this.centreY + f22;
                    break;
                }
                fArray[0] = this.centreX + f21;
                fArray[1] = this.centreY - f22;
                break;
            }
            case 2: {
                float f23 = (float)n - this.centreX;
                float f24 = (float)n2 - this.centreY;
                float f25 = f23 * f23 + f24 * f24;
                fArray[0] = this.centreX + this.centreX * this.centreX * f23 / f25;
                fArray[1] = this.centreY + this.centreY * this.centreY * f24 / f25;
            }
        }
    }

    public String toString() {
        return "Distort/Polar Coordinates...";
    }
}

