/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.TransformFilter;
import com.jhlabs.math.Noise;
import java.awt.Rectangle;

public class RippleFilter
extends TransformFilter {
    static final long serialVersionUID = 5101667633854087384L;
    public static final int SINE = 0;
    public static final int SAWTOOTH = 1;
    public static final int TRIANGLE = 2;
    public static final int NOISE = 3;
    public float xAmplitude = 5.0f;
    public float yAmplitude = 0.0f;
    public float xWavelength = 16.0f;
    public float yWavelength = 16.0f;
    private int waveType;

    public void setXAmplitude(float f2) {
        this.xAmplitude = f2;
    }

    public float getXAmplitude() {
        return this.xAmplitude;
    }

    public void setXWavelength(float f2) {
        this.xWavelength = f2;
    }

    public float getXWavelength() {
        return this.xWavelength;
    }

    public void setYAmplitude(float f2) {
        this.yAmplitude = f2;
    }

    public float getYAmplitude() {
        return this.yAmplitude;
    }

    public void setYWavelength(float f2) {
        this.yWavelength = f2;
    }

    public float getYWavelength() {
        return this.yWavelength;
    }

    public void setWaveType(int n) {
        this.waveType = n;
    }

    public int getWaveType() {
        return this.waveType;
    }

    protected void transformSpace(Rectangle rectangle) {
        if (this.edgeAction == 0) {
            rectangle.x -= (int)this.xAmplitude;
            rectangle.width += (int)(2.0f * this.xAmplitude);
            rectangle.y -= (int)this.yAmplitude;
            rectangle.height += (int)(2.0f * this.yAmplitude);
        }
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        float f2;
        float f3;
        float f4 = (float)n2 / this.xWavelength;
        float f5 = (float)n / this.yWavelength;
        switch (this.waveType) {
            default: {
                f3 = (float)Math.sin(f4);
                f2 = (float)Math.sin(f5);
                break;
            }
            case 1: {
                f3 = ImageMath.mod(f4, 1.0f);
                f2 = ImageMath.mod(f5, 1.0f);
                break;
            }
            case 2: {
                f3 = ImageMath.triangle(f4);
                f2 = ImageMath.triangle(f5);
                break;
            }
            case 3: {
                f3 = Noise.noise1(f4);
                f2 = Noise.noise1(f5);
            }
        }
        fArray[0] = (float)n + this.xAmplitude * f3;
        fArray[1] = (float)n2 + this.yAmplitude * f2;
    }

    public String toString() {
        return "Distort/Ripple...";
    }
}

