/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.GaussianFilter;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class ShadowFilter
extends AbstractBufferedImageOp {
    static final long serialVersionUID = 6310370419462785691L;
    private float radius = 5.0f;
    private float angle = 4.712389f;
    private float distance = 5.0f;
    private float opacity = 0.5f;
    private boolean addMargins = false;
    private boolean shadowOnly = false;
    private int shadowColor = -16777216;

    public ShadowFilter() {
    }

    public ShadowFilter(float f2, float f3, float f4, float f5) {
        this.radius = f2;
        this.angle = (float)Math.atan2(f4, f3);
        this.distance = (float)Math.sqrt(f3 * f3 + f4 * f4);
        this.opacity = f5;
    }

    public void setAngle(float f2) {
        this.angle = f2;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setDistance(float f2) {
        this.distance = f2;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setRadius(float f2) {
        this.radius = f2;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setOpacity(float f2) {
        this.opacity = f2;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setShadowColor(int n) {
        this.shadowColor = n;
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    public void setAddMargins(boolean bl) {
        this.addMargins = bl;
    }

    public boolean getAddMargins() {
        return this.addMargins;
    }

    public void setShadowOnly(boolean bl) {
        this.shadowOnly = bl;
    }

    public boolean getShadowOnly() {
        return this.shadowOnly;
    }

    protected void transformSpace(Rectangle rectangle) {
        if (this.addMargins) {
            float f2 = this.distance * (float)Math.cos(this.angle);
            float f3 = -this.distance * (float)Math.sin(this.angle);
            rectangle.width += (int)(Math.abs(f2) + 2.0f * this.radius);
            rectangle.height += (int)(Math.abs(f3) + 2.0f * this.radius);
        }
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            if (this.addMargins) {
                ColorModel colorModel = bufferedImage.getColorModel();
                bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
            } else {
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
        }
        float f2 = (float)(this.shadowColor >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(this.shadowColor >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(this.shadowColor & 0xFF) / 255.0f;
        float[][] fArrayArray = new float[][]{{0.0f, 0.0f, 0.0f, f2}, {0.0f, 0.0f, 0.0f, f3}, {0.0f, 0.0f, 0.0f, f4}, {0.0f, 0.0f, 0.0f, this.opacity}};
        BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
        new BandCombineOp(fArrayArray, null).filter(bufferedImage.getRaster(), bufferedImage3.getRaster());
        bufferedImage3 = new GaussianFilter(this.radius).filter(bufferedImage3, null);
        float f5 = this.distance * (float)Math.cos(this.angle);
        float f6 = -this.distance * (float)Math.sin(this.angle);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
        if (this.addMargins) {
            float f7 = this.radius / 2.0f;
            float f8 = Math.max(0.0f, this.radius - f6);
            float f9 = Math.max(0.0f, this.radius - f5);
            graphics2D.translate(f8, f9);
        }
        graphics2D.drawRenderedImage(bufferedImage3, AffineTransform.getTranslateInstance(f5, f6));
        if (!this.shadowOnly) {
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.drawRenderedImage(bufferedImage, null);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    public String toString() {
        return "Stylize/Drop Shadow...";
    }
}

