/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.ShatterFilter$Tile;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public class ShatterFilter
extends AbstractBufferedImageOp {
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private float distance;
    private float transition;
    private float rotation;
    private float zoom;
    private float startAlpha = 1.0f;
    private float endAlpha = 1.0f;
    private int iterations = 5;
    private int tile;

    public void setTransition(float f2) {
        this.transition = f2;
    }

    public float getTransition() {
        return this.transition;
    }

    public void setDistance(float f2) {
        this.distance = f2;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setRotation(float f2) {
        this.rotation = f2;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setZoom(float f2) {
        this.zoom = f2;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setStartAlpha(float f2) {
        this.startAlpha = f2;
    }

    public float getStartAlpha() {
        return this.startAlpha;
    }

    public void setEndAlpha(float f2) {
        this.endAlpha = f2;
    }

    public float getEndAlpha() {
        return this.endAlpha;
    }

    public void setCentreX(float f2) {
        this.centreX = f2;
    }

    public float getCentreX() {
        return this.centreX;
    }

    public void setCentreY(float f2) {
        this.centreY = f2;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public void setCentre(Point2D point2D) {
        this.centreX = (float)point2D.getX();
        this.centreY = (float)point2D.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    public void setIterations(int n) {
        this.iterations = n;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setTile(int n) {
        this.tile = n;
    }

    public int getTile() {
        return this.tile;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Rectangle rectangle;
        int n;
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        float f2 = bufferedImage.getWidth();
        float f3 = bufferedImage.getHeight();
        float f4 = (float)bufferedImage.getWidth() * this.centreX;
        float f5 = (float)bufferedImage.getHeight() * this.centreY;
        float f6 = (float)Math.sqrt(f4 * f4 + f5 * f5);
        int n2 = this.iterations * this.iterations;
        ShatterFilter$Tile[] shatterFilter$TileArray = new ShatterFilter$Tile[n2];
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n2];
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        Random random = new Random(0L);
        float f7 = 0.0f;
        float f8 = 0.0f;
        for (n = 0; n < this.iterations; ++n) {
            int n3 = (int)f3 * n / this.iterations;
            int n4 = (int)f3 * (n + 1) / this.iterations;
            for (int i = 0; i < this.iterations; ++i) {
                int n5 = n * this.iterations + i;
                int n6 = (int)f2 * i / this.iterations;
                int n7 = (int)f2 * (i + 1) / this.iterations;
                fArray[n5] = (float)this.tile * random.nextFloat();
                fArray2[n5] = (float)this.tile * random.nextFloat();
                fArray[n5] = 0.0f;
                fArray2[n5] = 0.0f;
                fArray3[n5] = (float)this.tile * (2.0f * random.nextFloat() - 1.0f);
                rectangle = new Rectangle(n6, n3, n7 - n6, n4 - n3);
                shatterFilter$TileArray[n5] = new ShatterFilter$Tile();
                shatterFilter$TileArray[n5].shape = rectangle;
                shatterFilter$TileArray[n5].x = (float)(n6 + n7) * 0.5f;
                shatterFilter$TileArray[n5].y = (float)(n3 + n4) * 0.5f;
                shatterFilter$TileArray[n5].vx = f2 - (f4 - (float)i);
                shatterFilter$TileArray[n5].vy = f3 - (f5 - (float)n);
                shatterFilter$TileArray[n5].w = n7 - n6;
                shatterFilter$TileArray[n5].h = n4 - n3;
            }
        }
        for (n = 0; n < n2; ++n) {
            float f9 = (float)n / (float)n2;
            double d2 = (double)(f9 * 2.0f) * Math.PI;
            float f10 = this.transition * f2 * (float)Math.cos(d2);
            float f11 = this.transition * f3 * (float)Math.sin(d2);
            ShatterFilter$Tile shatterFilter$Tile = shatterFilter$TileArray[n];
            rectangle = shatterFilter$Tile.shape.getBounds();
            AffineTransform affineTransform = graphics2D.getTransform();
            f10 = shatterFilter$Tile.x + this.transition * shatterFilter$Tile.vx;
            f11 = shatterFilter$Tile.y + this.transition * shatterFilter$Tile.vy;
            graphics2D.translate(f10, f11);
            graphics2D.rotate(this.transition * fArray3[n]);
            graphics2D.setColor(Color.getHSBColor(f9, 1.0f, 1.0f));
            Shape shape = graphics2D.getClip();
            graphics2D.clip(shatterFilter$Tile.shape);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.setClip(shape);
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    public String toString() {
        return "Transition/Shatter...";
    }
}

