/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.PointFilter;
import com.jhlabs.math.FBM;
import com.jhlabs.math.Function2D;
import com.jhlabs.math.Noise;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Random;

public class SkyFilter
extends PointFilter {
    private float scale = 0.1f;
    private float stretch = 1.0f;
    private float angle = 0.0f;
    private float amount = 1.0f;
    private float H = 1.0f;
    private float octaves = 8.0f;
    private float lacunarity = 2.0f;
    private float gain = 1.0f;
    private float bias = 0.6f;
    private int operation;
    private float min;
    private float max;
    private boolean ridged;
    private FBM fBm;
    protected Random random = new Random();
    private Function2D basis;
    private float cloudCover = 0.5f;
    private float cloudSharpness = 0.5f;
    private float time = 0.3f;
    private float glow = 0.5f;
    private float glowFalloff = 0.5f;
    private float haziness = 0.96f;
    private float t = 0.0f;
    private float sunRadius = 10.0f;
    private int sunColor = -1;
    private float sunR;
    private float sunG;
    private float sunB;
    private float sunAzimuth = 0.5f;
    private float sunElevation = 0.5f;
    private float windSpeed = 0.0f;
    private float cameraAzimuth = 0.0f;
    private float cameraElevation = 0.0f;
    private float fov = 1.0f;
    private float[] exponents;
    private float[] tan;
    private BufferedImage skyColors;
    private int[] skyPixels;
    private static final float r255 = 0.003921569f;
    private float width;
    private float height;
    float mn;
    float mx;

    public SkyFilter() {
        if (this.skyColors == null) {
            this.skyColors = ImageUtils.createImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("SkyColors.png")).getSource());
        }
    }

    public void setAmount(float f2) {
        this.amount = f2;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setScale(float f2) {
        this.scale = f2;
    }

    public float getScale() {
        return this.scale;
    }

    public void setStretch(float f2) {
        this.stretch = f2;
    }

    public float getStretch() {
        return this.stretch;
    }

    public void setT(float f2) {
        this.t = f2;
    }

    public float getT() {
        return this.t;
    }

    public void setFOV(float f2) {
        this.fov = f2;
    }

    public float getFOV() {
        return this.fov;
    }

    public void setCloudCover(float f2) {
        this.cloudCover = f2;
    }

    public float getCloudCover() {
        return this.cloudCover;
    }

    public void setCloudSharpness(float f2) {
        this.cloudSharpness = f2;
    }

    public float getCloudSharpness() {
        return this.cloudSharpness;
    }

    public void setTime(float f2) {
        this.time = f2;
    }

    public float getTime() {
        return this.time;
    }

    public void setGlow(float f2) {
        this.glow = f2;
    }

    public float getGlow() {
        return this.glow;
    }

    public void setGlowFalloff(float f2) {
        this.glowFalloff = f2;
    }

    public float getGlowFalloff() {
        return this.glowFalloff;
    }

    public void setAngle(float f2) {
        this.angle = f2;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setOctaves(float f2) {
        this.octaves = f2;
    }

    public float getOctaves() {
        return this.octaves;
    }

    public void setH(float f2) {
        this.H = f2;
    }

    public float getH() {
        return this.H;
    }

    public void setLacunarity(float f2) {
        this.lacunarity = f2;
    }

    public float getLacunarity() {
        return this.lacunarity;
    }

    public void setGain(float f2) {
        this.gain = f2;
    }

    public float getGain() {
        return this.gain;
    }

    public void setBias(float f2) {
        this.bias = f2;
    }

    public float getBias() {
        return this.bias;
    }

    public void setHaziness(float f2) {
        this.haziness = f2;
    }

    public float getHaziness() {
        return this.haziness;
    }

    public void setSunElevation(float f2) {
        this.sunElevation = f2;
    }

    public float getSunElevation() {
        return this.sunElevation;
    }

    public void setSunAzimuth(float f2) {
        this.sunAzimuth = f2;
    }

    public float getSunAzimuth() {
        return this.sunAzimuth;
    }

    public void setSunColor(int n) {
        this.sunColor = n;
    }

    public int getSunColor() {
        return this.sunColor;
    }

    public void setCameraElevation(float f2) {
        this.cameraElevation = f2;
    }

    public float getCameraElevation() {
        return this.cameraElevation;
    }

    public void setCameraAzimuth(float f2) {
        this.cameraAzimuth = f2;
    }

    public float getCameraAzimuth() {
        return this.cameraAzimuth;
    }

    public void setWindSpeed(float f2) {
        this.windSpeed = f2;
    }

    public float getWindSpeed() {
        return this.windSpeed;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        this.sunR = (float)(this.sunColor >> 16 & 0xFF) * 0.003921569f;
        this.sunG = (float)(this.sunColor >> 8 & 0xFF) * 0.003921569f;
        this.sunB = (float)(this.sunColor & 0xFF) * 0.003921569f;
        this.mn = 10000.0f;
        this.mx = -10000.0f;
        this.exponents = new float[(int)this.octaves + 1];
        float f2 = 1.0f;
        for (n2 = 0; n2 <= (int)this.octaves; ++n2) {
            this.exponents[n2] = (float)Math.pow(2.0, -n2);
            f2 *= this.lacunarity;
        }
        this.min = -1.0f;
        this.max = 1.0f;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        n2 = bufferedImage.getHeight();
        this.tan = new float[n2];
        for (n = 0; n < n2; ++n) {
            this.tan[n] = (float)Math.tan((double)(this.fov * (float)n / (float)n2) * Math.PI * 0.5);
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        n = (int)(63.0f * this.time);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(this.skyColors, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), n, 0, n + 1, 64, null);
        graphics2D.dispose();
        BufferedImage bufferedImage3 = super.filter(bufferedImage2, bufferedImage2);
        long l2 = System.currentTimeMillis();
        System.out.println(this.mn + " " + this.mx + " " + (float)(l2 - l) * 0.001f);
        this.exponents = null;
        this.tan = null;
        return bufferedImage2;
    }

    public float evaluate(float f2, float f3) {
        int n;
        float f4 = 0.0f;
        f2 += 371.0f;
        f3 += 529.0f;
        for (n = 0; n < (int)this.octaves; ++n) {
            f4 += Noise.noise3(f2, f3, this.t) * this.exponents[n];
            f2 *= this.lacunarity;
            f3 *= this.lacunarity;
        }
        float f5 = this.octaves - (float)((int)this.octaves);
        if (f5 != 0.0f) {
            f4 += f5 * Noise.noise3(f2, f3, this.t) * this.exponents[n];
        }
        return f4;
    }

    public int filterRGB(int n, int n2, int n3) {
        float f2;
        float f3 = (float)n / this.width;
        float f4 = (float)n2 / this.height;
        float f5 = (float)Math.pow(this.haziness, 100.0f * f4 * f4);
        float f6 = (float)(n3 >> 16 & 0xFF) * 0.003921569f;
        float f7 = (float)(n3 >> 8 & 0xFF) * 0.003921569f;
        float f8 = (float)(n3 & 0xFF) * 0.003921569f;
        float f9 = this.width * 0.5f;
        float f10 = (float)n - f9;
        float f11 = n2;
        f11 = this.tan[n2];
        f10 = (f3 - 0.5f) * (1.0f + f11);
        f11 += this.t * this.windSpeed;
        float f12 = f2 = this.evaluate(f10 /= this.scale, f11 /= this.scale * this.stretch);
        f2 = (f2 + 1.23f) / 2.46f;
        int n4 = n3 & 0xFF000000;
        float f13 = f2 - this.cloudCover;
        if (f13 < 0.0f) {
            f13 = 0.0f;
        }
        float f14 = 1.0f - (float)Math.pow(this.cloudSharpness, f13);
        this.mn = Math.min(this.mn, f14);
        this.mx = Math.max(this.mx, f14);
        float f15 = this.width * this.sunAzimuth;
        float f16 = this.height * this.sunElevation;
        float f17 = (float)n - f15;
        float f18 = (float)n2 - f16;
        float f19 = f17 * f17 + f18 * f18;
        f19 = (float)Math.pow(f19, this.glowFalloff);
        float f20 = 10.0f * (float)Math.exp(-f19 * this.glow * 0.1f);
        f6 += f20 * this.sunR;
        f7 += f20 * this.sunG;
        f8 += f20 * this.sunB;
        float f21 = (1.0f - f14 * f14 * f14 * f14) * this.amount;
        float f22 = this.sunR * f21;
        float f23 = this.sunG * f21;
        float f24 = this.sunB * f21;
        float f25 = 1.0f - (f14 *= f5);
        f6 = f25 * f6 + f14 * f22;
        f7 = f25 * f7 + f14 * f23;
        f8 = f25 * f8 + f14 * f24;
        float f26 = this.gain;
        f6 = 1.0f - (float)Math.exp(-f6 * f26);
        f7 = 1.0f - (float)Math.exp(-f7 * f26);
        f8 = 1.0f - (float)Math.exp(-f8 * f26);
        int n5 = (int)(255.0f * f6) << 16;
        int n6 = (int)(255.0f * f7) << 8;
        int n7 = (int)(255.0f * f8);
        int n8 = 0xFF000000 | n5 | n6 | n7;
        return n8;
    }

    public String toString() {
        return "Texture/Sky...";
    }
}

