/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class SphereFilter
extends TransformFilter {
    static final long serialVersionUID = -8148404526162968279L;
    private float a = 0.0f;
    private float b = 0.0f;
    private float a2 = 0.0f;
    private float b2 = 0.0f;
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private float refractionIndex = 1.5f;
    private float icentreX;
    private float icentreY;

    public SphereFilter() {
        this.setEdgeAction(1);
        this.setRadius(100.0f);
    }

    public void setRefractionIndex(float f2) {
        this.refractionIndex = f2;
    }

    public float getRefractionIndex() {
        return this.refractionIndex;
    }

    public void setRadius(float f2) {
        this.a = f2;
        this.b = f2;
    }

    public float getRadius() {
        return this.a;
    }

    public void setCentreX(float f2) {
        this.centreX = f2;
    }

    public float getCentreX() {
        return this.centreX;
    }

    public void setCentreY(float f2) {
        this.centreY = f2;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public void setCentre(Point2D point2D) {
        this.centreX = (float)point2D.getX();
        this.centreY = (float)point2D.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        this.icentreX = (float)n * this.centreX;
        this.icentreY = (float)n2 * this.centreY;
        if (this.a == 0.0f) {
            this.a = n / 2;
        }
        if (this.b == 0.0f) {
            this.b = n2 / 2;
        }
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
        return super.filter(bufferedImage, bufferedImage2);
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        float f2 = (float)n2 - this.icentreY;
        float f3 = f2 * f2;
        float f4 = (float)n - this.icentreX;
        float f5 = f4 * f4;
        if (f3 >= this.b2 - this.b2 * f5 / this.a2) {
            fArray[0] = n;
            fArray[1] = n2;
        } else {
            float f6 = 1.0f / this.refractionIndex;
            float f7 = (float)Math.sqrt((1.0f - f5 / this.a2 - f3 / this.b2) * (this.a * this.b));
            float f8 = f7 * f7;
            float f9 = (float)Math.acos((double)f4 / Math.sqrt(f5 + f8));
            float f10 = 1.5707964f - f9;
            float f11 = (float)Math.asin(Math.sin(f10) * (double)f6);
            f11 = 1.5707964f - f9 - f11;
            fArray[0] = (float)n - (float)Math.tan(f11) * f7;
            float f12 = (float)Math.acos((double)f2 / Math.sqrt(f3 + f8));
            f10 = 1.5707964f - f12;
            f11 = (float)Math.asin(Math.sin(f10) * (double)f6);
            f11 = 1.5707964f - f12 - f11;
            fArray[1] = (float)n2 - (float)Math.tan(f11) * f7;
        }
    }

    public String toString() {
        return "Distort/Sphere...";
    }
}

