/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import com.jhlabs.math.Noise;

public class SwimFilter
extends TransformFilter {
    private float scale = 32.0f;
    private float stretch = 1.0f;
    private float angle = 0.0f;
    private float amount = 1.0f;
    private float turbulence = 1.0f;
    private float time = 0.0f;
    private float m00 = 1.0f;
    private float m01 = 0.0f;
    private float m10 = 0.0f;
    private float m11 = 1.0f;

    public void setAmount(float f2) {
        this.amount = f2;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setScale(float f2) {
        this.scale = f2;
    }

    public float getScale() {
        return this.scale;
    }

    public void setStretch(float f2) {
        this.stretch = f2;
    }

    public float getStretch() {
        return this.stretch;
    }

    public void setAngle(float f2) {
        this.angle = f2;
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        this.m00 = f3;
        this.m01 = f4;
        this.m10 = -f4;
        this.m11 = f3;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setTurbulence(float f2) {
        this.turbulence = f2;
    }

    public float getTurbulence() {
        return this.turbulence;
    }

    public void setTime(float f2) {
        this.time = f2;
    }

    public float getTime() {
        return this.time;
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        float f2 = this.m00 * (float)n + this.m01 * (float)n2;
        float f3 = this.m10 * (float)n + this.m11 * (float)n2;
        f2 /= this.scale;
        f3 /= this.scale * this.stretch;
        if (this.turbulence == 1.0f) {
            fArray[0] = (float)n + this.amount * Noise.noise3(f2 + 0.5f, f3, this.time);
            fArray[1] = (float)n2 + this.amount * Noise.noise3(f2, f3 + 0.5f, this.time);
        } else {
            fArray[0] = (float)n + this.amount * Noise.turbulence3(f2 + 0.5f, f3, this.turbulence, this.time);
            fArray[1] = (float)n2 + this.amount * Noise.turbulence3(f2, f3 + 0.5f, this.turbulence, this.time);
        }
    }

    public String toString() {
        return "Distort/Swim...";
    }
}

