/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.Serializable;

public class TileImageFilter
extends AbstractBufferedImageOp
implements Serializable {
    static final long serialVersionUID = 4926390225069192478L;
    public static final int FLIP_NONE = 0;
    public static final int FLIP_H = 1;
    public static final int FLIP_V = 2;
    public static final int FLIP_HV = 3;
    public static final int FLIP_180 = 4;
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private int[][] symmetryMatrix = null;
    private int symmetryRows = 2;
    private int symmetryCols = 2;

    public TileImageFilter() {
        this(32, 32);
    }

    public TileImageFilter(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            object = bufferedImage.getColorModel();
            bufferedImage2 = new BufferedImage((ColorModel)object, ((ColorModel)object).createCompatibleWritableRaster(this.width, this.height), ((ColorModel)object).isAlphaPremultiplied(), null);
        }
        object = bufferedImage2.createGraphics();
        for (int i = 0; i < this.height; i += n2) {
            for (int j = 0; j < this.width; j += n) {
                ((Graphics2D)object).drawImage(bufferedImage, null, j, i);
            }
        }
        ((Graphics)object).dispose();
        return bufferedImage2;
    }

    public void setSymmetryMatrix(int[][] nArray) {
        this.symmetryMatrix = nArray;
        this.symmetryRows = nArray.length;
        this.symmetryCols = nArray[0].length;
    }

    public int[][] getSymmetryMatrix() {
        return this.symmetryMatrix;
    }

    public String toString() {
        return "Tile";
    }
}

