/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class TwirlFilter
extends TransformFilter {
    static final long serialVersionUID = 1550445062822803342L;
    private float angle = 0.0f;
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private float radius = 100.0f;
    private float radius2 = 0.0f;
    private float icentreX;
    private float icentreY;

    public TwirlFilter() {
        this.setEdgeAction(1);
    }

    public void setAngle(float f2) {
        this.angle = f2;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setCentreX(float f2) {
        this.centreX = f2;
    }

    public float getCentreX() {
        return this.centreX;
    }

    public void setCentreY(float f2) {
        this.centreY = f2;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public void setCentre(Point2D point2D) {
        this.centreX = (float)point2D.getX();
        this.centreY = (float)point2D.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    public void setRadius(float f2) {
        this.radius = f2;
    }

    public float getRadius() {
        return this.radius;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.icentreX = (float)bufferedImage.getWidth() * this.centreX;
        this.icentreY = (float)bufferedImage.getHeight() * this.centreY;
        if (this.radius == 0.0f) {
            this.radius = Math.min(this.icentreX, this.icentreY);
        }
        this.radius2 = this.radius * this.radius;
        return super.filter(bufferedImage, bufferedImage2);
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        float f2 = (float)n - this.icentreX;
        float f3 = (float)n2 - this.icentreY;
        float f4 = f2 * f2 + f3 * f3;
        if (f4 > this.radius2) {
            fArray[0] = n;
            fArray[1] = n2;
        } else {
            f4 = (float)Math.sqrt(f4);
            float f5 = (float)Math.atan2(f3, f2) + this.angle * (this.radius - f4) / this.radius;
            fArray[0] = this.icentreX + f4 * (float)Math.cos(f5);
            fArray[1] = this.icentreY + f4 * (float)Math.sin(f5);
        }
    }

    public String toString() {
        return "Distort/Twirl...";
    }
}

