/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class WaterFilter
extends TransformFilter {
    static final long serialVersionUID = 8789236343162990941L;
    private float wavelength = 16.0f;
    private float amplitude = 10.0f;
    private float phase = 0.0f;
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private float radius = 50.0f;
    private float radius2 = 0.0f;
    private float icentreX;
    private float icentreY;

    public WaterFilter() {
        this.setEdgeAction(1);
    }

    public void setWavelength(float f2) {
        this.wavelength = f2;
    }

    public float getWavelength() {
        return this.wavelength;
    }

    public void setAmplitude(float f2) {
        this.amplitude = f2;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public void setPhase(float f2) {
        this.phase = f2;
    }

    public float getPhase() {
        return this.phase;
    }

    public void setCentreX(float f2) {
        this.centreX = f2;
    }

    public float getCentreX() {
        return this.centreX;
    }

    public void setCentreY(float f2) {
        this.centreY = f2;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public void setCentre(Point2D point2D) {
        this.centreX = (float)point2D.getX();
        this.centreY = (float)point2D.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    public void setRadius(float f2) {
        this.radius = f2;
    }

    public float getRadius() {
        return this.radius;
    }

    private boolean inside(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.icentreX = (float)bufferedImage.getWidth() * this.centreX;
        this.icentreY = (float)bufferedImage.getHeight() * this.centreY;
        if (this.radius == 0.0f) {
            this.radius = Math.min(this.icentreX, this.icentreY);
        }
        this.radius2 = this.radius * this.radius;
        return super.filter(bufferedImage, bufferedImage2);
    }

    protected void transformInverse(int n, int n2, float[] fArray) {
        float f2 = (float)n - this.icentreX;
        float f3 = (float)n2 - this.icentreY;
        float f4 = f2 * f2 + f3 * f3;
        if (f4 > this.radius2) {
            fArray[0] = n;
            fArray[1] = n2;
        } else {
            float f5 = (float)Math.sqrt(f4);
            float f6 = this.amplitude * (float)Math.sin(f5 / this.wavelength * ((float)Math.PI * 2) - this.phase);
            f6 *= (this.radius - f5) / this.radius;
            if (f5 != 0.0f) {
                f6 *= this.wavelength / f5;
            }
            fArray[0] = (float)n + f2 * f6;
            fArray[1] = (float)n2 + f3 * f6;
        }
    }

    public String toString() {
        return "Distort/Water Ripples...";
    }
}

