/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.LinearColormap;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.PointFilter;
import com.jhlabs.math.Function2D;
import com.jhlabs.math.Noise;

public class WoodFilter
extends PointFilter {
    private float scale = 200.0f;
    private float stretch = 10.0f;
    private float angle = 1.5707964f;
    public float rings = 0.5f;
    public float turbulence = 0.0f;
    public float fibres = 0.5f;
    public float gain = 0.8f;
    private float m00 = 1.0f;
    private float m01 = 0.0f;
    private float m10 = 0.0f;
    private float m11 = 1.0f;
    private Colormap colormap = new LinearColormap(-1719148, -6784175);
    private Function2D function = new Noise();

    public void setRings(float f2) {
        this.rings = f2;
    }

    public float getRings() {
        return this.rings;
    }

    public void setFunction(Function2D function2D) {
        this.function = function2D;
    }

    public Function2D getFunction() {
        return this.function;
    }

    public void setScale(float f2) {
        this.scale = f2;
    }

    public float getScale() {
        return this.scale;
    }

    public void setStretch(float f2) {
        this.stretch = f2;
    }

    public float getStretch() {
        return this.stretch;
    }

    public void setAngle(float f2) {
        this.angle = f2;
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        this.m00 = f3;
        this.m01 = f4;
        this.m10 = -f4;
        this.m11 = f3;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setTurbulence(float f2) {
        this.turbulence = f2;
    }

    public float getTurbulence() {
        return this.turbulence;
    }

    public void setFibres(float f2) {
        this.fibres = f2;
    }

    public float getFibres() {
        return this.fibres;
    }

    public void setgain(float f2) {
        this.gain = f2;
    }

    public float getGain() {
        return this.gain;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4;
        float f2 = this.m00 * (float)n + this.m01 * (float)n2;
        float f3 = this.m10 * (float)n + this.m11 * (float)n2;
        float f4 = Noise.noise2(f2 /= this.scale, f3 /= this.scale * this.stretch);
        f4 += 0.1f * this.turbulence * Noise.noise2(f2 * 0.05f, f3 * 20.0f);
        f4 = f4 * 0.5f + 0.5f;
        f4 *= this.rings * 50.0f;
        f4 -= (float)((int)f4);
        f4 *= 1.0f - ImageMath.smoothStep(this.gain, 1.0f, f4);
        f4 += this.fibres * Noise.noise2(f2 * this.scale, f3 * 50.0f);
        int n5 = n3 & 0xFF000000;
        if (this.colormap != null) {
            n4 = this.colormap.getColor(f4);
        } else {
            n4 = PixelUtils.clamp((int)(f4 * 255.0f));
            int n6 = n4 << 16;
            int n7 = n4 << 8;
            int n8 = n4;
            n4 = n5 | n6 | n7 | n8;
        }
        return n4;
    }

    public String toString() {
        return "Texture/Wood...";
    }
}

