/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.math;

import com.jhlabs.math.CellularFunction2D$Point;
import com.jhlabs.math.Function2D;
import java.util.Random;

public class CellularFunction2D
implements Function2D {
    public float distancePower = 2.0f;
    public boolean cells = false;
    public boolean angular = false;
    private float[] coefficients = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    private Random random = new Random();
    private CellularFunction2D$Point[] results = new CellularFunction2D$Point[2];

    public CellularFunction2D() {
        for (int i = 0; i < this.results.length; ++i) {
            this.results[i] = new CellularFunction2D$Point(this);
        }
    }

    public void setCoefficient(int n, float f2) {
        this.coefficients[n] = f2;
    }

    public float getCoefficient(int n) {
        return this.coefficients[n];
    }

    private float checkCube(float f2, float f3, int n, int n2, CellularFunction2D$Point[] cellularFunction2D$PointArray) {
        this.random.setSeed(571 * n + 23 * n2);
        int n3 = 3 + this.random.nextInt() % 4;
        n3 = 4;
        block0: for (int i = 0; i < n3; ++i) {
            float f4 = this.random.nextFloat();
            float f5 = this.random.nextFloat();
            float f6 = Math.abs(f2 - f4);
            float f7 = Math.abs(f3 - f5);
            float f8 = this.distancePower == 1.0f ? f6 + f7 : (this.distancePower == 2.0f ? (float)Math.sqrt(f6 * f6 + f7 * f7) : (float)Math.pow(Math.pow(f6, this.distancePower) + Math.pow(f7, this.distancePower), 1.0f / this.distancePower));
            for (int j = 0; j < cellularFunction2D$PointArray.length; ++j) {
                CellularFunction2D$Point cellularFunction2D$Point;
                if ((double)cellularFunction2D$PointArray[j].distance == Double.POSITIVE_INFINITY) {
                    cellularFunction2D$Point = cellularFunction2D$PointArray[j];
                    cellularFunction2D$Point.distance = f8;
                    cellularFunction2D$Point.x = f4;
                    cellularFunction2D$Point.y = f5;
                    cellularFunction2D$PointArray[j] = cellularFunction2D$Point;
                    continue block0;
                }
                if (!(f8 < cellularFunction2D$PointArray[j].distance)) continue;
                cellularFunction2D$Point = cellularFunction2D$PointArray[cellularFunction2D$PointArray.length - 1];
                for (int k = cellularFunction2D$PointArray.length - 1; k > j; --k) {
                    cellularFunction2D$PointArray[k] = cellularFunction2D$PointArray[k - 1];
                }
                cellularFunction2D$Point.distance = f8;
                cellularFunction2D$Point.x = f4;
                cellularFunction2D$Point.y = f5;
                cellularFunction2D$PointArray[j] = cellularFunction2D$Point;
                continue block0;
            }
        }
        return cellularFunction2D$PointArray[1].distance;
    }

    public float evaluate(float f2, float f3) {
        int n;
        for (n = 0; n < this.results.length; ++n) {
            this.results[n].distance = Float.POSITIVE_INFINITY;
        }
        n = (int)f2;
        float f4 = f2 - (float)n;
        int n2 = (int)f3;
        float f5 = f3 - (float)n2;
        float f6 = this.checkCube(f4, f5, n, n2, this.results);
        if (f6 > f5) {
            f6 = this.checkCube(f4, f5 + 1.0f, n, n2 - 1, this.results);
        }
        if (f6 > 1.0f - f5) {
            f6 = this.checkCube(f4, f5 - 1.0f, n, n2 + 1, this.results);
        }
        if (f6 > f4) {
            this.checkCube(f4 + 1.0f, f5, n - 1, n2, this.results);
            if (f6 > f5) {
                f6 = this.checkCube(f4 + 1.0f, f5 + 1.0f, n - 1, n2 - 1, this.results);
            }
            if (f6 > 1.0f - f5) {
                f6 = this.checkCube(f4 + 1.0f, f5 - 1.0f, n - 1, n2 + 1, this.results);
            }
        }
        if (f6 > 1.0f - f4) {
            f6 = this.checkCube(f4 - 1.0f, f5, n + 1, n2, this.results);
            if (f6 > f5) {
                f6 = this.checkCube(f4 - 1.0f, f5 + 1.0f, n + 1, n2 - 1, this.results);
            }
            if (f6 > 1.0f - f5) {
                f6 = this.checkCube(f4 - 1.0f, f5 - 1.0f, n + 1, n2 + 1, this.results);
            }
        }
        float f7 = 0.0f;
        for (int i = 0; i < 2; ++i) {
            f7 += this.coefficients[i] * this.results[i].distance;
        }
        if (this.angular) {
            f7 = (float)((double)f7 + (Math.atan2(f5 - this.results[0].y, f4 - this.results[0].x) / (Math.PI * 2) + 0.5));
        }
        return f7;
    }
}

