/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.math;

import com.jhlabs.math.Function2D;
import com.jhlabs.math.Noise;

public class FBM
implements Function2D {
    protected float[] exponents;
    protected float H;
    protected float lacunarity;
    protected float octaves;
    protected Function2D basis;

    public FBM(float f2, float f3, float f4) {
        this(f2, f3, f4, new Noise());
    }

    public FBM(float f2, float f3, float f4, Function2D function2D) {
        this.H = f2;
        this.lacunarity = f3;
        this.octaves = f4;
        this.basis = function2D;
        this.exponents = new float[(int)f4 + 1];
        float f5 = 1.0f;
        for (int i = 0; i <= (int)f4; ++i) {
            this.exponents[i] = (float)Math.pow(f5, -f2);
            f5 *= f3;
        }
    }

    public void setBasis(Function2D function2D) {
        this.basis = function2D;
    }

    public Function2D getBasisType() {
        return this.basis;
    }

    public float evaluate(float f2, float f3) {
        int n;
        float f4 = 0.0f;
        f2 += 371.0f;
        f3 += 529.0f;
        for (n = 0; n < (int)this.octaves; ++n) {
            f4 += this.basis.evaluate(f2, f3) * this.exponents[n];
            f2 *= this.lacunarity;
            f3 *= this.lacunarity;
        }
        float f5 = this.octaves - (float)((int)this.octaves);
        if (f5 != 0.0f) {
            f4 += f5 * this.basis.evaluate(f2, f3) * this.exponents[n];
        }
        return f4;
    }
}

