/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.vecmath;

import com.jhlabs.vecmath.AxisAngle4f;
import com.jhlabs.vecmath.Point3f;
import com.jhlabs.vecmath.Quat4f;
import com.jhlabs.vecmath.Vector3f;

public class Matrix4f {
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;

    public Matrix4f() {
        this.setIdentity();
    }

    public Matrix4f(Matrix4f matrix4f) {
        this.set(matrix4f);
    }

    public Matrix4f(float[] fArray) {
        this.set(fArray);
    }

    public void set(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m01;
        this.m02 = matrix4f.m02;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m12;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m20;
        this.m21 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 = matrix4f.m30;
        this.m31 = matrix4f.m31;
        this.m32 = matrix4f.m32;
        this.m33 = matrix4f.m33;
    }

    public void set(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m03 = fArray[3];
        this.m10 = fArray[4];
        this.m11 = fArray[5];
        this.m12 = fArray[6];
        this.m13 = fArray[7];
        this.m20 = fArray[8];
        this.m21 = fArray[9];
        this.m22 = fArray[10];
        this.m23 = fArray[11];
        this.m30 = fArray[12];
        this.m31 = fArray[13];
        this.m32 = fArray[14];
        this.m33 = fArray[15];
    }

    public void get(Matrix4f matrix4f) {
        matrix4f.m00 = this.m00;
        matrix4f.m01 = this.m01;
        matrix4f.m02 = this.m02;
        matrix4f.m03 = this.m03;
        matrix4f.m10 = this.m10;
        matrix4f.m11 = this.m11;
        matrix4f.m12 = this.m12;
        matrix4f.m13 = this.m13;
        matrix4f.m20 = this.m20;
        matrix4f.m21 = this.m21;
        matrix4f.m22 = this.m22;
        matrix4f.m23 = this.m23;
        matrix4f.m30 = this.m30;
        matrix4f.m31 = this.m31;
        matrix4f.m32 = this.m32;
        matrix4f.m33 = this.m33;
    }

    public void get(float[] fArray) {
        fArray[0] = this.m00;
        fArray[1] = this.m01;
        fArray[2] = this.m02;
        fArray[3] = this.m03;
        fArray[4] = this.m10;
        fArray[5] = this.m11;
        fArray[6] = this.m12;
        fArray[7] = this.m13;
        fArray[8] = this.m20;
        fArray[9] = this.m21;
        fArray[10] = this.m22;
        fArray[11] = this.m23;
        fArray[12] = this.m30;
        fArray[13] = this.m31;
        fArray[14] = this.m32;
        fArray[15] = this.m33;
    }

    public void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public void mul(Matrix4f matrix4f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m03;
        float f6 = this.m10;
        float f7 = this.m11;
        float f8 = this.m12;
        float f9 = this.m13;
        float f10 = this.m20;
        float f11 = this.m21;
        float f12 = this.m22;
        float f13 = this.m23;
        float f14 = this.m30;
        float f15 = this.m31;
        float f16 = this.m32;
        float f17 = this.m33;
        this.m00 = f2 * matrix4f.m00 + f6 * matrix4f.m01 + f10 * matrix4f.m02 + f14 * matrix4f.m03;
        this.m01 = f3 * matrix4f.m00 + f7 * matrix4f.m01 + f11 * matrix4f.m02 + f15 * matrix4f.m03;
        this.m02 = f4 * matrix4f.m00 + f8 * matrix4f.m01 + f12 * matrix4f.m02 + f16 * matrix4f.m03;
        this.m03 = f5 * matrix4f.m00 + f9 * matrix4f.m01 + f13 * matrix4f.m02 + f17 * matrix4f.m03;
        this.m10 = f2 * matrix4f.m10 + f6 * matrix4f.m11 + f10 * matrix4f.m12 + f14 * matrix4f.m13;
        this.m11 = f3 * matrix4f.m10 + f7 * matrix4f.m11 + f11 * matrix4f.m12 + f15 * matrix4f.m13;
        this.m12 = f4 * matrix4f.m10 + f8 * matrix4f.m11 + f12 * matrix4f.m12 + f16 * matrix4f.m13;
        this.m13 = f5 * matrix4f.m10 + f9 * matrix4f.m11 + f13 * matrix4f.m12 + f17 * matrix4f.m13;
        this.m20 = f2 * matrix4f.m20 + f6 * matrix4f.m21 + f10 * matrix4f.m22 + f14 * matrix4f.m23;
        this.m21 = f3 * matrix4f.m20 + f7 * matrix4f.m21 + f11 * matrix4f.m22 + f15 * matrix4f.m23;
        this.m22 = f4 * matrix4f.m20 + f8 * matrix4f.m21 + f12 * matrix4f.m22 + f16 * matrix4f.m23;
        this.m23 = f5 * matrix4f.m20 + f9 * matrix4f.m21 + f13 * matrix4f.m22 + f17 * matrix4f.m23;
        this.m30 = f2 * matrix4f.m30 + f6 * matrix4f.m31 + f10 * matrix4f.m32 + f14 * matrix4f.m33;
        this.m31 = f3 * matrix4f.m30 + f7 * matrix4f.m31 + f11 * matrix4f.m32 + f15 * matrix4f.m33;
        this.m32 = f4 * matrix4f.m30 + f8 * matrix4f.m31 + f12 * matrix4f.m32 + f16 * matrix4f.m33;
        this.m33 = f5 * matrix4f.m30 + f9 * matrix4f.m31 + f13 * matrix4f.m32 + f17 * matrix4f.m33;
    }

    public void invert() {
        Matrix4f matrix4f = new Matrix4f(this);
        this.invert(matrix4f);
    }

    public void invert(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m01 = matrix4f.m10;
        this.m02 = matrix4f.m20;
        this.m03 = matrix4f.m03;
        this.m10 = matrix4f.m01;
        this.m11 = matrix4f.m11;
        this.m12 = matrix4f.m21;
        this.m13 = matrix4f.m13;
        this.m20 = matrix4f.m02;
        this.m21 = matrix4f.m12;
        this.m22 = matrix4f.m22;
        this.m23 = matrix4f.m23;
        this.m30 *= -1.0f;
        this.m31 *= -1.0f;
        this.m32 *= -1.0f;
        this.m33 = matrix4f.m33;
    }

    public void set(AxisAngle4f axisAngle4f) {
        float f2 = axisAngle4f.angle * 0.5f;
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        this.set(new Quat4f(axisAngle4f.x * f4, axisAngle4f.y * f4, axisAngle4f.z * f4, f3));
    }

    public void set(Quat4f quat4f) {
        float f2 = quat4f.x + quat4f.x;
        float f3 = quat4f.y + quat4f.y;
        float f4 = quat4f.z + quat4f.z;
        float f5 = quat4f.x * f2;
        float f6 = quat4f.x * f3;
        float f7 = quat4f.x * f4;
        float f8 = quat4f.y * f3;
        float f9 = quat4f.y * f4;
        float f10 = quat4f.z * f4;
        float f11 = quat4f.w * f2;
        float f12 = quat4f.w * f3;
        float f13 = quat4f.w * f4;
        this.m00 = 1.0f - (f8 + f10);
        this.m01 = f6 - f13;
        this.m02 = f7 + f12;
        this.m03 = 0.0f;
        this.m10 = f6 + f13;
        this.m11 = 1.0f - (f5 + f10);
        this.m12 = f9 - f11;
        this.m13 = 0.0f;
        this.m20 = f7 - f12;
        this.m21 = f9 + f11;
        this.m22 = 1.0f - (f5 + f8);
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public void transform(Point3f point3f) {
        float f2 = point3f.x * this.m00 + point3f.y * this.m10 + point3f.z * this.m20 + this.m30;
        float f3 = point3f.x * this.m01 + point3f.y * this.m11 + point3f.z * this.m21 + this.m31;
        float f4 = point3f.x * this.m02 + point3f.y * this.m12 + point3f.z * this.m22 + this.m32;
        point3f.x = f2;
        point3f.y = f3;
        point3f.z = f4;
    }

    public void transform(Vector3f vector3f) {
        float f2 = vector3f.x * this.m00 + vector3f.y * this.m10 + vector3f.z * this.m20;
        float f3 = vector3f.x * this.m01 + vector3f.y * this.m11 + vector3f.z * this.m21;
        float f4 = vector3f.x * this.m02 + vector3f.y * this.m12 + vector3f.z * this.m22;
        vector3f.x = f2;
        vector3f.y = f3;
        vector3f.z = f4;
    }

    public void setTranslation(Vector3f vector3f) {
        this.m30 = vector3f.x;
        this.m31 = vector3f.y;
        this.m32 = vector3f.z;
    }

    public void set(float f2) {
        this.m00 = f2;
        this.m11 = f2;
        this.m22 = f2;
    }

    public void rotX(float f2) {
        float f3 = (float)Math.sin(f2);
        float f4 = (float)Math.cos(f2);
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f4;
        this.m12 = f3;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = -f3;
        this.m22 = f4;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public void rotY(float f2) {
        float f3;
        float f4 = (float)Math.sin(f2);
        this.m00 = f3 = (float)Math.cos(f2);
        this.m01 = 0.0f;
        this.m02 = -f4;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = f4;
        this.m21 = 0.0f;
        this.m22 = f3;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public void rotZ(float f2) {
        float f3;
        float f4 = (float)Math.sin(f2);
        this.m00 = f3 = (float)Math.cos(f2);
        this.m01 = f4;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = -f4;
        this.m11 = f3;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }
}

