/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.ResampleFilter;

final class Lanczos3Filter
implements ResampleFilter {
    private static final float PI_FLOAT = (float)Math.PI;

    Lanczos3Filter() {
    }

    private float sincModified(float f2) {
        return (float)Math.sin(f2) / f2;
    }

    public final float apply(float f2) {
        if (f2 == 0.0f) {
            return 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (f2 < 3.0f) {
            return this.sincModified(f2 *= (float)Math.PI) * this.sincModified(f2 / 3.0f);
        }
        return 0.0f;
    }

    public float getSamplingRadius() {
        return 3.0f;
    }

    public String getName() {
        return "Lanczos3";
    }
}

