/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.DimensionConstrain;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class MultiStepRescaleOp
extends AdvancedResizeOp {
    private final Object renderingHintInterpolation;

    public MultiStepRescaleOp(int n, int n2) {
        this(n, n2, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public MultiStepRescaleOp(int n, int n2, Object object) {
        this(DimensionConstrain.createAbsolutionDimension(n, n2), object);
    }

    public MultiStepRescaleOp(DimensionConstrain dimensionConstrain) {
        this(dimensionConstrain, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public MultiStepRescaleOp(DimensionConstrain dimensionConstrain, Object object) {
        super(dimensionConstrain);
        this.renderingHintInterpolation = object;
        assert (RenderingHints.KEY_INTERPOLATION.isCompatibleValue(object)) : "Rendering hint " + object + " is not compatible with interpolation";
    }

    public BufferedImage doFilter(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        int n3 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage3 = bufferedImage;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        do {
            if (n4 > n) {
                if ((n4 /= 2) < n) {
                    n4 = n;
                }
            } else {
                n4 = n;
            }
            if (n5 > n2) {
                if ((n5 /= 2) < n2) {
                    n5 = n2;
                }
            } else {
                n5 = n2;
            }
            BufferedImage bufferedImage4 = bufferedImage2 != null && bufferedImage2.getWidth() == n4 && bufferedImage2.getHeight() == n5 && n4 == n && n5 == n2 ? bufferedImage2 : new BufferedImage(n4, n5, n3);
            Graphics2D graphics2D = bufferedImage4.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.renderingHintInterpolation);
            graphics2D.drawImage(bufferedImage3, 0, 0, n4, n5, null);
            graphics2D.dispose();
            bufferedImage3 = bufferedImage4;
        } while (n4 != n || n5 != n2);
        return bufferedImage3;
    }
}

