/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ImageUtils;
import com.mortennobel.imagescaling.ResampleFilter;
import com.mortennobel.imagescaling.ResampleFilters;
import com.mortennobel.imagescaling.ResampleOp$1;
import com.mortennobel.imagescaling.ResampleOp$2;
import com.mortennobel.imagescaling.ResampleOp$SubSamplingData;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicInteger;

public class ResampleOp
extends AdvancedResizeOp {
    private final int MAX_CHANNEL_VALUE = 255;
    private int nrChannels;
    private int srcWidth;
    private int srcHeight;
    private int dstWidth;
    private int dstHeight;
    private ResampleOp$SubSamplingData horizontalSubsamplingData;
    private ResampleOp$SubSamplingData verticalSubsamplingData;
    private int processedItems;
    private float totalItems;
    private int numberOfThreads = Runtime.getRuntime().availableProcessors();
    private AtomicInteger multipleInvocationLock = new AtomicInteger();
    private ResampleFilter filter = ResampleFilters.getLanczos3Filter();

    public ResampleOp(int n, int n2) {
        this(DimensionConstrain.createAbsolutionDimension(n, n2));
    }

    public ResampleOp(DimensionConstrain dimensionConstrain) {
        super(dimensionConstrain);
    }

    public ResampleFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ResampleFilter resampleFilter) {
        this.filter = resampleFilter;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int n) {
        this.numberOfThreads = n;
    }

    public BufferedImage doFilter(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        BufferedImage bufferedImage3;
        int n3;
        byte[] byArray;
        this.dstWidth = n;
        this.dstHeight = n2;
        if (n < 3 || n2 < 3) {
            throw new RuntimeException("Error doing rescale. Target size was " + n + "x" + n2 + " but must be at least 3x3.");
        }
        assert (this.multipleInvocationLock.incrementAndGet() == 1) : "Multiple concurrent invocations detected";
        if (bufferedImage.getType() == 12 || bufferedImage.getType() == 13 || bufferedImage.getType() == 0) {
            bufferedImage = ImageUtils.convert(bufferedImage, bufferedImage.getColorModel().hasAlpha() ? 6 : 5);
        }
        this.nrChannels = ImageUtils.nrChannels(bufferedImage);
        assert (this.nrChannels > 0);
        this.srcWidth = bufferedImage.getWidth();
        this.srcHeight = bufferedImage.getHeight();
        byte[][] byArray2 = new byte[this.srcHeight][n * this.nrChannels];
        this.processedItems = 0;
        this.totalItems = this.srcHeight + n;
        this.horizontalSubsamplingData = ResampleOp.createSubSampling(this.filter, this.srcWidth, n);
        this.verticalSubsamplingData = ResampleOp.createSubSampling(this.filter, this.srcHeight, n2);
        BufferedImage bufferedImage4 = bufferedImage;
        byte[][] byArray3 = byArray2;
        Thread[] threadArray = new Thread[this.numberOfThreads - 1];
        for (int i = 1; i < this.numberOfThreads; ++i) {
            int n4 = i;
            threadArray[i - 1] = new Thread(new ResampleOp$1(this, bufferedImage4, byArray3, n4));
            threadArray[i - 1].start();
        }
        this.horizontallyFromSrcToWork(bufferedImage4, byArray3, 0, this.numberOfThreads);
        this.waitForAllThreads(threadArray);
        byte[] byArray4 = byArray = new byte[n * n2 * this.nrChannels];
        for (int i = 1; i < this.numberOfThreads; ++i) {
            n3 = i;
            threadArray[i - 1] = new Thread(new ResampleOp$2(this, byArray3, byArray4, n3));
            threadArray[i - 1].start();
        }
        this.verticalFromWorkToDst(byArray3, byArray4, 0, this.numberOfThreads);
        this.waitForAllThreads(threadArray);
        byArray2 = null;
        if (bufferedImage2 != null && n == bufferedImage2.getWidth() && n2 == bufferedImage2.getHeight()) {
            bufferedImage3 = bufferedImage2;
            n3 = ImageUtils.nrChannels(bufferedImage2);
            if (n3 != this.nrChannels) {
                String string = String.format("Destination image must be compatible width source image. Source image had %d channels destination image had %d channels", this.nrChannels, n3);
                throw new RuntimeException(string);
            }
        } else {
            bufferedImage3 = new BufferedImage(n, n2, this.getResultBufferedImageType(bufferedImage));
        }
        ImageUtils.setBGRPixels(byArray, bufferedImage3, 0, 0, n, n2);
        assert (this.multipleInvocationLock.decrementAndGet() == 0) : "Multiple concurrent invocations detected";
        return bufferedImage3;
    }

    private void waitForAllThreads(Thread[] threadArray) {
        try {
            for (Thread thread : threadArray) {
                thread.join(Long.MAX_VALUE);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(interruptedException);
        }
    }

    static ResampleOp$SubSamplingData createSubSampling(ResampleFilter resampleFilter, int n, int n2) {
        int[] nArray;
        float[] fArray;
        int n3;
        float f2 = (float)n2 / (float)n;
        int[] nArray2 = new int[n2];
        float f3 = resampleFilter.getSamplingRadius();
        float f4 = 0.5f / f2;
        if (f2 < 1.0f) {
            float f5 = f3 / f2;
            n3 = (int)(f5 * 2.0f + 2.0f);
            fArray = new float[n2 * n3];
            nArray = new int[n2 * n3];
            float f6 = (float)(1.0 / (Math.ceil(f5) / (double)f3));
            for (int i = 0; i < n2; ++i) {
                int n4;
                float f7;
                int n5;
                int n6 = i * n3;
                float f8 = (float)i / f2 + f4;
                int n7 = (int)Math.floor(f8 - f5);
                int n8 = (int)Math.ceil(f8 + f5);
                for (n5 = n7; n5 <= n8; ++n5) {
                    f7 = resampleFilter.apply((f8 - (float)n5) * f6);
                    if (f7 == 0.0f) continue;
                    n4 = n5 < 0 ? -n5 : (n5 >= n ? n - n5 + n - 1 : n5);
                    int n9 = nArray2[i];
                    int n10 = i;
                    nArray2[n10] = nArray2[n10] + 1;
                    if (n4 < 0 || n4 >= n) {
                        f7 = 0.0f;
                    }
                    nArray[n6 + n9] = n4;
                    fArray[n6 + n9] = f7;
                }
                n5 = nArray2[i];
                f7 = 0.0f;
                for (n4 = 0; n4 < n5; ++n4) {
                    f7 += fArray[n6 + n4];
                }
                if (f7 == 0.0f) continue;
                for (n4 = 0; n4 < n5; ++n4) {
                    int n11 = n6 + n4;
                    fArray[n11] = fArray[n11] / f7;
                }
            }
        } else {
            n3 = (int)(f3 * 2.0f + 1.0f);
            fArray = new float[n2 * n3];
            nArray = new int[n2 * n3];
            for (int i = 0; i < n2; ++i) {
                int n12;
                float f9;
                int n13;
                int n14 = i * n3;
                float f10 = (float)i / f2 + f4;
                int n15 = (int)Math.floor(f10 - f3);
                int n16 = (int)Math.ceil(f10 + f3);
                for (n13 = n15; n13 <= n16; ++n13) {
                    f9 = resampleFilter.apply(f10 - (float)n13);
                    if (f9 == 0.0f) continue;
                    n12 = n13 < 0 ? -n13 : (n13 >= n ? n - n13 + n - 1 : n13);
                    int n17 = nArray2[i];
                    int n18 = i;
                    nArray2[n18] = nArray2[n18] + 1;
                    if (n12 < 0 || n12 >= n) {
                        f9 = 0.0f;
                    }
                    nArray[n14 + n17] = n12;
                    fArray[n14 + n17] = f9;
                }
                n13 = nArray2[i];
                f9 = 0.0f;
                for (n12 = 0; n12 < n13; ++n12) {
                    f9 += fArray[n14 + n12];
                }
                assert (f9 != 0.0f) : "should never happen except bug in filter";
                if (f9 == 0.0f) continue;
                for (n12 = 0; n12 < n13; ++n12) {
                    int n19 = n14 + n12;
                    fArray[n19] = fArray[n19] / f9;
                }
            }
        }
        return new ResampleOp$SubSamplingData(nArray2, nArray, fArray, n3, null);
    }

    private void verticalFromWorkToDst(byte[][] byArray, byte[] byArray2, int n, int n2) {
        if (this.nrChannels == 1) {
            this.verticalFromWorkToDstGray(byArray, byArray2, n, this.numberOfThreads);
            return;
        }
        boolean bl = this.nrChannels > 3;
        for (int i = n; i < this.dstWidth; i += n2) {
            int n3 = i * this.nrChannels;
            for (int j = this.dstHeight - 1; j >= 0; --j) {
                int n4 = j * ResampleOp$SubSamplingData.access$400(this.verticalSubsamplingData);
                int n5 = ResampleOp$SubSamplingData.access$500(this.verticalSubsamplingData)[j];
                int n6 = (j * this.dstWidth + i) * this.nrChannels;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                float f5 = 0.0f;
                int n7 = n4;
                for (int k = n5 - 1; k >= 0; --k) {
                    int n8 = ResampleOp$SubSamplingData.access$600(this.verticalSubsamplingData)[n7];
                    float f6 = ResampleOp$SubSamplingData.access$700(this.verticalSubsamplingData)[n7];
                    f2 += (float)(byArray[n8][n3] & 0xFF) * f6;
                    f3 += (float)(byArray[n8][n3 + 1] & 0xFF) * f6;
                    f4 += (float)(byArray[n8][n3 + 2] & 0xFF) * f6;
                    if (bl) {
                        f5 += (float)(byArray[n8][n3 + 3] & 0xFF) * f6;
                    }
                    ++n7;
                }
                byArray2[n6] = this.toByte(f2);
                byArray2[n6 + 1] = this.toByte(f3);
                byArray2[n6 + 2] = this.toByte(f4);
                if (!bl) continue;
                byArray2[n6 + 3] = this.toByte(f5);
            }
            ++this.processedItems;
            if (n != 0) continue;
            this.setProgress();
        }
    }

    private void verticalFromWorkToDstGray(byte[][] byArray, byte[] byArray2, int n, int n2) {
        for (int i = n; i < this.dstWidth; i += n2) {
            int n3 = i;
            for (int j = this.dstHeight - 1; j >= 0; --j) {
                int n4 = j * ResampleOp$SubSamplingData.access$400(this.verticalSubsamplingData);
                int n5 = ResampleOp$SubSamplingData.access$500(this.verticalSubsamplingData)[j];
                int n6 = j * this.dstWidth + i;
                float f2 = 0.0f;
                int n7 = n4;
                for (int k = n5 - 1; k >= 0; --k) {
                    int n8 = ResampleOp$SubSamplingData.access$600(this.verticalSubsamplingData)[n7];
                    float f3 = ResampleOp$SubSamplingData.access$700(this.verticalSubsamplingData)[n7];
                    f2 += (float)(byArray[n8][n3] & 0xFF) * f3;
                    ++n7;
                }
                byArray2[n6] = this.toByte(f2);
            }
            ++this.processedItems;
            if (n != 0) continue;
            this.setProgress();
        }
    }

    private void horizontallyFromSrcToWork(BufferedImage bufferedImage, byte[][] byArray, int n, int n2) {
        if (this.nrChannels == 1) {
            this.horizontallyFromSrcToWorkGray(bufferedImage, byArray, n, n2);
            return;
        }
        int[] nArray = new int[this.srcWidth];
        byte[] byArray2 = new byte[this.srcWidth * this.nrChannels];
        boolean bl = this.nrChannels > 3;
        for (int i = n; i < this.srcHeight; i += n2) {
            ImageUtils.getPixelsBGR(bufferedImage, i, this.srcWidth, byArray2, nArray);
            for (int j = this.dstWidth - 1; j >= 0; --j) {
                int n3 = j * this.nrChannels;
                int n4 = ResampleOp$SubSamplingData.access$500(this.horizontalSubsamplingData)[j];
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                float f5 = 0.0f;
                int n5 = j * ResampleOp$SubSamplingData.access$400(this.horizontalSubsamplingData);
                for (int k = n4 - 1; k >= 0; --k) {
                    float f6 = ResampleOp$SubSamplingData.access$700(this.horizontalSubsamplingData)[n5];
                    int n6 = ResampleOp$SubSamplingData.access$600(this.horizontalSubsamplingData)[n5] * this.nrChannels;
                    f2 += (float)(byArray2[n6] & 0xFF) * f6;
                    f3 += (float)(byArray2[n6 + 1] & 0xFF) * f6;
                    f4 += (float)(byArray2[n6 + 2] & 0xFF) * f6;
                    if (bl) {
                        f5 += (float)(byArray2[n6 + 3] & 0xFF) * f6;
                    }
                    ++n5;
                }
                byArray[i][n3] = this.toByte(f2);
                byArray[i][n3 + 1] = this.toByte(f3);
                byArray[i][n3 + 2] = this.toByte(f4);
                if (!bl) continue;
                byArray[i][n3 + 3] = this.toByte(f5);
            }
            ++this.processedItems;
            if (n != 0) continue;
            this.setProgress();
        }
    }

    private void horizontallyFromSrcToWorkGray(BufferedImage bufferedImage, byte[][] byArray, int n, int n2) {
        int[] nArray = new int[this.srcWidth];
        byte[] byArray2 = new byte[this.srcWidth];
        for (int i = n; i < this.srcHeight; i += n2) {
            ImageUtils.getPixelsBGR(bufferedImage, i, this.srcWidth, byArray2, nArray);
            for (int j = this.dstWidth - 1; j >= 0; --j) {
                int n3 = j;
                int n4 = ResampleOp$SubSamplingData.access$500(this.horizontalSubsamplingData)[j];
                float f2 = 0.0f;
                int n5 = j * ResampleOp$SubSamplingData.access$400(this.horizontalSubsamplingData);
                for (int k = n4 - 1; k >= 0; --k) {
                    float f3 = ResampleOp$SubSamplingData.access$700(this.horizontalSubsamplingData)[n5];
                    int n6 = ResampleOp$SubSamplingData.access$600(this.horizontalSubsamplingData)[n5];
                    f2 += (float)(byArray2[n6] & 0xFF) * f3;
                    ++n5;
                }
                byArray[i][n3] = this.toByte(f2);
            }
            ++this.processedItems;
            if (n != 0) continue;
            this.setProgress();
        }
    }

    private byte toByte(float f2) {
        if (f2 < 0.0f) {
            return 0;
        }
        if (f2 > 255.0f) {
            return -1;
        }
        return (byte)(f2 + 0.5f);
    }

    private void setProgress() {
        this.fireProgressChanged((float)this.processedItems / this.totalItems);
    }

    protected int getResultBufferedImageType(BufferedImage bufferedImage) {
        return this.nrChannels == 3 ? 5 : (this.nrChannels == 4 ? 6 : (bufferedImage.getSampleModel().getDataType() == 1 ? 11 : 10));
    }

    static /* synthetic */ int access$000(ResampleOp resampleOp) {
        return resampleOp.numberOfThreads;
    }

    static /* synthetic */ void access$100(ResampleOp resampleOp, BufferedImage bufferedImage, byte[][] byArray, int n, int n2) {
        resampleOp.horizontallyFromSrcToWork(bufferedImage, byArray, n, n2);
    }

    static /* synthetic */ void access$200(ResampleOp resampleOp, byte[][] byArray, byte[] byArray2, int n, int n2) {
        resampleOp.verticalFromWorkToDst(byArray, byArray2, n, n2);
    }
}

