/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.adb;

import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.process.AdbRunner;
import com.xiaomitool.v2.resources.ResourcesManager;
import com.xiaomitool.v2.utility.utils.StrUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdbCommons {
    private static final int DEFAULT_TIMEOUT = 6;
    private static final String CHECK_RETURN_CODE = "return_code_is_not_zero";
    private static final HashMap<String, String> LAST_ERROR_MAP = new HashMap();

    private static String command_string(String string) {
        return AdbCommons.command(string, null);
    }

    private static String command_string(String string, String string2) {
        AdbRunner adbRunner = AdbCommons.adb_command(string, string2, 6);
        if (adbRunner == null) {
            return null;
        }
        return adbRunner.getOutputString();
    }

    private static List<String> command_list(String string) {
        return AdbCommons.command_list(string, null);
    }

    private static List<String> command_list(String string, String string2) {
        AdbRunner adbRunner = AdbCommons.adb_command(string, string2, 6);
        if (adbRunner == null) {
            return null;
        }
        return adbRunner.getOutputLines();
    }

    public static String command(String string, String string2) {
        return AdbCommons.command(string, string2, 6);
    }

    public static String command(String string, String string2, int n) {
        AdbRunner adbRunner = AdbCommons.adb_command(string, string2, n);
        if (adbRunner == null) {
            return null;
        }
        return adbRunner.getOutputString();
    }

    private static AdbRunner adb_command(String string, String string2, int n) {
        AdbRunner adbRunner = new AdbRunner();
        if (string2 != null) {
            adbRunner.setDeviceSerial(string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group(1));
        }
        for (String list : arrayList) {
            adbRunner.addArgument(list);
        }
        try {
            adbRunner.runWait(n);
        }
        catch (IOException iOException) {
            return null;
        }
        int n2 = adbRunner.getExitValue();
        if (n2 == 0) {
            LAST_ERROR_MAP.put(string2, null);
        } else {
            List<String> list = adbRunner.getOutputLines();
            String string3 = list != null && !list.isEmpty() ? list.get(list.size() - 1) : "unknown error";
            LAST_ERROR_MAP.put(string2, string3);
        }
        return adbRunner;
    }

    public static List<String> devices() {
        return AdbCommons.command_list("devices");
    }

    public static String start_server() {
        return AdbCommons.command_string("start-server");
    }

    public static String kill_server() {
        return AdbCommons.command_string("kill-server");
    }

    public static List<String> getProps(String string) {
        return AdbCommons.command_list("shell -x getprop", string);
    }

    public static boolean fileExists(String string, String string2) {
        String string3 = AdbCommons.adb_shellWithOr("ls " + string, string2, 6);
        return string3 != null;
    }

    public static boolean formatBootdevicePartition(String string, String string2, int n) {
        return AdbCommons.adb_shellWithOr("mke2fs -T ext4 /dev/block/bootdevice/by-name/" + string, string2, n) != null;
    }

    public static String adb_shell(String string, String string2, int n) {
        AdbRunner adbRunner = new AdbRunner("shell", "-x", string);
        adbRunner.setDeviceSerial(string2);
        try {
            if (adbRunner.runWait(n) != 0) {
                Log.error("Adb shell command returned " + adbRunner.getExitValue());
            }
        }
        catch (IOException iOException) {
            adbRunner = null;
        }
        if (adbRunner == null || adbRunner.getExitValue() != 0) {
            return null;
        }
        return adbRunner.getOutputString();
    }

    public static String adb_shellWithOr(String string, String string2, int n) {
        String string3 = AdbCommons.adb_shell(string = string + " || echo return_code_is_not_zero", string2, n);
        if (string3 == null) {
            return null;
        }
        if (string3.contains(CHECK_RETURN_CODE)) {
            LAST_ERROR_MAP.put(string, StrUtils.lastLine(string3));
            return null;
        }
        return string3;
    }

    public static File simplePull(String string, String string2, String string3) {
        Path path = ResourcesManager.getTmpPath();
        if (!path.toFile().exists()) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                Log.warn("Cannot create tmp dir: " + path.toString() + " : " + iOException.getMessage());
                return null;
            }
        }
        Path path2 = path.resolve(string3);
        AdbRunner adbRunner = AdbCommons.adb_command("pull " + string2 + " \"" + path2.toString() + "\"", string, 3600);
        if (adbRunner == null) {
            return null;
        }
        if (adbRunner.getExitValue() != 0) {
            return null;
        }
        return path2.toFile();
    }

    public static String raw(String string, String string2) {
        return AdbCommons.raw(string, string2, 30);
    }

    public static String raw(String string, String string2, int n) {
        AdbRunner adbRunner = AdbCommons.adb_command("raw " + string2, string, n);
        if (adbRunner == null || adbRunner.getExitValue() != 0) {
            return null;
        }
        return adbRunner.getOutputString();
    }

    public static String cat(String string, String string2) {
        return AdbCommons.adb_shellWithOr("cat " + string2, string, 6);
    }

    public static String reboot(String string, String string2) {
        return AdbCommons.command_string("reboot " + string2, string);
    }

    public static AdbRunner runner(String string, String string2, int n) {
        return AdbCommons.adb_command(string, string2, n);
    }

    public static boolean mkdir(String string, String string2) {
        return AdbCommons.adb_shellWithOr("mkdir \"" + string + "\"", string2, 5) != null;
    }

    public static String getLastError(String string) {
        return String.valueOf(LAST_ERROR_MAP.get(string));
    }
}

