/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.adb;

import com.xiaomitool.v2.adb.AdbCommons;
import com.xiaomitool.v2.adb.AdbCommunication$1;
import com.xiaomitool.v2.adb.AdbCommunication$2;
import com.xiaomitool.v2.adb.AdbUtils;
import com.xiaomitool.v2.adb.FastbootCommons;
import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.process.AdbRunner;
import java.util.List;
import java.util.Map;

public class AdbCommunication {
    private static final int REFRESH_TIME_MS = 2500;
    private static final Object sync = new Object();
    public static Thread trackDevicesThread;
    public static Thread refreshDevicesThread;
    private static int cannotInterruptCount;
    private static boolean isTrackDeviceActive;
    private static AdbRunner trackDeviceProcess;

    public static boolean canInterrupt() {
        return cannotInterruptCount == 0;
    }

    public static void startServer() {
        if (!AdbCommunication.canInterrupt()) {
            // empty if block
        }
        AdbCommons.start_server();
    }

    public static void killServer() {
        if (!AdbCommunication.canInterrupt()) {
            return;
        }
        AdbCommons.kill_server();
    }

    public static void restartServer() {
        AdbCommunication.killServer();
        AdbCommunication.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAutoScanDevices() {
        Log.info("Starting autoscan threads");
        Object object = sync;
        synchronized (object) {
            if (refreshDevicesThread != null) {
                return;
            }
        }
        object = new AdbCommunication$1();
        trackDevicesThread = new Thread((Runnable)object);
        trackDevicesThread.start();
        AdbCommunication$2 adbCommunication$2 = new AdbCommunication$2();
        refreshDevicesThread = new Thread(adbCommunication$2);
        refreshDevicesThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refereshAdbDevices(Map<String, Device$Status> map) {
        List<String> list = AdbCommons.devices();
        if (list == null) {
            return;
        }
        Map<String, Device$Status> map2 = map;
        synchronized (map2) {
            map.putAll(AdbUtils.parseDevices(list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshFastbootDevices(Map<String, Device$Status> map) {
        List<String> list = FastbootCommons.devices();
        if (list == null) {
            return;
        }
        Map<String, Device$Status> map2 = map;
        synchronized (map2) {
            map.putAll(AdbUtils.parseDevices(list));
        }
    }

    public static void refreshDevices(Map<String, Device$Status> map) {
        AdbCommunication.refereshAdbDevices(map);
        AdbCommunication.refreshFastbootDevices(map);
    }

    public static void getAllAccess() {
        ++cannotInterruptCount;
        AdbCommunication.unregisterAutoScanDevices();
    }

    public static void giveAllAccess() {
        if (cannotInterruptCount > 0) {
            --cannotInterruptCount;
        }
        if (AdbCommunication.canInterrupt()) {
            AdbCommunication.registerAutoScanDevices();
        }
    }

    public static void unregisterAutoScanDevices() {
        Log.info("Stopping autoscan threads");
        if (trackDeviceProcess != null) {
            trackDeviceProcess.kill();
        }
        if (refreshDevicesThread != null && refreshDevicesThread.isAlive()) {
            refreshDevicesThread.interrupt();
        }
        refreshDevicesThread = null;
        if (trackDevicesThread != null && trackDevicesThread.isAlive()) {
            trackDevicesThread.interrupt();
        }
        trackDevicesThread = null;
    }

    public static boolean isAutoScanRegistered() {
        return refreshDevicesThread != null && refreshDevicesThread.isAlive();
    }

    static /* synthetic */ AdbRunner access$002(AdbRunner adbRunner) {
        trackDeviceProcess = adbRunner;
        return trackDeviceProcess;
    }

    static /* synthetic */ AdbRunner access$000() {
        return trackDeviceProcess;
    }

    static /* synthetic */ boolean access$102(boolean bl) {
        isTrackDeviceActive = bl;
        return isTrackDeviceActive;
    }

    static {
        cannotInterruptCount = 0;
        isTrackDeviceActive = false;
    }
}

