/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.adb;

import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.logging.Log;
import java.io.File;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Hex;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AdbUtils {
    public static Map<String, Device$Status> parseDevices(List<String> list) {
        HashMap<String, Device$Status> hashMap = new HashMap<String, Device$Status>();
        Pattern pattern = Pattern.compile("^(\\w+)\\s+(\\w+)$");
        for (String string : list) {
            Matcher matcher;
            if (string == null || !(matcher = pattern.matcher(string = string.trim())).matches()) continue;
            hashMap.put(matcher.group(1), Device$Status.fromString(matcher.group(2)));
        }
        return hashMap;
    }

    public static Map<String, Device$Status> parseTrackDevices(String string) {
        int n = string.length();
        int n2 = 0;
        HashMap<String, Device$Status> hashMap = new HashMap<String, Device$Status>();
        Pattern pattern = Pattern.compile("^(\\w+)\\s+(\\w+)$");
        while (n2 < n - 3) {
            int n3;
            String string2 = string.substring(n2, n2 + 4);
            try {
                n3 = Integer.parseInt(string2, 16);
            }
            catch (Exception exception) {
                Log.warn(exception.getMessage());
                break;
            }
            n2 += 4;
            if (n3 == 0) continue;
            String string3 = string.substring(n2, Integer.min(n, n2 + n3));
            n2 += n3;
            Matcher matcher = pattern.matcher(string3);
            if (!matcher.matches()) continue;
            hashMap.put(matcher.group(1), Device$Status.fromString(matcher.group(2)));
        }
        return hashMap;
    }

    public static HashMap<String, String> parseGetProp(List<String> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("\\[([^\\]]+)\\]\\s*\\:\\s*\\[([^\\]]+)\\]");
        for (String string : list) {
            Matcher matcher;
            if (string == null || !(matcher = pattern.matcher(string = string.trim())).matches()) continue;
            hashMap.put(matcher.group(1), matcher.group(2));
        }
        return hashMap;
    }

    public static int[] parseWmSize(String string) {
        Pattern pattern = Pattern.compile("(\\d{3,4})x(\\d{3,4})");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        try {
            int n = Integer.parseInt(matcher.group(1));
            int n2 = Integer.parseInt(matcher.group(2));
            if (n2 / n < 4 && n2 / n > 0) {
                return new int[]{n, n2};
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static HashMap<String, String> parseFastbootVars(List<String> list) {
        Pattern pattern = Pattern.compile("\\s*\\(bootloader\\)\\s+([^\\s]+)\\s*:\\s*(.*)");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : list) {
            Matcher matcher;
            if (string == null || !(matcher = pattern.matcher(string = string.trim())).matches()) continue;
            hashMap.put(matcher.group(1), matcher.group(2));
        }
        return hashMap;
    }

    public static String parseFastbootVar(String string, String string2) {
        if (string2 == null || string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\s*" + string + "\\s*:\\s*([^\\n]+)");
        Matcher matcher = pattern.matcher(string2);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1).trim();
    }

    public static String parseFastbootOemInfo(List<String> list) {
        Pattern pattern = Pattern.compile("Device unlocked:\\s*(\\w+)", 2);
        for (String string : list) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            String string2 = matcher.group(1);
            return "true".equals(string2.trim().toLowerCase()) ? "unlocked" : ("false".equals(string2.trim().toLowerCase()) ? "locked" : "unknown");
        }
        return "unknown";
    }

    public static String parseFastbootOemLks(List<String> list) {
        Pattern pattern = Pattern.compile("lks\\s*=\\s*(\\d)", 2);
        for (String string : list) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            String string2 = matcher.group(1);
            return "0".equals(string2) ? "unlocked" : "locked";
        }
        return "unknown";
    }

    public static HashMap<String, String> parseFeaturesFile(Document document) {
        String string = "name";
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null || node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string2 = element2.getAttribute(string);
            String string3 = element2.getTextContent();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    public static HashMap<String, String> parseFeaturesFile(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
        return AdbUtils.parseFeaturesFile(document);
    }

    public static HashMap<String, String> parseFeaturesFile(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return AdbUtils.parseFeaturesFile(document);
    }

    public static int parseSerialNumber(String string) {
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return AdbUtils.parseSerialNumber(string.substring(2));
        }
        try {
            byte[] byArray = Hex.decodeHex(string.toCharArray());
            return ByteBuffer.wrap(byArray).getInt();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int parseFastbootTokenSerialNumber(String string) {
        try {
            byte[] byArray = Base64.getDecoder().decode(string);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(byArray.length - 4);
            return byteBuffer.getInt();
        }
        catch (Exception exception) {
            Log.warn("Failed to parse fastboot token serial number: " + exception.getMessage());
            return 0;
        }
    }
}

