/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.adb;

import com.xiaomitool.v2.adb.AdbUtils;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.process.FastbootRunner;
import com.xiaomitool.v2.resources.ResourcesManager;
import com.xiaomitool.v2.utility.NotNull;
import com.xiaomitool.v2.utility.YesNoMaybe;
import com.xiaomitool.v2.utility.utils.ProcessUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastbootCommons {
    private static final int DEFAULT_TIMEOUT = 6;
    private static final HashMap<String, String> LAST_ERROR_MAP = new HashMap();

    public static String command_string(String string) {
        return FastbootCommons.command_string(string, null);
    }

    public static String command_string(String string, String string2) {
        FastbootRunner fastbootRunner = FastbootCommons.command_fast(string, string2, 6);
        if (fastbootRunner == null) {
            return "";
        }
        return fastbootRunner.getOutputString();
    }

    public static List<String> command_list(String string) {
        return FastbootCommons.command_list(string, null);
    }

    public static List<String> command_list(String string, String string2) {
        FastbootRunner fastbootRunner = FastbootCommons.command_fast(string, string2, 6);
        if (fastbootRunner == null) {
            return new ArrayList<String>();
        }
        return fastbootRunner.getOutputLines();
    }

    public static FastbootRunner command_fast(String string, String string2, int n) {
        FastbootRunner fastbootRunner = new FastbootRunner();
        if (string2 != null) {
            fastbootRunner.setDeviceSerial(string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group(1));
        }
        for (String string3 : arrayList) {
            fastbootRunner.addArgument(string3);
        }
        try {
            fastbootRunner.runWait(n);
        }
        catch (IOException iOException) {
            Log.error("Cannot execute fastboot command \"fastboot " + string + "\", reason: " + iOException.getMessage());
            return null;
        }
        return fastbootRunner;
    }

    public static List<String> devices() {
        return FastbootCommons.command_list("devices");
    }

    public static List<String> getvars(String string) {
        FastbootRunner fastbootRunner = FastbootCommons.command_fast("getvar all", string, 6);
        if (fastbootRunner == null) {
            return null;
        }
        if (fastbootRunner.getExitValue() != 0) {
            return null;
        }
        return fastbootRunner.getOutputLines();
    }

    public static String getvar(String string, String string2) {
        FastbootRunner fastbootRunner = FastbootCommons.command_fast("getvar " + string, string2, 6);
        if (fastbootRunner == null) {
            return null;
        }
        if (fastbootRunner.getExitValue() != 0) {
            return "";
        }
        return AdbUtils.parseFastbootVar(string, fastbootRunner.getOutputString());
    }

    public static List<String> oemDeviceInfo(String string) {
        return FastbootCommons.command_list("oem device-info", string);
    }

    public static List<String> oemLks(String string) {
        return FastbootCommons.command_list("oem lks", string);
    }

    public static String rebootBootloader(String string) {
        return FastbootCommons.command_string("reboot-bootloader", string);
    }

    public static String reboot(String string) {
        return FastbootCommons.command_string("reboot", string);
    }

    public static String oemEdl(String string) {
        return FastbootCommons.command_string("oem edl", string);
    }

    public static String flash(String string, File file, String string2) {
        String string3;
        try {
            string3 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string3 = file.getAbsolutePath();
        }
        FastbootRunner fastbootRunner = FastbootCommons.command_fast(string, 120, "flash", string2, string3);
        if (fastbootRunner == null) {
            return null;
        }
        String string4 = fastbootRunner.getOutputString();
        if (fastbootRunner.getExitValue() != 0) {
            if (string4 != null && (string4.toLowerCase().contains("anti-rollback") || string4.toLowerCase().contains("rollback version"))) {
                return "err:anti-rollback";
            }
            return null;
        }
        return string4;
    }

    public static YesNoMaybe oemUnlock(String string, String string2) {
        FastbootRunner fastbootRunner = FastbootCommons.command_fast(string, 12, "oem", "unlock", string2);
        if (fastbootRunner.getExitValue() != 0) {
            return YesNoMaybe.NO;
        }
        String string3 = fastbootRunner.getOutputString();
        if (string3.contains("OKAY") && !string3.contains("FAIL")) {
            return YesNoMaybe.YES;
        }
        return YesNoMaybe.MAYBE;
    }

    @NotNull
    private static FastbootRunner command_fast(String string, int n, String ... stringArray) {
        FastbootRunner fastbootRunner = new FastbootRunner();
        fastbootRunner.setDeviceSerial(string);
        for (String string2 : stringArray) {
            fastbootRunner.addArgument(string2);
        }
        try {
            fastbootRunner.runWait(n);
        }
        catch (IOException iOException) {
            return null;
        }
        int n2 = fastbootRunner.getExitValue();
        if (n2 == 0) {
            LAST_ERROR_MAP.put(string, null);
        } else {
            List<String> list = fastbootRunner.getOutputLines();
            String string3 = list != null && !list.isEmpty() ? list.get(list.size() - 1) : "unknown error";
            LAST_ERROR_MAP.put(string, string3);
        }
        return fastbootRunner;
    }

    public static String boot(String string, File file) {
        String string2;
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = file.getAbsolutePath();
        }
        FastbootRunner fastbootRunner = FastbootCommons.command_fast(string, 120, "boot", string2);
        return ProcessUtils.getOutput(fastbootRunner);
    }

    public static String flashDummy(String string) {
        Path path = ResourcesManager.getTmpPath().resolve("dummy_image.img");
        if (!Files.exists(path, new LinkOption[0])) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(path.toFile());){
                byte[] byArray = new byte[1024];
                for (int i = 0; i < 8; ++i) {
                    fileOutputStream.write(byArray);
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return FastbootCommons.flash(string, path.toFile(), "antirbpass");
    }

    public static boolean oemRebootRecovery(String string) {
        FastbootRunner fastbootRunner = FastbootCommons.command_fast(string, 5, "oem", "reboot-recovery");
        if (fastbootRunner == null || fastbootRunner.getExitValue() != 0) {
            return false;
        }
        String string2 = fastbootRunner.getOutputString();
        return string2 != null && !string2.toLowerCase().contains("fail");
    }

    public static String getLastError(String string) {
        return String.valueOf(LAST_ERROR_MAP.get(string));
    }
}

