/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.adb.device;

import com.xiaomitool.v2.adb.AdbCommons;
import com.xiaomitool.v2.adb.AdbException;
import com.xiaomitool.v2.adb.FastbootCommons;
import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.adb.device.DeviceAnswers;
import com.xiaomitool.v2.adb.device.DeviceProperties;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.utility.NotNull;
import com.xiaomitool.v2.utility.WaitSemaphore;
import com.xiaomitool.v2.utility.YesNoMaybe;
import com.xiaomitool.v2.utility.utils.ThreadUtils;

public class Device {
    private final DeviceProperties deviceProperties;
    private final WaitSemaphore deviceActiveSem = new WaitSemaphore();
    private final WaitSemaphore canBeAccessed = new WaitSemaphore(1, "can_be_accessed");
    private final DeviceAnswers deviceAnswers;
    private String serial;
    private Device$Status status;
    private boolean isConnected = true;
    private boolean firstOffline = true;

    public Device(String string) {
        this(string, Device$Status.UNKNOWN);
    }

    public Device(String string, String string2) {
        this(string, Device$Status.fromString(string2));
    }

    public Device(String string, Device$Status device$Status) {
        this(string, device$Status, false);
    }

    public Device(String string, Device$Status device$Status, boolean bl) {
        this.serial = string;
        this.deviceProperties = new DeviceProperties(this);
        this.deviceAnswers = new DeviceAnswers(this);
        this.setStatus(device$Status, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Device$Status device$Status, boolean bl) {
        try {
            this.obtainAccess();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        try {
            if (!device$Status.equals((Object)this.status)) {
                // empty if block
            }
            this.status = device$Status;
            Runnable runnable = () -> this.setStatusParse(device$Status);
            if (bl) {
                this.releaseAccess();
                try {
                    runnable.run();
                }
                finally {
                    this.requireAccess();
                }
            } else {
                new Thread(runnable).start();
            }
            this.getAnswers().updateStatus(device$Status);
        }
        finally {
            this.releaseAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setStatusParse(Device$Status device$Status) {
        DeviceProperties deviceProperties = this.deviceProperties;
        synchronized (deviceProperties) {
            if (Device$Status.FASTBOOT.equals((Object)device$Status) && !this.deviceProperties.getFastbootProperties().isParsed()) {
                ThreadUtils.sleepSilently(2000L);
                this.deviceProperties.getFastbootProperties().parse();
            } else if (Device$Status.SIDELOAD.equals((Object)device$Status)) {
                this.deviceProperties.getSideloadProperties().parse();
            } else if (Device$Status.DEVICE.equals((Object)device$Status)) {
                this.getAnswers().setNeedDeviceDebug(YesNoMaybe.NO);
                this.deviceProperties.getAdbProperties().parse();
            } else if (Device$Status.RECOVERY.equals((Object)device$Status)) {
                this.deviceProperties.getRecoveryProperties().parse();
            }
        }
    }

    public Device$Status getStatus() {
        return this.status;
    }

    public String getSerial() {
        return this.serial;
    }

    public void requireAccess() {
        try {
            this.canBeAccessed.waitOnce();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public void obtainAccess() {
        this.canBeAccessed.decrease();
    }

    public void releaseAccess() {
        this.canBeAccessed.increase();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean bl) {
        this.isConnected = bl;
        if (bl) {
            this.deviceActiveSem.setPermits(1);
        } else {
            this.deviceActiveSem.setPermits(0);
        }
    }

    public DeviceProperties getDeviceProperties() {
        return this.deviceProperties;
    }

    public boolean reboot(Device$Status device$Status) {
        return this.reboot(device$Status, false);
    }

    public boolean reboot(Device$Status device$Status, boolean bl) {
        return this.reboot(device$Status, bl, true);
    }

    private boolean reboot(Device$Status device$Status, boolean bl, boolean bl2) {
        this.requireAccessibile();
        if (!bl && device$Status.equals((Object)this.status)) {
            return true;
        }
        return this.rebootInternal(device$Status, bl2);
    }

    public boolean rebootNoWait(Device$Status device$Status, boolean bl) {
        return this.reboot(device$Status, bl, false);
    }

    public boolean rebootNoWait(Device$Status device$Status) {
        return this.rebootNoWait(device$Status, false);
    }

    private boolean rebootInternal(Device$Status device$Status, boolean bl) {
        this.deviceActiveSem.setPermits(0);
        if (Device$Status.FASTBOOT.equals((Object)this.status)) {
            return this.fastbootReboot(device$Status, bl);
        }
        return this.adbReboot(device$Status, bl);
    }

    private boolean fastbootReboot(Device$Status device$Status, boolean bl) {
        if (Device$Status.FASTBOOT.equals((Object)device$Status)) {
            FastbootCommons.rebootBootloader(this.serial);
            return !bl || this.rebootWait(device$Status);
        }
        if (Device$Status.EDL.equals((Object)device$Status)) {
            FastbootCommons.oemEdl(this.serial);
            return !bl || this.rebootWait(device$Status);
        }
        if ((Device$Status.SIDELOAD.equals((Object)device$Status) || Device$Status.RECOVERY.equals((Object)device$Status)) && FastbootCommons.oemRebootRecovery(this.serial)) {
            return !bl || this.rebootNoWait(device$Status);
        }
        if (!Device$Status.DEVICE.equals((Object)device$Status) && !bl) {
            throw new AdbException("Cannot reboot from fastboot to " + device$Status.toString() + " without waiting");
        }
        FastbootCommons.reboot(this.serial);
        if (!bl) {
            return true;
        }
        if (!this.rebootWait(Device$Status.DEVICE)) {
            return this.isConnected && device$Status.equals((Object)this.status);
        }
        return this.reboot(device$Status, false);
    }

    private boolean rebootWait(Device$Status device$Status) {
        try {
            Thread.sleep(1000L);
            this.deviceActiveSem.setPermits(0);
            this.firstOffline = true;
            return this.waitStatus(device$Status);
        }
        catch (InterruptedException interruptedException) {
            Log.warn("Thread interrupted (bad): " + interruptedException.getMessage());
            throw new AdbException("The reboot wait thread was interrupted: " + interruptedException.getMessage());
        }
    }

    private boolean adbReboot(Device$Status device$Status, boolean bl) {
        String string = device$Status.toString();
        if (Device$Status.FASTBOOT.equals((Object)device$Status)) {
            string = "bootloader";
        } else if (Device$Status.SIDELOAD.equals((Object)device$Status)) {
            string = Device$Status.RECOVERY.toString();
        }
        AdbCommons.reboot(this.serial, string);
        return !bl || this.rebootWait(device$Status);
    }

    public void requireAccessibile() {
        this.requireAccess();
        if (!this.isConnected) {
            throw new AdbException("The device cannot be managed right now: not connected");
        }
        if (!(Device$Status.FASTBOOT.equals((Object)this.status) || Device$Status.SIDELOAD.equals((Object)this.status) || Device$Status.RECOVERY.equals((Object)this.status) || Device$Status.DEVICE.equals((Object)this.status))) {
            throw new AdbException("The device cannot be managed right now: not accessibile status: " + this.status.toString());
        }
    }

    public boolean waitStatus(@NotNull Device$Status device$Status, int n) {
        if (!this.deviceActiveSem.waitOnce(Integer.max(0, n - 2))) {
            this.canBeAccessed.waitOnce(3);
            if (!this.deviceActiveSem.waitOnce(1)) {
                throw new AdbException("Waiting device active timed out");
            }
        }
        if (device$Status.equals((Object)this.status)) {
            return true;
        }
        if (device$Status.equals((Object)Device$Status.OFFLINE) && this.firstOffline) {
            this.setConnected(false);
            this.firstOffline = false;
            return this.waitStatus(device$Status, 7);
        }
        throw new AdbException("Waited for device status " + device$Status.toString() + ", got " + (this.status == null ? "null" : this.status.toString()));
    }

    public boolean waitStatus(@NotNull Device$Status device$Status) {
        switch (device$Status) {
            case DEVICE: {
                return this.waitStatus(device$Status, 80);
            }
            case FASTBOOT: {
                return this.waitStatus(device$Status, 13);
            }
            case SIDELOAD: {
                return this.waitStatus(device$Status, 40);
            }
            case RECOVERY: {
                return this.waitStatus(device$Status, 40);
            }
        }
        return this.waitStatus(device$Status, 120);
    }

    public boolean isTurnedOn() {
        return this.needAuthorization() || Device$Status.DEVICE.equals((Object)this.status);
    }

    public boolean needAuthorization() {
        return Device$Status.OFFLINE.equals((Object)this.status) || Device$Status.UNAUTHORIZED.equals((Object)this.status);
    }

    public Device$Status waitActive(int n) {
        try {
            this.deviceActiveSem.waitOnce(n);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return this.getStatus();
    }

    public DeviceAnswers getAnswers() {
        return this.deviceAnswers;
    }
}

