/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.adb.device;

import com.xiaomitool.v2.adb.AdbCommons;
import com.xiaomitool.v2.adb.device.Device;
import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.adb.device.DeviceGroups;
import com.xiaomitool.v2.adb.device.DeviceManager;
import com.xiaomitool.v2.adb.device.DeviceProperties;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.process.AdbRunner;
import com.xiaomitool.v2.rom.MiuiRom$Specie;
import com.xiaomitool.v2.utility.YesNoMaybe;
import com.xiaomitool.v2.utility.utils.StrUtils;
import com.xiaomitool.v2.utility.utils.ThreadUtils;
import com.xiaomitool.v2.xiaomi.miuithings.Branch;
import com.xiaomitool.v2.xiaomi.miuithings.MiuiVersion;
import com.xiaomitool.v2.xiaomi.miuithings.SerialNumber;
import com.xiaomitool.v2.xiaomi.miuithings.UnlockStatus;
import java.util.HashMap;

public class DeviceAnswers {
    public static final String HAS_TWRP = "has_twrp_recovery";
    public static final String HAS_STOCK_MIUI = "hasStockMiui";
    public static final String NEED_WIPE_DATA = "need_wipe_data";
    private static final String IS_MANUAL_MODE = "manualmode";
    private static final String NEED_DEVICE_DEBUG = "needdevicedebug";
    private final HashMap<String, YesNoMaybe> savedAnswers = new HashMap();
    private Device device;

    DeviceAnswers(Device device) {
        this.device = device;
    }

    public YesNoMaybe setAnswer(String string, YesNoMaybe yesNoMaybe) {
        this.savedAnswers.put(string, yesNoMaybe);
        return yesNoMaybe;
    }

    private synchronized YesNoMaybe isInTwrpRecoveryInternal() {
        if (Device$Status.OFFLINE.equals((Object)this.device.getStatus()) || !this.device.isConnected()) {
            ThreadUtils.sleepSilently(1000L);
            return YesNoMaybe.MAYBE;
        }
        if (!Device$Status.RECOVERY.equals((Object)this.device.getStatus())) {
            return YesNoMaybe.NO;
        }
        String string = StrUtils.randomWord(8).toLowerCase();
        String string2 = "xmt_rand";
        AdbRunner adbRunner = AdbCommons.runner("shell twrp set " + string2 + " " + string, this.device.getSerial(), 6);
        if (adbRunner.getExitValue() != 0) {
            return YesNoMaybe.MAYBE;
        }
        String string3 = adbRunner.getOutputString();
        if (string3 == null) {
            return YesNoMaybe.NO;
        }
        if (string3.toLowerCase().contains("twrp does not appear to be running")) {
            Log.warn("Twrp does not appear to be running");
            return YesNoMaybe.MAYBE;
        }
        adbRunner = AdbCommons.runner("shell twrp get " + string2, this.device.getSerial(), 6);
        if (adbRunner.getExitValue() != 0) {
            return YesNoMaybe.MAYBE;
        }
        String string4 = adbRunner.getOutputString();
        if (string4 == null) {
            return YesNoMaybe.NO;
        }
        return string3.contains(string) ? YesNoMaybe.YES : YesNoMaybe.NO;
    }

    public YesNoMaybe hasTwrpRecovery() {
        return this.getAnswer(HAS_TWRP);
    }

    public YesNoMaybe getAnswer(String string) {
        return this.savedAnswers.get(string);
    }

    public synchronized YesNoMaybe isInTwrpRecovery() {
        return this.setAnswer(HAS_TWRP, this.isInTwrpRecovery(3));
    }

    private YesNoMaybe isInTwrpRecovery(int n) {
        YesNoMaybe yesNoMaybe = this.isInTwrpRecoveryInternal();
        while (YesNoMaybe.MAYBE.equals((Object)yesNoMaybe) && --n > 0) {
            try {
                Thread.sleep(1500L);
                DeviceManager.waitRefresh();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            yesNoMaybe = this.isInTwrpRecoveryInternal();
        }
        Log.info("IsInTwrp recovery result: " + (Object)((Object)yesNoMaybe));
        if (YesNoMaybe.YES.equals((Object)yesNoMaybe)) {
            this.setAnswer(HAS_TWRP, YesNoMaybe.YES);
        }
        return yesNoMaybe;
    }

    public UnlockStatus getUnlockStatus() {
        String string = this.device.getDeviceProperties().getCodename(true);
        if (DeviceGroups.hasUnlockedBootloader(string)) {
            return UnlockStatus.UNLOCKED;
        }
        UnlockStatus unlockStatus = (UnlockStatus)((Object)this.device.getDeviceProperties().getFastbootProperties().get("xmt.lockstatus"));
        if (unlockStatus == null) {
            unlockStatus = (UnlockStatus)((Object)this.device.getDeviceProperties().getAdbProperties().get("xmt.lockstatus"));
        }
        return unlockStatus == null ? UnlockStatus.UNKNOWN : unlockStatus;
    }

    public YesNoMaybe isRebootManualMode() {
        return this.getAnswer(IS_MANUAL_MODE);
    }

    public void setRebootManualMode(YesNoMaybe yesNoMaybe) {
        this.setAnswer(IS_MANUAL_MODE, yesNoMaybe);
    }

    public YesNoMaybe isNeedDeviceDebug() {
        return this.getAnswer(NEED_DEVICE_DEBUG);
    }

    public void setNeedDeviceDebug(YesNoMaybe yesNoMaybe) {
        this.setAnswer(NEED_DEVICE_DEBUG, yesNoMaybe);
    }

    public MiuiRom$Specie getCurrentSpecie() {
        String string = this.device.getDeviceProperties().getCodename(false);
        MiuiVersion miuiVersion = MiuiVersion.fromObject(this.device.getDeviceProperties().get("ro.build.version.incremental"));
        Branch branch = miuiVersion == null ? Branch.DEVELOPER : miuiVersion.getBranch();
        branch = branch == null ? Branch.DEVELOPER : branch;
        return MiuiRom$Specie.fromStringBranch(string, branch);
    }

    public void updateStatus(Device$Status device$Status) {
        if (Device$Status.SIDELOAD.equals((Object)device$Status)) {
            this.setAnswer(HAS_TWRP, YesNoMaybe.NO);
        } else if (Device$Status.DEVICE.equals((Object)device$Status)) {
            if (YesNoMaybe.YES.equals((Object)this.getAnswer(HAS_STOCK_MIUI)) && YesNoMaybe.YES.equals((Object)this.hasTwrpRecovery())) {
                this.setAnswer(HAS_TWRP, YesNoMaybe.MAYBE);
            }
            this.setNeedDeviceDebug(YesNoMaybe.NO);
        } else if (Device$Status.UNAUTHORIZED.equals((Object)device$Status)) {
            this.setNeedDeviceDebug(YesNoMaybe.NO);
        }
    }

    public SerialNumber getSerialNumber() {
        DeviceProperties deviceProperties = this.device.getDeviceProperties();
        SerialNumber serialNumber = (SerialNumber)deviceProperties.getSideloadProperties().get("xmt.serial_number");
        if (serialNumber != null && serialNumber.isValid()) {
            return serialNumber;
        }
        serialNumber = (SerialNumber)deviceProperties.getAdbProperties().get("xmt.serial_number");
        if (serialNumber != null && serialNumber.isValid()) {
            return serialNumber;
        }
        serialNumber = (SerialNumber)deviceProperties.getFastbootProperties().get("xmt.serial_number");
        return serialNumber;
    }

    public YesNoMaybe isTwrpDataEncrypted() {
        return this.isTwrpDataEncrypted(false);
    }

    private YesNoMaybe isTwrpDataEncrypted(boolean bl) {
        String[] stringArray;
        if (bl) {
            AdbCommons.adb_shell("twrp mount data", this.device.getSerial(), 5);
        }
        String string = AdbCommons.adb_shell("(ls -l /data || echo no_line_first) && (ls -l /sdcard || echo no_line_again)", this.device.getSerial(), 4);
        boolean bl2 = false;
        boolean bl3 = false;
        if (string == null) {
            return YesNoMaybe.MAYBE;
        }
        string = string.trim();
        for (String string2 : stringArray = string.split("\n")) {
            if (string2.contains("no_line_first")) {
                bl2 = true;
                continue;
            }
            if (!string2.contains("no_line_again")) continue;
            bl3 = true;
        }
        if (bl2 && bl3) {
            if (bl) {
                return YesNoMaybe.MAYBE;
            }
            return this.isTwrpDataEncrypted(true);
        }
        int n = stringArray.length;
        if (bl2 || bl3) {
            --n;
        }
        if (n == 0) {
            return YesNoMaybe.YES;
        }
        if (n > 3) {
            return YesNoMaybe.NO;
        }
        return YesNoMaybe.MAYBE;
    }

    public YesNoMaybe isWipeDataNeeded() {
        if ("unencrypted".equalsIgnoreCase((String)this.device.getDeviceProperties().getAdbProperties().get("ro.crypto.state"))) {
            return YesNoMaybe.NO;
        }
        return this.getAnswer(NEED_WIPE_DATA);
    }
}

