/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.adb.device;

import com.xiaomitool.v2.xiaomi.a.b;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class DeviceGroups {
    private static final HashSet<String> ALWAYS_UNLOCKED_DEVICES = DeviceGroups.getAlwaysUnlockedSet();
    private static final HashSet<String> EEA_REGION_DEVICES = DeviceGroups.getEeaRegionDevices();
    private static final HashSet<String> ANDROID_ONE_DEVICES = DeviceGroups.getAndroidOneDevices();
    private static final HashSet<String> RECOVERY_SAFE = DeviceGroups.getRecoverySafeDevices();
    private static final HashSet<String> BIREGION_DEVICES = DeviceGroups.getBiRegionDevices();
    private static final HashSet<String> ADD_EEA_REGION_DEVICES = new HashSet();
    private static final Pattern CODENAME_STRIPPER = Pattern.compile("^([a-z]+(_xhdpi|_sprout)?)((_[a-z]+)*_global)*$", 2);

    public static void init() {
        JSONObject jSONObject = b.a();
        for (String string : jSONObject.keySet()) {
            if (!string.contains("_eea")) continue;
            ADD_EEA_REGION_DEVICES.add(DeviceGroups.stripCodename(string));
        }
    }

    public static boolean isMultiRegionDevice(String string) {
        return !BIREGION_DEVICES.contains(string = DeviceGroups.stripCodename(string));
    }

    public static boolean isSafeToChangeRecoveryLocked(String string) {
        string = DeviceGroups.stripCodename(string);
        for (String string2 : RECOVERY_SAFE) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static HashSet<String> getBiRegionDevices() {
        return DeviceGroups.hashSet("perseus", "prada", "dior", "nikel", "mocha", "lotus", "aries", "hydrogen", "vince", "aqua", "lithium", "mido", "ugg", "taurus", "leo", "riva", "ugglite", "beryllium", "hermes", "kenzo", "tiffany", "oxygen", "ursa", "clover", "ferrari", "scorpio", "omega", "gemini", "capricorn", "ido", "rolex", "gucci", "natrium", "sagit", "latte", "sirius", "hennessy", "tissot", "libra", "land", "hammerhead", "wayne", "santoni", "equuleus", "nitrogen", "markw", "cancro", "pisces", "helium", "virgo", "cappu", "chiron", "jason", "mione", "meri", "armani");
    }

    private static HashSet<String> getRecoverySafeDevices() {
        return DeviceGroups.hashSet("prada", "dior", "nikel", "mocha", "lotus", "aries", "hydrogen", "aqua", "lithium", "mido", "taurus", "leo", "hermes", "kenzo", "tiffany", "oxygen", "ferrari", "scorpio", "omega", "gemini", "capricorn", "ido", "rolex", "gucci", "natrium", "sagit", "latte", "hennessy", "tissot", "libra", "land", "hammerhead", "santoni", "markw", "cancro", "pisces", "helium", "virgo", "cappu", "chiron", "jason", "mione", "meri", "armani");
    }

    private static HashSet<String> getAndroidOneDevices() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("tiare");
        hashSet.add("tissot_sprout");
        hashSet.add("jasmine_sprout");
        return hashSet;
    }

    private static HashSet<String> getEeaRegionDevices() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("cepheus");
        return hashSet;
    }

    private static HashSet<String> hashSet(String ... stringArray) {
        return new HashSet<String>(Arrays.asList(stringArray));
    }

    private static HashSet<String> getAlwaysUnlockedSet() {
        return DeviceGroups.hashSet("mione_plus", "aries", "taurus", "pisces", "HM2013022", "HM2013023", "cancro", "armani", "lcsh92_wet_tdd", "lcsh92_wet_jb9", "HM2014011", "mocha", "hammerhead", "dior", "HM2014501", "lte26007", "virgo", "wt86047", "wt88047", "gucci", "ferrari", "hermes", "latte");
    }

    private static String stripCodenamePro(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = CODENAME_STRIPPER.matcher(string = string.replace("_alpha", ""));
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    public static String stripCodename(String string) {
        if (string == null) {
            return null;
        }
        String string2 = DeviceGroups.stripCodenamePro(string);
        if (string2 != null) {
            return string2;
        }
        return string.replace("_eea_global", "").replace("_ru_global", "").replace("_india_global", "").replace("_global", "").replace("_alpha", "");
    }

    public static boolean hasUnlockedBootloader(String string) {
        if (string == null) {
            return false;
        }
        return ALWAYS_UNLOCKED_DEVICES.contains(DeviceGroups.stripCodename(string));
    }

    public static boolean hasEEARegion(String string) {
        if (string == null) {
            return false;
        }
        return EEA_REGION_DEVICES.contains(string = DeviceGroups.stripCodename(string)) || ADD_EEA_REGION_DEVICES.contains(string);
    }

    public static boolean isAndroidOneDevice(String string) {
        if (string == null) {
            return false;
        }
        return (string = DeviceGroups.stripCodename(string)).contains("_sprout") || ANDROID_ONE_DEVICES.contains(string);
    }
}

