/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.adb.device;

import com.xiaomitool.v2.adb.AdbCommunication;
import com.xiaomitool.v2.adb.device.Device;
import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.utility.MessageReceiver;
import com.xiaomitool.v2.utility.Pair;
import com.xiaomitool.v2.utility.WaitSemaphore;
import com.xiaomitool.v2.utility.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javafx.application.Platform;

public class DeviceManager {
    private static final HashMap<String, Device$Status> updatingDevices = new HashMap();
    private static final ArrayList<WaitSemaphore> refreshWaitSems = new ArrayList();
    private static final Integer BLOCKING_OBJ = 0;
    private static Device selectedDevice = null;
    private static HashMap<String, Device> deviceMap = new HashMap();
    private static HashSet<MessageReceiver> messageReceivers = new HashSet();
    private static Thread refreshingThread = null;

    public static void initScanThreads() {
        AdbCommunication.registerAutoScanDevices();
    }

    public static void stopScanThreads() {
        AdbCommunication.unregisterAutoScanDevices();
    }

    public static void addDevice(Device device) {
        deviceMap.put(device.getSerial(), device);
    }

    public static Device getSelectedDevice() {
        return selectedDevice;
    }

    public static void setSelectedDevice(Device device) {
        selectedDevice = device;
        if (device != null) {
            Platform.runLater(() -> WindowManager.toast(LRes.SELECTED_DEVICE.toString(device.getSerial())));
        }
    }

    public static void setSelectedDevice(String string) {
        DeviceManager.setSelectedDevice(deviceMap.get(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitRefresh() {
        if (!AdbCommunication.isAutoScanRegistered()) {
            DeviceManager.refresh(true);
            return;
        }
        if (Thread.currentThread().equals(refreshingThread)) {
            return;
        }
        WaitSemaphore waitSemaphore = new WaitSemaphore(0);
        ArrayList<WaitSemaphore> arrayList = refreshWaitSems;
        synchronized (arrayList) {
            refreshWaitSems.add(waitSemaphore);
        }
        waitSemaphore.waitOnce();
    }

    public static void refresh(boolean bl) {
        if (bl) {
            DeviceManager.refreshBlocking();
        } else {
            DeviceManager.refreshInternal(false);
        }
    }

    private static synchronized void refreshBlocking() {
        DeviceManager.refreshInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshInternal(boolean bl) {
        ArrayList<Pair<String, Device$Status>> arrayList;
        ArrayList<WaitSemaphore> arrayList2 = updatingDevices;
        synchronized (arrayList2) {
            refreshingThread = Thread.currentThread();
            updatingDevices.clear();
            AdbCommunication.refreshDevices(updatingDevices);
            for (Map.Entry<String, Device$Status> entry : updatingDevices.entrySet()) {
                Log.info("Connected device: " + entry.getKey() + " -> " + (Object)((Object)entry.getValue()));
            }
            for (Device device : deviceMap.values()) {
                if (Device$Status.EDL.equals((Object)device.getStatus()) || updatingDevices.get(device.getSerial()) != null) continue;
                device.setConnected(false);
            }
            arrayList = new ArrayList<Pair<String, Device$Status>>(updatingDevices.size());
            for (Map.Entry<String, Device$Status> entry : updatingDevices.entrySet()) {
                arrayList.add(new Pair<String, Device$Status>(entry.getKey(), entry.getValue()));
            }
        }
        for (Pair pair : arrayList) {
            DeviceManager.setDeviceStatus((String)pair.getFirst(), (Device$Status)((Object)pair.getSecond()), bl);
        }
        arrayList2 = refreshWaitSems;
        synchronized (arrayList2) {
            for (WaitSemaphore waitSemaphore : refreshWaitSems) {
                waitSemaphore.increase();
            }
            refreshWaitSems.clear();
        }
        refreshingThread = null;
    }

    public static int count() {
        int n = 0;
        for (Device device : deviceMap.values()) {
            if (!device.isConnected()) continue;
            ++n;
        }
        return n;
    }

    public static int count(Device$Status ... device$StatusArray) {
        if (device$StatusArray == null || device$StatusArray.length == 0) {
            return DeviceManager.count();
        }
        int n = 0;
        for (Device device : deviceMap.values()) {
            if (!device.isConnected() || !ArrayUtils.in(device$StatusArray, device.getStatus())) continue;
            ++n;
        }
        return n;
    }

    protected static void setDeviceStatus(String string, Device$Status device$Status, boolean bl) {
        boolean bl2;
        Device device = deviceMap.get(string);
        if (device == null) {
            device = new Device(string, device$Status, true);
            deviceMap.put(string, device);
            DeviceManager.message(-3);
        }
        boolean bl3 = bl2 = !device$Status.equals((Object)device.getStatus());
        if (bl2) {
            DeviceManager.message(-2);
        }
        device.setStatus(device$Status, bl);
        device.setConnected(true);
        if (bl2) {
            DeviceManager.message(-4);
        }
    }

    public static Device getFirstDevice() {
        if (deviceMap.size() == 0) {
            return null;
        }
        return deviceMap.entrySet().iterator().next().getValue();
    }

    private static void message(int n) {
        for (MessageReceiver messageReceiver : messageReceivers) {
            messageReceiver.message(n);
        }
    }

    public static Collection<Device> getDevices() {
        return deviceMap.values();
    }

    public static void addMessageReceiver(MessageReceiver messageReceiver) {
        messageReceivers.add(messageReceiver);
    }

    public static void removeMessageReceiver(MessageReceiver messageReceiver) {
        messageReceivers.remove(messageReceiver);
    }
}

