/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.engine;

import com.xiaomitool.v2.engine.ToolManager$1;
import com.xiaomitool.v2.engine.ToolManager$2;
import com.xiaomitool.v2.engine.ToolManager$3;
import com.xiaomitool.v2.engine.ToolManager$4;
import com.xiaomitool.v2.engine.ToolManager$5;
import com.xiaomitool.v2.engine.actions.ActionsStatic;
import com.xiaomitool.v2.gui.GuiUtils;
import com.xiaomitool.v2.gui.SplashScreen;
import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.drawable.DrawableManager;
import com.xiaomitool.v2.language.Lang;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.logging.feedback.LiveFeedbackEasy;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.resources.ResourcesManager;
import com.xiaomitool.v2.utility.RunnableMessage;
import com.xiaomitool.v2.utility.utils.CookieUtils;
import com.xiaomitool.v2.utility.utils.MutexUtils;
import com.xiaomitool.v2.utility.utils.SettingsUtils;
import com.xiaomitool.v2.utility.utils.StrUtils;
import com.xiaomitool.v2.utility.utils.UpdateUtils;
import com.xiaomitool.v2.xiaomi.b;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.json.JSONException;
import org.json.JSONObject;

public class ToolManager {
    public static final String TOOL_VERSION = "20.7.28";
    public static final String URL_DONATION = "https://www.xiaomitool.com/V2/donate";
    public static final String TOOL_VERSION_EX = "beta";
    public static final String XMT_HOST = "https://www.xiaomitool.com/V2";
    public static final String URL_UPDATE_V2 = "https://www.xiaomitool.com/V2/updateV2.php";
    public static final String URL_LATEST = "https://www.xiaomitool.com/V2/latest";
    public static final boolean DEBUG_MODE = false;
    private static boolean exiting = false;
    private static final List<Stage> activeStages = new ArrayList<Stage>();
    private static String runningInstanceId = null;
    private static RunnableMessage ON_BEFORE_CLOSE = null;
    private static final RunnableMessage ASK_FEEDBACK = new ToolManager$1();

    public static String getFeedbackUrl() {
        return "https://www.xiaomitool.com/V2/feedback";
    }

    public static void init(Stage stage, String[] stringArray) {
        if (UpdateUtils.checkUpdateKillMe(stringArray)) {
            System.exit(0);
            return;
        }
        SplashScreen splashScreen = new SplashScreen("XiaoMiTool V2", DrawableManager.getResourceImage("splash.png"));
        WindowManager.runNowOrLater(() -> splashScreen.start(new Stage()));
        if (!ResourcesManager.init()) {
            Log.error("Failed to init resources dir");
        }
        Log.init();
        boolean bl = MutexUtils.lock();
        if (!bl) {
            ToolManager.exit(1);
            return;
        }
        CookieUtils.requireModdedCookieHandler();
        SettingsUtils.load();
        ActionsStatic.LOAD_ONLINE_LANGS(XMT_HOST).run();
        GuiUtils.init();
        ToolManager.checkLoadSession();
        Lang.load();
        Log.info("Starting XiaoMiTool V2 20.7.28 : " + ResourcesConst.getLogString());
        WindowManager.runNowOrLater(() -> WindowManager.launchMain(stage, new ToolManager$2()));
    }

    public static void showStage(Stage stage) {
        if (stage == null) {
            return;
        }
        activeStages.add(stage);
        SplashScreen splashScreen = SplashScreen.getInstance();
        if (splashScreen != null) {
            splashScreen.stopSplash();
        }
        stage.show();
        stage.requestFocus();
    }

    public static void closeStage(Stage stage) {
        if (stage == null) {
            return;
        }
        activeStages.remove(stage);
        stage.close();
    }

    public static synchronized void exit(int n) {
        if (exiting) {
            return;
        }
        exiting = true;
        LiveFeedbackEasy.sendClose();
        ToolManager.saveOptions();
        LiveFeedbackEasy.runOnFeedbackSent(() -> {
            for (Stage stage : activeStages) {
                Platform.runLater((Runnable)new ToolManager$3(stage));
            }
            Log.closeLogFile();
            MutexUtils.unlock();
            Platform.runLater((Runnable)new ToolManager$4());
            System.exit(n);
        }, Platform.isFxApplicationThread());
    }

    private static void saveOptions() {
        ToolManager.checkSaveSession();
        SettingsUtils.save();
    }

    private static void checkSaveSession() {
        String string;
        String string2 = b.c().h();
        if (string2 != null) {
            SettingsUtils.saveOpt("pcId", string2);
        }
        if (!"true".equals(string = SettingsUtils.getOpt("pref_save_session"))) {
            SettingsUtils.saveOpt("session_token", "null");
            return;
        }
        String string3 = b.c().i();
        if (string3 == null) {
            SettingsUtils.saveOpt("session_token", "null");
            return;
        }
        SettingsUtils.saveOptEncrpyted("session_token", string3);
    }

    private static void checkLoadSession() {
        String string;
        String string2 = SettingsUtils.requirePCId();
        if (string2 != null) {
            b.c().a(string2);
        }
        if (!"true".equals(string = SettingsUtils.getOpt("pref_save_session"))) {
            return;
        }
        String string3 = SettingsUtils.getOptDecrypted("session_token");
        if (string3 == null) {
            Log.warn("Failed to load old session token");
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string3);
            b.c().a(jSONObject);
            Platform.runLater((Runnable)new ToolManager$5());
        }
        catch (JSONException jSONException) {
            Log.warn("Failed to parse old session token: " + jSONException.getMessage());
        }
    }

    public static String getRunningInstanceId() {
        if (runningInstanceId == null) {
            runningInstanceId = StrUtils.randomWord(16);
        }
        return runningInstanceId;
    }

    public static void setOnExitAskForFeedback(boolean bl) {
        ON_BEFORE_CLOSE = bl ? ASK_FEEDBACK : null;
    }

    static /* synthetic */ RunnableMessage access$000() {
        return ON_BEFORE_CLOSE;
    }
}

