/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.engine.actions;

import com.xiaomitool.v2.adb.AdbException;
import com.xiaomitool.v2.adb.device.Device;
import com.xiaomitool.v2.adb.device.Device$Status;
import com.xiaomitool.v2.adb.device.DeviceManager;
import com.xiaomitool.v2.engine.actions.ActionsDynamic$1;
import com.xiaomitool.v2.engine.actions.ActionsDynamic$2;
import com.xiaomitool.v2.engine.actions.ActionsDynamic$3;
import com.xiaomitool.v2.engine.actions.ActionsDynamic$4;
import com.xiaomitool.v2.engine.actions.ActionsDynamic$5;
import com.xiaomitool.v2.engine.actions.ActionsDynamic$6;
import com.xiaomitool.v2.engine.actions.ActionsDynamic$7;
import com.xiaomitool.v2.engine.actions.ActionsStatic;
import com.xiaomitool.v2.engine.actions.ActionsUtil;
import com.xiaomitool.v2.gui.GuiUtils;
import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.deviceView.DeviceFastbootView;
import com.xiaomitool.v2.gui.deviceView.DeviceRecoveryView;
import com.xiaomitool.v2.gui.deviceView.DeviceView;
import com.xiaomitool.v2.gui.drawable.DrawableManager;
import com.xiaomitool.v2.gui.other.DeviceTableEntry;
import com.xiaomitool.v2.gui.visual.ButtonPane;
import com.xiaomitool.v2.gui.visual.IDClickReceiver;
import com.xiaomitool.v2.gui.visual.LoadingAnimation;
import com.xiaomitool.v2.gui.visual.RegularTable;
import com.xiaomitool.v2.gui.visual.SidePane;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.logging.Log;
import com.xiaomitool.v2.procedure.ProcedureRunner;
import com.xiaomitool.v2.procedure.RInstall;
import com.xiaomitool.v2.resources.ResourcesConst;
import com.xiaomitool.v2.resources.ResourcesManager;
import com.xiaomitool.v2.utility.DriverUtils;
import com.xiaomitool.v2.utility.Pointer;
import com.xiaomitool.v2.utility.RunnableMessage;
import com.xiaomitool.v2.utility.YesNoMaybe;
import com.xiaomitool.v2.utility.utils.ArrayUtils;
import java.io.IOException;
import java.util.HashMap;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Border;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;

public class ActionsDynamic {
    public static RunnableMessage MAIN_SCREEN_LOADING() {
        return ActionsDynamic.MAIN_SCREEN_LOADING(LRes.LOADING);
    }

    public static RunnableMessage MAIN_SCREEN_LOADING(LRes lRes) {
        return ActionsDynamic.MAIN_SCREEN_LOADING(lRes.toString());
    }

    public static RunnableMessage MAIN_SCREEN_LOADING(String string) {
        return new ActionsDynamic$1(string);
    }

    public static RunnableMessage SEARCH_SELECT_DEVICES(Device$Status ... device$StatusArray) {
        return () -> {
            RunnableMessage runnableMessage;
            Log.info("Searching at least one device");
            ActionsDynamic.MAIN_SCREEN_LOADING(LRes.SEARCHING_CONNECTED_DEVICES).run();
            DeviceManager.refresh(true);
            Thread.sleep(1000L);
            int n = DeviceManager.count(device$StatusArray);
            Log.info("Total connected device found: " + n);
            if (n == 0) {
                if (ResourcesConst.isWindows()) {
                    new Thread(() -> {
                        try {
                            DriverUtils.fixAndroidDevices(ResourcesManager.getAndroidDriverPath());
                        }
                        catch (IOException iOException) {
                            Log.error("Cannot try to fix drivers: " + iOException.getMessage());
                        }
                    }).start();
                }
                runnableMessage = ActionsDynamic.NO_DEVICE_CONNECTED(device$StatusArray);
            } else {
                runnableMessage = ActionsDynamic.SELECT_DEVICE(device$StatusArray);
            }
            return runnableMessage.run();
        };
    }

    public static RunnableMessage NO_DEVICE_CONNECTED(Device$Status ... device$StatusArray) {
        return () -> {
            LRes lRes;
            String string;
            Device$Status device$Status;
            Log.info("Showing no devices visual");
            RunnableMessage runnableMessage = null;
            Device$Status device$Status2 = device$Status = device$StatusArray == null || device$StatusArray.length == 0 ? null : device$StatusArray[0];
            if (device$Status == null) {
                device$Status = Device$Status.DEVICE;
            }
            switch (device$Status) {
                case SIDELOAD: 
                case RECOVERY: {
                    string = LRes.NO_DEVICE_CONNECTED_MODE.toString(Device$Status.RECOVERY.toString(), Device$Status.RECOVERY.toString());
                    lRes = LRes.HT_GO_RECOVERY;
                    runnableMessage = ActionsDynamic.HOWTO_GO_RECOVERY(null);
                    break;
                }
                case FASTBOOT: {
                    string = LRes.NO_DEVICE_CONNECTED_MODE.toString(Device$Status.FASTBOOT.toString(), Device$Status.FASTBOOT.toString());
                    lRes = LRes.HT_GO_FASTBOOT;
                    runnableMessage = ActionsDynamic.HOWTO_GO_FASTBOOT(null, false);
                    break;
                }
                default: {
                    string = LRes.NO_DEVICE_CONNECTED.toString();
                    lRes = LRes.HT_ENABLE_USB_DEBUG;
                    runnableMessage = ActionsDynamic.HOW_TO_ENABLE_USB_DEBUGGING(null, DeviceManager.getDevices().isEmpty());
                }
            }
            ButtonPane buttonPane = new ButtonPane(LRes.SEARCH_AGAIN, lRes);
            ImageView imageView = new ImageView(new Image(DrawableManager.getPng("no_connection.png").toString()));
            imageView.setFitHeight(200.0);
            imageView.setPreserveRatio(true);
            Text text = new Text(string);
            text.setTextAlignment(TextAlignment.CENTER);
            text.setFont(Font.font((double)16.0));
            text.setWrappingWidth(WindowManager.getContentWidth() - 80.0);
            VBox vBox = new VBox(new Node[]{imageView, text});
            vBox.setAlignment(Pos.CENTER);
            vBox.setSpacing(20.0);
            buttonPane.setContent((Node)vBox);
            WindowManager.setMainContent((Node)buttonPane, false);
            DeviceManager.addMessageReceiver(buttonPane.getIdClickReceiver());
            int n = -100;
            while ((n != -3 || DeviceManager.count(device$StatusArray) == 0) && n < 0) {
                n = buttonPane.waitClick();
                if (n <= 0 || runnableMessage == null || (n = runnableMessage.run()) != 0) continue;
                n = -100;
            }
            WindowManager.removeTopContent();
            DeviceManager.removeMessageReceiver(buttonPane.getIdClickReceiver());
            return ActionsDynamic.SEARCH_SELECT_DEVICES(device$StatusArray).run();
        };
    }

    public static RunnableMessage SELECT_DEVICE(Device$Status ... device$StatusArray) {
        return () -> {
            Log.info("Displaying found devices to choose");
            ActionsDynamic$2 actionsDynamic$2 = new ActionsDynamic$2();
            TableColumn tableColumn = new TableColumn(LRes.SERIAL.toString());
            TableColumn tableColumn2 = new TableColumn(LRes.STATUS.toString());
            TableColumn tableColumn3 = new TableColumn(LRes.CODENAME.toString());
            TableColumn tableColumn4 = new TableColumn(LRes.BRAND.toString());
            TableColumn tableColumn5 = new TableColumn(LRes.MODEL.toString());
            tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("serial"));
            tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("status"));
            tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("codename"));
            tableColumn4.setCellValueFactory((Callback)new PropertyValueFactory("brand"));
            tableColumn5.setCellValueFactory((Callback)new PropertyValueFactory("model"));
            actionsDynamic$2.getColumns().addAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3, tableColumn4, tableColumn5});
            ObservableList observableList = actionsDynamic$2.getItems();
            for (Device object2 : DeviceManager.getDevices()) {
                if (device$StatusArray != null && device$StatusArray.length > 0 && !ArrayUtils.in(device$StatusArray, object2.getStatus())) continue;
                DeviceTableEntry deviceTableEntry = new DeviceTableEntry(object2);
                observableList.add((Object)deviceTableEntry);
            }
            actionsDynamic$2.getSelectionModel().select(0);
            ButtonPane buttonPane = new ButtonPane(LRes.SELECT, LRes.SEARCH_AGAIN);
            actionsDynamic$2.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
            for (DeviceTableEntry deviceTableEntry : actionsDynamic$2.getColumns()) {
                deviceTableEntry.setPrefWidth(120.0);
                deviceTableEntry.setSortable(false);
            }
            actionsDynamic$2.setPrefSize(600.0, 400.0);
            actionsDynamic$2.setEditable(false);
            String string = "ffa970";
            actionsDynamic$2.setStyle("-fx-focus-color: #C8C8C8;\n-fx-faint-focus-color: #C8C8C8;\n-fx-selection-bar: #" + string + "; -fx-selection-bar-non-focused: #" + string + ";");
            actionsDynamic$2.setBorder(Border.EMPTY);
            buttonPane.setContent((Node)GuiUtils.center((Node)actionsDynamic$2));
            WindowManager.setMainContent((Node)buttonPane, true);
            int n = -100;
            DeviceManager.addMessageReceiver(buttonPane.getIdClickReceiver());
            boolean bl = false;
            while (n == -100) {
                n = buttonPane.waitClick();
                if (n == -3) {
                    bl = true;
                } else if (bl && n == -4) {
                    observableList.clear();
                    for (Device device : DeviceManager.getDevices()) {
                        if (device$StatusArray != null && !ArrayUtils.in(device$StatusArray, device.getStatus())) continue;
                        DeviceTableEntry deviceTableEntry = new DeviceTableEntry(device);
                        observableList.add((Object)deviceTableEntry);
                    }
                    actionsDynamic$2.getSelectionModel().select(0);
                    bl = false;
                }
                if (n < 0) {
                    n = -100;
                }
                if (n != 0) continue;
                DeviceTableEntry deviceTableEntry = (DeviceTableEntry)actionsDynamic$2.getSelectionModel().getSelectedItem();
                if (deviceTableEntry == null) {
                    n = -100;
                    continue;
                }
                DeviceManager.setSelectedDevice(deviceTableEntry.getSerial());
                if (DeviceManager.getSelectedDevice() != null) continue;
                n = -100;
            }
            return n == 0 ? 0 : ActionsDynamic.SEARCH_SELECT_DEVICES(device$StatusArray).run();
        };
    }

    public static RunnableMessage REQUIRE_DEVICE_ON(Device device) {
        return () -> {
            Log.info("Rebooting and expecting device " + device.getSerial() + " turned on with usb debug enabled, auth and connected");
            if (!device.isTurnedOn()) {
                ActionsDynamic.REBOOT_DEVICE(device, Device$Status.DEVICE, false).run();
                ActionsDynamic.WAIT_USB_DEBUG_ENABLE(device).run();
            }
            ActionsDynamic.REQUIRE_DEVICE_AUTH(device).run();
            ActionsDynamic.REQUIRE_DEVICE_CONNECTED(device).run();
            return 0;
        };
    }

    public static RunnableMessage REQUIRE_DEVICE_CONNECTED(Device device) {
        return () -> {
            Log.info("Expecting device connected to the pc");
            if (device.isConnected()) {
                return 0;
            }
            Log.warn("It is not, please connect device to the pc");
            ButtonPane buttonPane = new ButtonPane(LRes.TRY_AGAIN);
            ImageView imageView = new ImageView(new Image(DrawableManager.getPng("no_connection.png").toString()));
            imageView.setFitHeight(200.0);
            imageView.setPreserveRatio(true);
            Text text = new Text(LRes.DEVICE_NOT_CONNECTED.toString());
            text.setTextAlignment(TextAlignment.CENTER);
            text.setFont(Font.font((double)16.0));
            text.setWrappingWidth(600.0);
            VBox vBox = new VBox(new Node[]{imageView, text});
            vBox.setAlignment(Pos.CENTER);
            vBox.setSpacing(20.0);
            buttonPane.setContent((Node)vBox);
            WindowManager.setMainContent((Node)buttonPane, false);
            IDClickReceiver iDClickReceiver = buttonPane.getIdClickReceiver();
            DeviceManager.addMessageReceiver(iDClickReceiver);
            int n = -100;
            while (!(n != -100 || (n = buttonPane.waitClick()) == -4 && device.isConnected())) {
                if (n == 0) {
                    ActionsDynamic.MAIN_SCREEN_LOADING(LRes.SEARCHING_CONNECTED_DEVICES).run();
                    ActionsStatic.RESTART_ADB_SERVER().run();
                    WindowManager.removeTopContent();
                    if (device.isConnected()) break;
                }
                n = -100;
            }
            DeviceManager.removeMessageReceiver(iDClickReceiver);
            WindowManager.removeTopContent();
            return 1;
        };
    }

    public static RunnableMessage WAIT_USB_DEBUG_ENABLE(Device device) {
        return ActionsDynamic.WAIT_USB_DEBUG_ENABLE(device, null);
    }

    public static RunnableMessage WAIT_USB_DEBUG_ENABLE(Device device, String string) {
        return () -> {
            Log.info("Waiting for device usb connection");
            ButtonPane buttonPane = new ButtonPane(LRes.HT_ENABLE_USB_DEBUG, LRes.SEARCH_AGAIN);
            buttonPane.setContentText(LRes.WAITING_USB_ENABLE.toString(new Object[]{LRes.SEARCH_AGAIN}));
            WindowManager.setMainContent((Node)buttonPane, false);
            IDClickReceiver iDClickReceiver = buttonPane.getIdClickReceiver();
            DeviceManager.addMessageReceiver(iDClickReceiver);
            int n = -100;
            while (!(n != -100 || (n = iDClickReceiver.waitClick()) == -4 && device.isTurnedOn())) {
                if (n == 1) {
                    ActionsStatic.RESTART_ADB_SERVER().run();
                    WindowManager.removeTopContent();
                    if (device.isTurnedOn() || Device$Status.UNAUTHORIZED.equals((Object)device.getStatus())) {
                        break;
                    }
                } else if (n == 0 && ActionsDynamic.HOW_TO_ENABLE_USB_DEBUGGING(device, true).run() > 0 && (device.isTurnedOn() || Device$Status.UNAUTHORIZED.equals((Object)device.getStatus()))) break;
                n = -100;
            }
            WindowManager.removeTopContent();
            DeviceManager.removeMessageReceiver(iDClickReceiver);
            return 0;
        };
    }

    public static RunnableMessage REBOOT_STOCK_RECOVERY(Device device, boolean bl) {
        return new ActionsDynamic$3(device, bl);
    }

    public static RunnableMessage FIND_DEVICE_INFO(Device device) {
        return () -> {
            ActionsStatic.REQUIRE_FIXANDROID().run();
            device.getAnswers().setAnswer("has_twrp_recovery", YesNoMaybe.MAYBE);
            device.getDeviceProperties().getRecoveryProperties().reset();
            Log.info("Starting find_device_info visual procedure");
            Text[] textArray = new Text[10];
            Text[] textArray2 = new Text[10];
            LRes[] lResArray = new LRes[]{LRes.SERIAL, LRes.BRAND, LRes.MODEL, LRes.CODENAME, LRes.MIUI_VERSION, LRes.ANDROID_VERSION, LRes.SERIAL_NUMBER, LRes.BOOTLOADER_STATUS, LRes.FASTBOOT_PARSED, LRes.RECOVERY_PARSED};
            for (int i = 0; i < lResArray.length; ++i) {
                textArray[i] = new Text();
                textArray2[i] = new Text();
                textArray[i].setFont(Font.font((double)14.0));
                textArray2[i].setFont(Font.font((double)14.0));
                textArray2[i].setText(lResArray[i].toString() + " : ");
            }
            ActionsUtil.setDevicePropertiesText(device, textArray);
            double d2 = WindowManager.getMainPane().getWidth() - 100.0;
            RegularTable regularTable = new RegularTable(10, 2, 280.0, d2);
            for (int i = 0; i < lResArray.length; ++i) {
                regularTable.add((Node)textArray2[i], 0, i, Pos.CENTER_RIGHT);
                regularTable.add((Node)textArray[i], 1, i, Pos.CENTER_LEFT);
            }
            Text text = new Text(LRes.FINDING_INFO_TEXT.toString());
            text.setFont(Font.font((double)16.0));
            text.setWrappingWidth(d2);
            text.setTextAlignment(TextAlignment.CENTER);
            LoadingAnimation loadingAnimation = new LoadingAnimation(100.0);
            StackPane stackPane = new StackPane(new Node[]{loadingAnimation});
            stackPane.setPrefHeight(50.0);
            VBox vBox = new VBox(new Node[]{text, regularTable, stackPane});
            vBox.setAlignment(Pos.CENTER);
            vBox.setSpacing(10.0);
            WindowManager.setMainContent((Node)GuiUtils.center((Node)vBox), true);
            new Thread(new ActionsDynamic$4(device, textArray)).start();
            return 0;
        };
    }

    public static RunnableMessage REQUIRE_DEVICE_AUTH(Device device) {
        return () -> {
            Log.info("Expecting device authorized");
            if (!device.needAuthorization()) {
                return 0;
            }
            Log.warn("It is not, please authorize it");
            ButtonPane buttonPane = new ButtonPane(LRes.TRY_AGAIN);
            IDClickReceiver iDClickReceiver = buttonPane.getIdClickReceiver();
            DeviceManager.addMessageReceiver(iDClickReceiver);
            DeviceView deviceView = new DeviceView(DeviceView.DEVICE_18_9, 880.0);
            ImageView imageView = new ImageView(DrawableManager.getPng("device_auth.png").toString());
            deviceView.setContent(imageView);
            deviceView.buildCircleTransition(800.0, 2060.0, -1);
            Text text = new Text(LRes.AUTH_DEVICE_TEXT.toString());
            text.setTextAlignment(TextAlignment.CENTER);
            text.setFont(Font.font((double)16.0));
            text.setWrappingWidth(600.0);
            VBox vBox = new VBox(new Node[]{GuiUtils.center((Node)DeviceView.crop(deviceView, 310.0, 570.0)), text});
            vBox.setAlignment(Pos.CENTER);
            vBox.setSpacing(20.0);
            buttonPane.setContent((Node)vBox);
            WindowManager.setMainContent((Node)buttonPane, false);
            int n = -100;
            while (n == -100 && ((n = iDClickReceiver.waitClick()) != -4 || device.needAuthorization() || !device.isConnected())) {
                if (n < 0) {
                    n = -100;
                }
                if (n != 0) continue;
                DeviceManager.refresh(true);
                if (!device.needAuthorization()) break;
                ActionsStatic.RESTART_ADB_SERVER().run();
                if (!device.needAuthorization() && device.isConnected()) break;
                WindowManager.setMainContent((Node)buttonPane, false);
                n = -100;
            }
            DeviceManager.removeMessageReceiver(iDClickReceiver);
            WindowManager.removeTopContent();
            return 1;
        };
    }

    public static RunnableMessage REBOOT_DEVICE(Device device, Device$Status device$Status) {
        return ActionsDynamic.REBOOT_DEVICE(device, device$Status, true);
    }

    public static RunnableMessage REBOOT_DEVICE(Device device, Device$Status device$Status, boolean bl) {
        return () -> {
            Log.info("Rebooting device visual");
            boolean bl2 = false;
            try {
                bl2 = bl ? device.reboot(device$Status) : device.rebootNoWait(device$Status);
            }
            catch (AdbException adbException) {
                Log.error("Failed to reboot the device: " + adbException.getMessage());
            }
            return bl2 ? 1 : 0;
        };
    }

    public static RunnableMessage START_PROCEDURE(Device device, RInstall rInstall, ProcedureRunner procedureRunner, RInstall rInstall2) {
        return new ActionsDynamic$5(rInstall, device, procedureRunner, rInstall2);
    }

    public static RunnableMessage HOWTO_GO_RECOVERY(Device device) {
        return ActionsDynamic.HOWTO_GO_RECOVERY(true, device);
    }

    public static RunnableMessage HOWTO_GO_FASTBOOT(Device device, boolean bl) {
        return () -> {
            ButtonPane buttonPane = bl ? new ButtonPane(LRes.OK_FINISHED, LRes.FAILED_TO_DO_THAT) : new ButtonPane(LRes.OK_FINISHED);
            DeviceFastbootView deviceFastbootView = new DeviceFastbootView(DeviceView.DEVICE_18_9, 640.0);
            deviceFastbootView.animate(-1, 3000L);
            SidePane sidePane = new SidePane();
            Text text = new Text(LRes.ENTER_FASTBOOT_MODE.toString());
            text.setWrappingWidth(400.0);
            text.setFont(Font.font((double)15.0));
            sidePane.setLeft((Node)text);
            Pane pane = DeviceView.crop(deviceFastbootView, 410.0);
            sidePane.setRight((Node)GuiUtils.center((Node)pane));
            buttonPane.setContent((Node)sidePane);
            WindowManager.setMainContent((Node)buttonPane, false);
            DeviceManager.addMessageReceiver(buttonPane.getIdClickReceiver());
            int n = -100;
            int n2 = 0;
            while (n < 0) {
                if (device != null && device.isConnected() && Device$Status.FASTBOOT.equals((Object)device.getStatus())) {
                    n2 = 1;
                    break;
                }
                if (device == null) {
                    for (Device device2 : DeviceManager.getDevices()) {
                        if (!device2.isConnected() || !Device$Status.FASTBOOT.equals((Object)device2.getStatus())) continue;
                        n2 = 2;
                    }
                }
                n = buttonPane.waitClick();
            }
            if (n != 0 && n2 == 0) {
                n2 = -1;
            }
            DeviceManager.removeMessageReceiver(buttonPane.getIdClickReceiver());
            WindowManager.removeTopContent();
            return n2;
        };
    }

    public static RunnableMessage HOWTO_GO_RECOVERY(boolean bl, Device device) {
        return () -> {
            String string;
            ButtonPane buttonPane = new ButtonPane(LRes.OK_FINISHED);
            SidePane sidePane = new SidePane();
            DeviceRecoveryView deviceRecoveryView = new DeviceRecoveryView(DeviceView.DEVICE_18_9, 640.0);
            if (bl) {
                deviceRecoveryView.animateSelectThird(3000L);
                string = LRes.ENTER_STOCK_RECOVERY_MODE.toString(LRes.OK_FINISHED.toString());
            } else {
                deviceRecoveryView.animateTurnOnSelectThird(3000L);
                string = "1) " + LRes.BTN_VOLUP_POW.toString() + "\n2) " + LRes.HT_RECOVERY_TEXT_1.toString();
            }
            Text text = new Text(string);
            text.setWrappingWidth(400.0);
            text.setFont(Font.font((double)15.0));
            sidePane.setLeft((Node)text);
            Pane pane = DeviceView.crop(deviceRecoveryView, 410.0);
            sidePane.setRight((Node)GuiUtils.center((Node)pane));
            buttonPane.setContent((Node)sidePane);
            WindowManager.setMainContent((Node)buttonPane, false);
            DeviceManager.addMessageReceiver(buttonPane.getIdClickReceiver());
            int n = -100;
            int n2 = 0;
            while (n < 0) {
                n2 = 0;
                if (device != null && device.isConnected() && (Device$Status.SIDELOAD.equals((Object)device.getStatus()) || Device$Status.RECOVERY.equals((Object)device.getStatus()))) {
                    n2 = 1;
                    break;
                }
                n = buttonPane.waitClick();
            }
            DeviceManager.removeMessageReceiver(buttonPane.getIdClickReceiver());
            WindowManager.removeTopContent();
            return n2;
        };
    }

    public static RunnableMessage HOW_TO_ENABLE_USB_DEBUGGING(Device device, boolean bl) {
        return new ActionsDynamic$6(bl, device);
    }

    public static RunnableMessage SELECT_DEVICE_CODENAME(Pointer pointer, HashMap<String, String> hashMap) {
        return new ActionsDynamic$7(hashMap, pointer);
    }
}

