/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui;

import com.xiaomitool.v2.gui.GuiUtils$1;
import com.xiaomitool.v2.gui.GuiUtils$2;
import com.xiaomitool.v2.gui.GuiUtils$3;
import com.xiaomitool.v2.gui.GuiUtils$GetViewport;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.utility.NotNull;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Application;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

public class GuiUtils {
    private static ExecutorService guiWaitThread = Executors.newSingleThreadExecutor();

    public static Background backgroundFromColor(Paint paint) {
        return new Background(new BackgroundFill[]{new BackgroundFill(paint, null, null)});
    }

    public static void init() {
        Application.setUserAgentStylesheet((String)"MODENA");
    }

    public static void setViewportChange(ImageView imageView, GuiUtils$GetViewport guiUtils$GetViewport) {
        imageView.setOnMouseEntered(mouseEvent -> {
            if (!guiUtils$GetViewport.isPressed) {
                imageView.setViewport(guiUtils$GetViewport.get(1));
            }
            guiUtils$GetViewport.isHover = true;
        });
        imageView.setOnMouseExited(mouseEvent -> {
            if (!guiUtils$GetViewport.isPressed) {
                imageView.setViewport(guiUtils$GetViewport.get(0));
            }
            guiUtils$GetViewport.isHover = false;
        });
        imageView.setOnMousePressed(mouseEvent -> {
            imageView.setViewport(guiUtils$GetViewport.get(2));
            guiUtils$GetViewport.isPressed = true;
        });
        imageView.setOnMouseReleased(mouseEvent -> {
            imageView.setViewport(guiUtils$GetViewport.get(guiUtils$GetViewport.isHover ? 1 : 0));
            guiUtils$GetViewport.isPressed = false;
        });
    }

    public static Pane center(Node node) {
        HBox hBox = new HBox(new Node[]{node});
        VBox vBox = new VBox(new Node[]{hBox});
        vBox.setAlignment(Pos.CENTER);
        hBox.setAlignment(Pos.CENTER);
        return vBox;
    }

    public static void waitGui(long l, Runnable runnable) {
        GuiUtils$1 guiUtils$1 = new GuiUtils$1(l, runnable);
        guiWaitThread.submit(guiUtils$1);
    }

    public static void tooltip(Node node, LRes lRes) {
        GuiUtils.tooltip(node, lRes.toString());
    }

    public static void tooltip(Node node, String string) {
        Tooltip.install((Node)node, (Tooltip)new Tooltip(string));
    }

    public static Pane debug(Pane pane) {
        GuiUtils.debug(pane, Color.ALICEBLUE);
        return pane;
    }

    public static Pane debug(Pane pane, Color color) {
        pane.setBackground(GuiUtils.backgroundFromColor((Paint)color));
        return pane;
    }

    public static Pane crop(Pane pane, double d2, double d3, double d4, double d5) {
        pane.setLayoutY(-1.0 * d3);
        pane.setLayoutX(-1.0 * d2);
        Pane pane2 = new Pane(new Node[]{pane});
        pane2.setClip((Node)new Rectangle(d4, d5));
        pane2.setPrefSize(d4, d5);
        pane2.setMaxSize(d4, d5);
        return pane2;
    }

    public static boolean hasParent(Node node, Parent parent) {
        for (Parent parent2 = node.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            if (parent2 != parent) continue;
            return true;
        }
        return false;
    }

    public static double distanceBetween(@NotNull Node node, @NotNull Node node2) {
        if (node2 == null) {
            return -1.0;
        }
        double[] dArray = GuiUtils.getCenterCoordinates(node2);
        if (dArray == null) {
            return -1.0;
        }
        return GuiUtils.distanceBetween(node, dArray[0], dArray[1]);
    }

    public static double distanceBetween(@NotNull Node node, double d2, double d3) {
        if (node == null) {
            return -1.0;
        }
        double[] dArray = GuiUtils.getCenterCoordinates(node);
        if (dArray == null) {
            return -1.0;
        }
        return GuiUtils.distanceBetween(dArray[0], dArray[1], d2, d3);
    }

    public static double distanceBetween(double d2, double d3, double d4, double d5) {
        return Math.sqrt(Math.pow(d2 - d4, 2.0) + Math.pow(d3 - d5, 2.0));
    }

    public static double[] getCenterCoordinates(@NotNull Node node) {
        if (node == null || node.getBoundsInLocal() == null) {
            return null;
        }
        Bounds bounds = node.localToScene(node.getBoundsInLocal());
        double d2 = (bounds.getMinX() + bounds.getMaxX()) / 2.0;
        double d3 = (bounds.getMinY() + bounds.getMaxY()) / 2.0;
        if (d2 <= 0.0 || d3 <= 0.0) {
            return null;
        }
        return new double[]{d2, d3};
    }

    public static void specialComboBox(ComboBox<String> comboBox, LRes lRes, int n) {
        comboBox.setButtonCell((ListCell)new GuiUtils$2(n, lRes));
        comboBox.setCellFactory((Callback)new GuiUtils$3(n));
    }
}

