/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.controller;

import com.xiaomitool.v2.gui.GuiUtils;
import com.xiaomitool.v2.gui.controller.DefaultController$1;
import com.xiaomitool.v2.gui.controller.DefaultController$2;
import com.xiaomitool.v2.gui.controller.DefaultController$3;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.utility.RunnableMessage;
import com.xiaomitool.v2.utility.WaitSemaphore;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;

public abstract class DefaultController {
    protected Stage primaryStage;
    private WaitSemaphore waitCloseSemaphre = new WaitSemaphore(0);
    private double stageX;
    private double stageY;
    private RunnableMessage onBeforeClose = null;

    public DefaultController() {
    }

    public DefaultController(Stage stage) {
        this.primaryStage = stage;
    }

    public WaitSemaphore getWaitCloseSemaphre() {
        return this.waitCloseSemaphre;
    }

    protected void initHeaderDrag(Node node) {
        node.setOnMousePressed(mouseEvent -> {
            node.setCursor(Cursor.CLOSED_HAND);
            this.stageX = mouseEvent.getSceneX();
            this.stageY = mouseEvent.getSceneY();
        });
        node.setOnMouseReleased(mouseEvent -> {
            node.setCursor(Cursor.DEFAULT);
            this.stageX = mouseEvent.getSceneX();
            this.stageY = mouseEvent.getSceneY();
        });
        node.setOnMouseDragged(mouseEvent -> {
            this.primaryStage.setX(mouseEvent.getScreenX() - this.stageX);
            this.primaryStage.setY(mouseEvent.getScreenY() - this.stageY);
        });
    }

    public void setPrimaryStage(Stage stage) {
        this.primaryStage = stage;
    }

    public void setOnBeforeClose(RunnableMessage runnableMessage) {
        this.onBeforeClose = runnableMessage;
    }

    public void closeWindow() {
        this.closeWindow(false);
    }

    public void closeWindow(boolean bl) {
        DefaultController$1 defaultController$1 = new DefaultController$1(this, bl);
        if (Platform.isFxApplicationThread()) {
            new Thread(defaultController$1).start();
        } else {
            defaultController$1.run();
        }
    }

    protected void setCloseImage(ImageView imageView) {
        this.setCloseImage(imageView, false);
    }

    protected void setCloseImage(ImageView imageView, boolean bl) {
        imageView.setOnMouseClicked(mouseEvent -> this.closeWindow(bl));
        GuiUtils.tooltip((Node)imageView, LRes.TIP_WINDOW_CLOSE);
        GuiUtils.setViewportChange(imageView, new DefaultController$2(this));
    }

    protected void setMinifyImage(ImageView imageView) {
        imageView.setOnMouseClicked(mouseEvent -> this.primaryStage.setIconified(true));
        GuiUtils.tooltip((Node)imageView, LRes.TIP_WINDOW_MINIMIZE);
        GuiUtils.setViewportChange(imageView, new DefaultController$3(this));
    }

    @FXML
    protected abstract void initialize();

    static /* synthetic */ RunnableMessage access$000(DefaultController defaultController) {
        return defaultController.onBeforeClose;
    }

    static /* synthetic */ WaitSemaphore access$100(DefaultController defaultController) {
        return defaultController.waitCloseSemaphre;
    }
}

