/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.deviceView;

import com.mortennobel.imagescaling.MultiStepRescaleOp;
import com.xiaomitool.v2.gui.GuiUtils;
import com.xiaomitool.v2.gui.deviceView.DeviceImage;
import com.xiaomitool.v2.gui.deviceView.DeviceView$1;
import com.xiaomitool.v2.gui.deviceView.DeviceView$2;
import com.xiaomitool.v2.gui.deviceView.DeviceView$3;
import com.xiaomitool.v2.gui.deviceView.DeviceView$4;
import com.xiaomitool.v2.gui.deviceView.DeviceView$5;
import com.xiaomitool.v2.gui.deviceView.DeviceView$6;
import com.xiaomitool.v2.gui.deviceView.DeviceView$ButtonPosition;
import com.xiaomitool.v2.gui.drawable.DrawableManager;
import com.xiaomitool.v2.gui.visual.OverlayPane;
import com.xiaomitool.v2.utility.Nullable;
import com.xiaomitool.v2.utility.Pointer;
import com.xiaomitool.v2.utility.utils.NumberUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class DeviceView
extends StackPane {
    public static final DeviceImage DEVICE_16_9 = new DeviceImage(new Image(DrawableManager.getPng("device16_9").toString()), 220.0, 35.0, 1920.0, 1080.0, 2360.0, 1160.0, new DeviceView$ButtonPosition(410.0, 1150.0, 10.0, 200.0), new DeviceView$ButtonPosition(610.0, 1150.0, 10.0, 200.0), new DeviceView$ButtonPosition(880.0, 1150.0, 10.0, 200.0));
    public static final DeviceImage DEVICE_18_9 = new DeviceImage(new Image(DrawableManager.getPng("device18_9").toString()), 130.0, 25.0, 2160.0, 1080.0, 2420.0, 1140.0, new DeviceView$ButtonPosition(300.0, 1130.0, 10.0, 200.0), new DeviceView$ButtonPosition(500.0, 1130.0, 10.0, 200.0), new DeviceView$ButtonPosition(800.0, 1130.0, 10.0, 200.0));
    private final ConcurrentLinkedQueue<Transition> circlesAnimation = new ConcurrentLinkedQueue();
    protected DeviceImage deviceImage;
    protected double wantedHeight;
    protected double scaleRatio;
    protected Pane containerPane;
    protected Pane imageWrapPane;
    protected double contentScaleRatio;
    protected double imageOffsetX;
    protected double imageOffsetY;
    protected boolean keepRatio;
    private ImageView deviceBorders;
    private ImageView displayedImageView;
    private javafx.scene.paint.Color background = javafx.scene.paint.Color.rgb((int)49, (int)53, (int)57);
    private javafx.scene.paint.Color innerShadow = javafx.scene.paint.Color.BLACK;
    private StackPane contentPane;
    private Image displayedImage;

    public DeviceView(DeviceImage deviceImage, double d2) {
        this(deviceImage, d2, null, null);
    }

    public DeviceView(DeviceImage deviceImage, double d2, @Nullable javafx.scene.paint.Color color, @Nullable javafx.scene.paint.Color color2) {
        if (color != null) {
            this.background = color;
        }
        if (color2 != null) {
            this.innerShadow = color2;
        }
        this.deviceImage = deviceImage;
        this.wantedHeight = d2;
        super.setPrefHeight(d2);
        this.build();
    }

    public static Pane crop(DeviceView deviceView, double d2, double d3) {
        return GuiUtils.crop((Pane)deviceView, 0.0, d3, deviceView.getWantedHeight() / deviceView.getOuterAspectRatio(), d2);
    }

    public static Pane crop(DeviceView deviceView, double d2) {
        return DeviceView.crop(deviceView, d2, 0.0);
    }

    public double getWantedHeight() {
        return this.wantedHeight;
    }

    private void build() {
        this.deviceBorders = new ImageView(this.deviceImage.getDeviceImage());
        this.deviceBorders.setPreserveRatio(true);
        this.deviceBorders.setFitHeight(this.wantedHeight);
        this.scaleRatio = this.wantedHeight / this.deviceImage.getOuterHeight();
        this.contentPane = new StackPane();
        this.contentPane.setBackground(GuiUtils.backgroundFromColor((Paint)this.background));
        this.contentPane.setPrefHeight(this.scaleRatio * this.deviceImage.getInnerHeight() + 4.0);
        this.contentPane.setPrefWidth(this.scaleRatio * this.deviceImage.getInnerWidth() + 4.0);
        this.contentPane.setEffect((Effect)new InnerShadow(0.1 * this.deviceImage.getInnerWidth() * this.scaleRatio, this.innerShadow));
        this.contentPane.setLayoutX(this.deviceImage.getLeftOffset() * this.scaleRatio - 2.0);
        this.contentPane.setLayoutY(this.deviceImage.getTopOffset() * this.scaleRatio - 2.0);
        this.contentPane.setPadding(new Insets(2.0, 0.0, 0.0, 2.0));
        Pane pane = new Pane(new Node[]{this.contentPane});
        StackPane stackPane = new StackPane(new Node[]{pane, this.deviceBorders});
        this.containerPane = new Pane(new Node[]{stackPane});
        this.containerPane.setPrefHeight(this.wantedHeight + 4.0);
        super.getChildren().add((Object)this.containerPane);
    }

    public void setContent(ImageView imageView) {
        this.setContent(imageView, false);
    }

    public void setContent(Image image) {
        this.setContent(new ImageView(image));
    }

    public void setContent(Image image, boolean bl) {
        this.setContent(new ImageView(image), bl);
    }

    public void setContent(URL uRL) {
        this.setContent(new Image(uRL.toString()));
    }

    public void setContent(URL uRL, boolean bl) {
        this.setContent(new Image(uRL.toString(), false), bl);
    }

    public double getOuterAspectRatio() {
        return this.deviceImage.getOuterHeight() / this.deviceImage.getOuterWidth();
    }

    public double getInnerAspectRatio() {
        return this.deviceImage.getInnerHeight() / this.deviceImage.getInnerWidth();
    }

    private double getInnerHeight() {
        return this.deviceImage.getInnerHeight() * this.scaleRatio;
    }

    private double getInnerWidth() {
        return this.deviceImage.getInnerWidth() * this.scaleRatio;
    }

    public void setContent(javafx.scene.paint.Color color) {
        Color color2 = new Color((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getOpacity());
        BufferedImage bufferedImage = new BufferedImage((int)this.deviceImage.getInnerWidth(), (int)this.deviceImage.getInnerHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(color2);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.setContent((Image)SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null));
    }

    public void setContent(ImageView imageView, boolean bl) {
        Rectangle2D rectangle2D;
        int n;
        int n2;
        this.keepRatio = bl;
        this.displayedImage = imageView.getImage();
        double d2 = this.displayedImage.getHeight() / this.displayedImage.getWidth();
        if (d2 < this.getInnerAspectRatio()) {
            n2 = NumberUtils.double2int(this.getInnerWidth());
            n = NumberUtils.double2int(bl ? (double)n2 * d2 : this.getInnerHeight());
            this.imageOffsetY = bl ? (this.getInnerHeight() - (double)n) / 2.0 : 0.0;
            this.imageOffsetX = 0.0;
            rectangle2D = bl ? new Rectangle2D(0.0, -1.0 * this.imageOffsetY, this.getInnerWidth(), this.getInnerHeight()) : null;
        } else {
            n = NumberUtils.double2int(this.getInnerHeight());
            n2 = NumberUtils.double2int(bl ? (double)n / d2 : this.getInnerWidth());
            this.imageOffsetX = bl ? (this.getInnerWidth() - (double)n2) / 2.0 : 0.0;
            this.imageOffsetY = 0.0;
            rectangle2D = bl ? new Rectangle2D(-1.0 * this.imageOffsetX, 0.0, this.getInnerWidth(), this.getInnerHeight()) : null;
        }
        this.contentScaleRatio = (double)n / this.displayedImage.getHeight();
        BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)imageView.getImage(), null);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n, bufferedImage.getType());
        MultiStepRescaleOp multiStepRescaleOp = new MultiStepRescaleOp(n2, n, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        multiStepRescaleOp.doFilter(bufferedImage, bufferedImage2, n2, n);
        multiStepRescaleOp = SwingFXUtils.toFXImage((BufferedImage)bufferedImage2, null);
        imageView.setImage((Image)multiStepRescaleOp);
        if (rectangle2D != null) {
            imageView.setViewport(rectangle2D);
        }
        imageView.setFitWidth((double)NumberUtils.double2int(this.getInnerWidth()));
        imageView.setFitHeight((double)NumberUtils.double2int(this.getInnerHeight()));
        this.contentPane.getChildren().clear();
        this.displayedImageView = imageView;
        this.imageWrapPane = new Pane(new Node[]{imageView});
        this.contentPane.getChildren().clear();
        this.contentPane.getChildren().add((Object)GuiUtils.center((Node)this.imageWrapPane));
    }

    public void setLenOverlay(OverlayPane overlayPane, double d2, double d3) {
        if (this.displayedImageView == null) {
            return;
        }
        Pane pane = new Pane();
        pane.setPrefSize(d2 + 2.0, d2 + 2.0);
        pane.setPickOnBounds(false);
        pane.setLayoutX(-d2);
        pane.setLayoutY(-d2);
        pane.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)javafx.scene.paint.Color.BLACK, BorderStrokeStyle.SOLID, null, new BorderWidths(1.0))}));
        pane.setVisible(false);
        ImageView imageView = new ImageView(this.displayedImage);
        imageView.setViewport(new Rectangle2D(0.0, 0.0, d2, d2));
        imageView.setPreserveRatio(true);
        imageView.setFitHeight(d2);
        imageView.setFitWidth(d2);
        imageView.setLayoutX(1.0);
        imageView.setLayoutY(1.0);
        pane.getChildren().add((Object)imageView);
        overlayPane.getChildren().add((Object)pane);
        Pointer pointer = new Pointer();
        pointer.pointed = d3;
        this.displayedImageView.setOnMouseEntered((EventHandler)new DeviceView$1(this, pane));
        this.displayedImageView.setOnMouseExited((EventHandler)new DeviceView$2(this, pane));
        this.displayedImageView.setCursor(Cursor.CROSSHAIR);
        this.displayedImageView.setOnMouseMoved((EventHandler)new DeviceView$3(this, d2, overlayPane, pane, pointer, imageView));
    }

    public Transition setClickVolumeDown(int n) {
        DeviceView$ButtonPosition deviceView$ButtonPosition = this.deviceImage.getVolumeDown();
        return this.setClick(deviceView$ButtonPosition, n);
    }

    public Pane getImagePane() {
        return this.containerPane;
    }

    public void setImageBackground(Background background) {
        if (this.contentPane != null) {
            this.contentPane.setBackground(background);
        }
    }

    public void setBackgroundColor(javafx.scene.paint.Color color) {
        this.setImageBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, null, null)}));
    }

    public Transition setClickVolumeUp(int n) {
        DeviceView$ButtonPosition deviceView$ButtonPosition = this.deviceImage.getVolumeUp();
        return this.setClick(deviceView$ButtonPosition, n);
    }

    public Transition setClickPower(int n) {
        DeviceView$ButtonPosition deviceView$ButtonPosition = this.deviceImage.getPower();
        return this.setClick(deviceView$ButtonPosition, n);
    }

    private Transition setClick(DeviceView$ButtonPosition deviceView$ButtonPosition, int n) {
        if (deviceView$ButtonPosition == null) {
            return null;
        }
        Rectangle rectangle = new Rectangle(deviceView$ButtonPosition.left * this.scaleRatio, deviceView$ButtonPosition.top * this.scaleRatio, deviceView$ButtonPosition.width * this.scaleRatio, deviceView$ButtonPosition.height * this.scaleRatio);
        double d2 = deviceView$ButtonPosition.left + deviceView$ButtonPosition.width / 2.0;
        double d3 = deviceView$ButtonPosition.top + deviceView$ButtonPosition.height / 2.0;
        rectangle.setFill((Paint)javafx.scene.paint.Color.RED);
        this.containerPane.getChildren().add((Object)rectangle);
        Transition transition = this.buildCircleTransition(d2, d3, n, false, false);
        transition.statusProperty().addListener((observableValue, status, status2) -> {
            if (Animation.Status.STOPPED.equals(status2)) {
                this.containerPane.getChildren().removeAll((Object[])new Node[]{rectangle});
            }
        });
        return transition;
    }

    public double getScaleRatio() {
        return this.scaleRatio;
    }

    public Transition buildCircleTransition(double d2, double d3, int n) {
        return this.buildCircleTransition(d2, d3, n, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCircleAnimation() {
        ConcurrentLinkedQueue<Transition> concurrentLinkedQueue = this.circlesAnimation;
        synchronized (concurrentLinkedQueue) {
            for (Transition transition : this.circlesAnimation) {
                transition.stop();
            }
            this.circlesAnimation.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transition buildCircleTransition(double d2, double d3, int n, boolean bl, boolean bl2) {
        if (!Platform.isFxApplicationThread()) {
            CompletableFuture completableFuture = new CompletableFuture();
            Platform.runLater((Runnable)new DeviceView$4(this, completableFuture, d2, d3, n, bl, bl2));
            try {
                return (Transition)completableFuture.get();
            }
            catch (InterruptedException interruptedException) {
                this.removeCircleAnimation();
                return null;
            }
            catch (ExecutionException executionException) {
                this.removeCircleAnimation();
                return null;
            }
        }
        if (bl2) {
            this.removeCircleAnimation();
        }
        Circle circle = new Circle(d2 * this.scaleRatio + (bl ? this.deviceImage.getLeftOffset() * this.scaleRatio + this.imageOffsetX : 0.0), d3 * this.scaleRatio + (bl ? this.imageOffsetY + this.deviceImage.getTopOffset() * this.scaleRatio : 0.0), this.wantedHeight / 12.0);
        circle.setStroke((Paint)javafx.scene.paint.Color.RED);
        circle.setStrokeWidth(3.0);
        circle.setFill((Paint)javafx.scene.paint.Color.TRANSPARENT);
        circle.setVisible(false);
        circle.setOpacity(0.0);
        circle.setMouseTransparent(true);
        Transition transition = this.getCircleTransition(circle, n);
        this.containerPane.getChildren().add((Object)circle);
        transition.statusProperty().addListener((ChangeListener)new DeviceView$5(this, circle));
        transition.play();
        ConcurrentLinkedQueue<Transition> concurrentLinkedQueue = this.circlesAnimation;
        synchronized (concurrentLinkedQueue) {
            this.circlesAnimation.add(transition);
        }
        return transition;
    }

    private Transition getCircleTransition(Circle circle, int n) {
        ScaleTransition scaleTransition = new ScaleTransition(Duration.millis((double)1500.0), (Node)circle);
        scaleTransition.setFromX(0.0);
        scaleTransition.setFromY(0.0);
        scaleTransition.setToX(1.0);
        scaleTransition.setToY(1.0);
        scaleTransition.setAutoReverse(false);
        scaleTransition.setCycleCount(n);
        FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)1500.0), (Node)circle);
        fadeTransition.setFromValue(1.0);
        fadeTransition.setToValue(0.0);
        fadeTransition.setAutoReverse(false);
        fadeTransition.setCycleCount(n);
        fadeTransition.setInterpolator((Interpolator)new DeviceView$6(this));
        return new ParallelTransition(new Animation[]{scaleTransition, fadeTransition});
    }

    static /* synthetic */ Image access$000(DeviceView deviceView) {
        return deviceView.displayedImage;
    }
}

