/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.visual.CustomButton;
import com.xiaomitool.v2.gui.visual.IDClickReceiver;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.utility.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class ButtonPane
extends VBox {
    private double buttonHeight = 50.0;
    private StackPane contentPane;
    private List<CustomButton> buttons = new ArrayList<CustomButton>();
    private IDClickReceiver idClickReceiver = new IDClickReceiver();

    public ButtonPane(String ... stringArray) {
        this(Arrays.asList(stringArray), -1);
    }

    public ButtonPane(LRes ... lResArray) {
        ArrayList<String> arrayList = new ArrayList<String>(lResArray.length);
        for (LRes lRes : lResArray) {
            arrayList.add(lRes.toString());
        }
        this.build(arrayList);
    }

    public ButtonPane(Iterable<String> iterable, int n) {
        this.buttonHeight = n > 0 ? (double)n : this.buttonHeight;
        this.build(iterable);
    }

    private void build(Iterable<String> iterable) {
        super.setAlignment(Pos.BOTTOM_CENTER);
        HBox hBox = new HBox();
        hBox.setPrefHeight(this.buttonHeight);
        hBox.setMinHeight(this.buttonHeight);
        this.contentPane = new StackPane();
        this.contentPane.setPrefHeight(5000.0);
        this.buildButtons(hBox, iterable);
        super.getChildren().addAll((Object[])new Node[]{this.contentPane, hBox});
    }

    private void buildButtons(HBox hBox, Iterable<String> iterable) {
        hBox.setSpacing(20.0);
        hBox.setAlignment(Pos.CENTER);
        int n = 0;
        double d2 = this.buttonHeight / 3.333;
        double d3 = this.findButtonSize(iterable, d2) + 30.0;
        for (String string : iterable) {
            CustomButton customButton = new CustomButton(string);
            customButton.setPrefHeight(0.7 * this.buttonHeight);
            customButton.setPrefWidth(d3);
            customButton.setMinWidth(3.0 * this.buttonHeight);
            customButton.setFont(Font.font((double)d2));
            customButton.setText(string);
            hBox.getChildren().add((Object)customButton);
            this.buttons.add(customButton);
            this.idClickReceiver.addNode((Node)customButton);
            ++n;
        }
    }

    public List<CustomButton> getButtons() {
        return this.buttons;
    }

    public void setContentText(@NotNull LRes lRes) {
        this.setContentText(lRes.toString());
    }

    public void setContentText(String string) {
        Text text = new Text(string);
        text.setFont(Font.font((double)16.0));
        text.setWrappingWidth(WindowManager.getContentWidth() - 150.0);
        text.setTextAlignment(TextAlignment.CENTER);
        this.setContent((Node)text);
    }

    private double findButtonSize(Iterable<String> iterable, double d2) {
        double d3 = 0.0;
        for (String string : iterable) {
            Text text = new Text(string);
            text.setFont(Font.font((double)d2));
            double d4 = text.getLayoutBounds().getWidth();
            d3 = Double.max(d3, d4);
        }
        return d3;
    }

    public int waitClick() {
        return this.idClickReceiver.waitClick();
    }

    public IDClickReceiver getIdClickReceiver() {
        return this.idClickReceiver;
    }

    public void setContent(Node node) {
        this.contentPane.getChildren().add((Object)node);
    }
}

