/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.gui.GuiUtils;
import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.visual.ChooserPane$1;
import com.xiaomitool.v2.gui.visual.ChooserPane$2;
import com.xiaomitool.v2.gui.visual.ChooserPane$Choice;
import com.xiaomitool.v2.gui.visual.IDClickReceiver;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class ChooserPane
extends StackPane {
    private static final Background CHOICE_BG = GuiUtils.backgroundFromColor((Paint)Color.web((String)"#ffd1b3"));
    private static final Background CHOICE_BG_HOVER = GuiUtils.backgroundFromColor((Paint)Color.web((String)"#ffb380"));
    private static final DropShadow CHOICE_DROPSHADOW = new DropShadow(10.0, Color.gray((double)0.9));
    private static final DropShadow CHOICE_DROPSHADOW_HOVER = new DropShadow(10.0, Color.gray((double)0.7));
    private IDClickReceiver idClickReceiver = new IDClickReceiver();
    private double maxChoicesWidth = WindowManager.getContentWidth() - 100.0;
    private ChooserPane$Choice[] choices;

    public ChooserPane(ChooserPane$Choice ... chooserPane$ChoiceArray) {
        this.choices = chooserPane$ChoiceArray;
        this.build();
    }

    public IDClickReceiver getIdClickReceiver() {
        return this.idClickReceiver;
    }

    private void build() {
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(20.0));
        ObservableList observableList = vBox.getChildren();
        for (ChooserPane$Choice chooserPane$Choice : this.choices) {
            observableList.add((Object)this.buildChoice(chooserPane$Choice));
        }
        vBox.setSpacing(20.0);
        vBox.setAlignment(Pos.CENTER);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setContent((Node)GuiUtils.center((Node)vBox));
        scrollPane.setPrefWidth(5000.0);
        scrollPane.setPrefViewportWidth(5000.0);
        super.setPrefWidth(5000.0);
        scrollPane.setFitToWidth(true);
        scrollPane.setStyle("-fx-background: rgba(245,245,245,0); -fx-background-color: rgba(245,245,245,0);");
        super.getChildren().add((Object)scrollPane);
    }

    private Node buildChoice(ChooserPane$Choice chooserPane$Choice) {
        Pane pane = new Pane();
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER_LEFT);
        pane.setPrefSize(50.0, 50.0);
        HBox hBox = new HBox(new Node[]{pane, vBox});
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.setSpacing(10.0);
        Text text = new Text(chooserPane$Choice.getTitle());
        text.setFont(Font.font(null, (FontWeight)FontWeight.SEMI_BOLD, (double)18.0));
        Text text2 = new Text(chooserPane$Choice.getSubtext());
        text2.setFont(Font.font((double)14.0));
        Image image = chooserPane$Choice.getImage();
        if (image != null) {
            ImageView imageView = new ImageView(image);
            imageView.setFitWidth(50.0);
            imageView.setPreserveRatio(true);
            pane.getChildren().add((Object)imageView);
        }
        double d2 = text.getLayoutBounds().getWidth();
        double d3 = text2.getLayoutBounds().getWidth();
        if (d2 > this.maxChoicesWidth || d3 > this.maxChoicesWidth) {
            text.setWrappingWidth(this.maxChoicesWidth);
            text2.setWrappingWidth(this.maxChoicesWidth);
        }
        hBox.setMinWidth(230.0);
        vBox.getChildren().addAll((Object[])new Node[]{text, text2});
        hBox.setOnMouseEntered((EventHandler)new ChooserPane$1(this, hBox));
        hBox.setOnMouseExited((EventHandler)new ChooserPane$2(this, hBox));
        hBox.setCursor(Cursor.HAND);
        hBox.setPadding(new Insets(10.0));
        hBox.setBackground(CHOICE_BG);
        hBox.setEffect((Effect)CHOICE_DROPSHADOW);
        this.idClickReceiver.addNode((Node)hBox);
        return hBox;
    }

    static /* synthetic */ Background access$000() {
        return CHOICE_BG_HOVER;
    }

    static /* synthetic */ DropShadow access$100() {
        return CHOICE_DROPSHADOW_HOVER;
    }

    static /* synthetic */ Background access$200() {
        return CHOICE_BG;
    }

    static /* synthetic */ DropShadow access$300() {
        return CHOICE_DROPSHADOW;
    }
}

