/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.gui.visual.DragAndDropPane$1;
import com.xiaomitool.v2.gui.visual.DragAndDropPane$2;
import com.xiaomitool.v2.gui.visual.DragAndDropPane$3;
import com.xiaomitool.v2.gui.visual.DragAndDropPane$4;
import com.xiaomitool.v2.language.LRes;
import java.io.File;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import org.apache.commons.io.FilenameUtils;

public class DragAndDropPane
extends StackPane {
    private static final String selectText = LRes.FILE_SELECT_DRAGDROP.toString();
    private double cWidth;
    private double cHeight;
    private FileChooser.ExtensionFilter[] filters;
    private SimpleObjectProperty<File> inputFile = new SimpleObjectProperty();
    private Text insideString;
    private Canvas canvas;
    private VBox content;
    private StackPane empty;
    private StackPane border;

    public DragAndDropPane(double d2, double d3) {
        this.cWidth = d2;
        this.cHeight = d3;
        super.setPrefWidth(d2);
        super.setPrefHeight(d3);
        this.build();
    }

    public File getSelectedFile() {
        return (File)this.inputFile.getValue();
    }

    private Border getBorder(boolean bl) {
        return new Border(new BorderStroke[]{new BorderStroke((Paint)Color.gray((double)0.4), bl ? BorderStrokeStyle.DASHED : BorderStrokeStyle.SOLID, new CornerRadii(0.1, true), new BorderWidths((this.cWidth + this.cHeight) / 100.0))});
    }

    private void build() {
        this.insideString = new Text(selectText);
        this.border = new StackPane();
        this.border.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.gray((double)0.4), BorderStrokeStyle.DASHED, new CornerRadii(0.1, true), new BorderWidths((this.cWidth + this.cHeight) / 100.0))}));
        double d2 = (this.cWidth + this.cHeight) / 8.0;
        this.canvas = new Canvas(d2, d2);
        GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
        graphicsContext.setFill((Paint)Color.gray((double)0.2));
        graphicsContext.fillRect(0.4444444444444444 * d2, 0.0, 0.1111111111111111 * d2, d2);
        graphicsContext.fillRect(0.0, 0.4444444444444444 * d2, d2, 0.1111111111111111 * d2);
        super.setPadding(new Insets(this.cHeight / 12.0, this.cWidth / 12.0, this.cHeight / 12.0, this.cWidth / 12.0));
        this.insideString.setWrappingWidth(this.cWidth * 7.0 / 10.0);
        this.insideString.setTextAlignment(TextAlignment.CENTER);
        double d3 = this.cHeight / 20.0;
        if (d3 > 19.0) {
            d3 = 19.0;
        }
        this.insideString.setFont(Font.font((double)d3));
        double d4 = this.insideString.getLayoutBounds().getHeight();
        this.empty = new StackPane();
        this.empty.setPrefHeight(d4);
        this.content = new VBox(new Node[]{this.insideString, this.canvas, this.empty});
        this.content.setAlignment(Pos.CENTER);
        this.content.setSpacing(this.cHeight / 30.0);
        this.border.getChildren().add((Object)this.content);
        super.getChildren().add((Object)this.border);
        super.setCursor(Cursor.HAND);
        super.setOpacity(0.6);
        super.setOnDragOver((EventHandler)new DragAndDropPane$1(this));
        super.setOnDragDropped((EventHandler)new DragAndDropPane$2(this));
        super.setOnMouseClicked((EventHandler)new DragAndDropPane$3(this));
        this.setOnFileChange(new DragAndDropPane$4(this));
    }

    private void handleFile(File file) {
        String string;
        if (file == null) {
            string = selectText;
            this.content.getChildren().clear();
            this.content.getChildren().addAll((Object[])new Node[]{this.insideString, this.canvas, this.empty});
            this.border.setBorder(this.getBorder(true));
            DragAndDropPane.super.setOpacity(0.6);
        } else {
            string = (Object)((Object)LRes.FILE_SELECTED) + ":\n" + FilenameUtils.getName(file.toString());
            this.content.getChildren().clear();
            this.content.getChildren().addAll((Object[])new Node[]{this.insideString});
            this.border.setBorder(this.getBorder(false));
            DragAndDropPane.super.setOpacity(0.75);
        }
        this.insideString.setText(string);
    }

    public void setOnFileChange(ChangeListener<? super File> changeListener) {
        this.inputFile.addListener(changeListener);
    }

    public void setFilters(FileChooser.ExtensionFilter[] extensionFilterArray) {
        this.filters = extensionFilterArray;
    }

    public void reset() {
        this.handleFile(null);
    }

    static /* synthetic */ FileChooser.ExtensionFilter[] access$000(DragAndDropPane dragAndDropPane) {
        return dragAndDropPane.filters;
    }

    static /* synthetic */ SimpleObjectProperty access$100(DragAndDropPane dragAndDropPane) {
        return dragAndDropPane.inputFile;
    }

    static /* synthetic */ void access$200(DragAndDropPane dragAndDropPane, File file) {
        dragAndDropPane.handleFile(file);
    }
}

