/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomitool.v2.gui.visual;

import com.xiaomitool.v2.gui.WindowManager;
import com.xiaomitool.v2.gui.drawable.DrawableManager;
import com.xiaomitool.v2.gui.visual.ButtonPane;
import com.xiaomitool.v2.language.LRes;
import com.xiaomitool.v2.utility.NotNull;
import com.xiaomitool.v2.utility.Nullable;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class ErrorPane
extends ButtonPane {
    private static Image ERROR_IMAGE;
    private StackPane textZone;
    private StackPane titleZone;
    private final VBox children = new VBox();

    public ErrorPane(String ... stringArray) {
        super(stringArray);
        this.build();
    }

    public ErrorPane(LRes ... lResArray) {
        super(lResArray);
        this.build();
    }

    private Image getErrorImage() {
        if (ERROR_IMAGE == null) {
            ERROR_IMAGE = new Image(DrawableManager.getPng("error.png").toString(), 100.0, 100.0, true, true);
        }
        return ERROR_IMAGE;
    }

    private void build() {
        ImageView imageView = new ImageView(this.getErrorImage());
        imageView.setFitWidth(100.0);
        imageView.setFitHeight(100.0);
        this.titleZone = new StackPane();
        this.textZone = new StackPane();
        VBox vBox = new VBox(new Node[]{new StackPane(new Node[]{imageView}), this.titleZone, this.textZone, this.children});
        vBox.setSpacing(5.0);
        vBox.setAlignment(Pos.CENTER);
        this.children.setAlignment(Pos.CENTER);
        ScrollPane scrollPane = new ScrollPane((Node)vBox);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setStyle("-fx-background: rgba(245,245,245,0); -fx-background-color: rgba(245,245,245,0);");
        super.setContent((Node)scrollPane);
    }

    public void setTitle(String string, @Nullable Paint paint) {
        Text text = new Text(string);
        text.setFont(Font.font((double)17.0));
        if (paint != null) {
            text.setFill(paint);
        }
        text.setTextAlignment(TextAlignment.CENTER);
        text.setWrappingWidth(WindowManager.getContentWidth() - 100.0);
        ObservableList observableList = this.titleZone.getChildren();
        observableList.clear();
        observableList.add((Object)text);
    }

    public void appendContent(Node node) {
        this.children.getChildren().add((Object)node);
    }

    public void setTitle(String string) {
        this.setTitle(string, null);
    }

    public void setTitle(@NotNull LRes lRes) {
        this.setTitle(lRes.toString());
    }

    public void setText(String string, @Nullable Paint paint) {
        Text text = new Text(string);
        text.setFont(Font.font((double)15.0));
        if (paint != null) {
            text.setFill(paint);
        }
        text.setTextAlignment(TextAlignment.CENTER);
        text.setWrappingWidth(WindowManager.getContentWidth() - 100.0);
        ObservableList observableList = this.textZone.getChildren();
        observableList.clear();
        observableList.add((Object)text);
    }

    public void setText(String string) {
        this.setText(string, null);
    }

    public void setText(@NotNull LRes lRes) {
        this.setText(lRes.toString());
    }
}

